package com.xdja.uaac.api;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.util.Log;

/**
 * Author:kongguoguang
 * Date:2018-03-07
 * Time:10:09
 * Summary:
 */

public class UaacApi {

    /**
     * 获取票据
     * @param context
     * @param callback
     */
    public static void getToken(@NonNull Context context, @NonNull TokenCallback callback){

        if (!isUaacInstalled(context)){
            callback.onError("未检测到统一认证，请先安装！");
            return;
        }

        Uri uri = Uri.parse("content://com.xdja.app.pj/" + context.getPackageName());
        ContentResolver resolver = context.getContentResolver();
        Log.d("UaacApi", "Query provider 1");
        Cursor cursor = resolver.query(uri, null, null, null, null);
        if (cursor == null){
            Intent intent = new Intent("com.xdja.uaac.action.start");
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
            Log.d("UaacApi", "Start activity!");

            for (int i = 0; i < 30; i++){
                Log.d("UaacApi", "Query provider " + (i + 2));
                cursor = resolver.query(uri, null, null, null, null);
                if (cursor != null){
                    parseCursor(cursor, callback);
                    return;
                }

                try {
                    Thread.sleep(50);
                } catch (InterruptedException e) {
                        e.printStackTrace();
                }
            }

            callback.onError("未开启统一认证关联启动权限！");

        }else {
            parseCursor(cursor, callback);
        }
    }

    /**
     *
     * @param context
     * @return 0：注销成功；-1：无权调用注销接口
     */
    public static int logoutUaac(@NonNull Context context){
        Uri uri = Uri.parse("content://com.xdja.app.pj/" + context.getPackageName());
        ContentResolver contentResolver = context.getContentResolver();
        int result = 0;
        try {
            result = contentResolver.delete(uri, null, null);
        }catch (Exception e){
            return result;
        }

        return result;
    }

    /**
     * 应用退出时通知统一认证
     * @param context
     */
    public static void notifyLogout(@NonNull Context context){
        Intent intent = new Intent("com.xdja.unifyauthorize.ACTION_THIRD_APP_LOGOUT");
        intent.putExtra("PACKAGE_NAME", context.getPackageName());
        context.sendBroadcast(intent);
    }

    /**
     * 网络诊断
     * @param context
     */
//    public static void diagnosisNetwork(Context context){
//        if (!isUaacInstalled(context)){
//            Toast.makeText(context, "未检测到统一认证，请先安装！", Toast.LENGTH_SHORT).show();
//            return;
//        }
//
//        Uri uri = Uri.parse("content://com.xdja.uaac.provider.uaacprovider");
//        ContentResolver contentResolver = context.getContentResolver();
//        try {
//            contentResolver.call(uri, "networkDiagnosis",null, null);
//        }catch (Exception e){
//            ComponentName componentName = new ComponentName("com.xdja.uaac", "com.xdja.uaac.ui.TransparentActivity");
//            Intent intent = new Intent();
//            intent.setComponent(componentName);
//            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
//            context.startActivity(intent);
//
//            try {
//                contentResolver.call(uri, "networkDiagnosis",null, null);
//            }catch (Exception exception){
//                Toast.makeText(context, "未开启统一认证关联启动权限！", Toast.LENGTH_SHORT).show();
//            }
//        }
//
//    }


    /**
     * 判断统一认证是否安装
     *
     * @param mContext
     * @return
     */
    private static boolean isUaacInstalled(Context mContext) {
        PackageManager mPackageManager = mContext.getPackageManager();
        ApplicationInfo mApplicationInfo = null;
        try {
            mApplicationInfo = mPackageManager.getApplicationInfo("com.xdja.uaac", PackageManager.GET_META_DATA);
            if (mApplicationInfo != null) {
                return true;
            }
        } catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        return false;
    }

    /**
     * 解析统一认证返回的Cursor
     * @param cursor
     * @param callback
     */
    private static void parseCursor(Cursor cursor, TokenCallback callback){
        cursor.moveToFirst();
        int resultCode = cursor.getInt(cursor.getColumnIndex("resultCode"));
        if (resultCode == 0){
            String token = cursor.getString(cursor.getColumnIndex("billStr"));
            callback.onSuccess(token);
        }else {


            String message = cursor.getString(cursor.getColumnIndex("message"));
            callback.onError(message);
        }
        cursor.close();
    }
}
