/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uaac.api;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.util.Log;
import com.xdja.uaac.api.TokenCallback;

public class UaacApi {
    public static void getToken(@NonNull Context context, @NonNull TokenCallback callback) {
        if (!UaacApi.isUaacInstalled(context)) {
            callback.onError("\u672a\u68c0\u6d4b\u5230\u7edf\u4e00\u8ba4\u8bc1\uff0c\u8bf7\u5148\u5b89\u88c5\uff01");
            return;
        }
        Uri uri = Uri.parse((String)("content://com.xdja.app.pj/" + context.getPackageName()));
        ContentResolver resolver = context.getContentResolver();
        Log.d((String)"UaacApi", (String)"Query provider 1");
        Cursor cursor = resolver.query(uri, null, null, null, null);
        if (cursor == null) {
            Intent intent = new Intent("com.xdja.uaac.action.start");
            intent.setFlags(0x10000000);
            context.startActivity(intent);
            Log.d((String)"UaacApi", (String)"Start activity!");
            for (int i = 0; i < 30; ++i) {
                Log.d((String)"UaacApi", (String)("Query provider " + (i + 2)));
                cursor = resolver.query(uri, null, null, null, null);
                if (cursor != null) {
                    UaacApi.parseCursor(cursor, callback);
                    return;
                }
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            callback.onError("\u672a\u5f00\u542f\u7edf\u4e00\u8ba4\u8bc1\u5173\u8054\u542f\u52a8\u6743\u9650\uff01");
        } else {
            UaacApi.parseCursor(cursor, callback);
        }
    }

    public static int logoutUaac(@NonNull Context context) {
        Uri uri = Uri.parse((String)("content://com.xdja.app.pj/" + context.getPackageName()));
        ContentResolver contentResolver = context.getContentResolver();
        int result = 0;
        try {
            result = contentResolver.delete(uri, null, null);
        }
        catch (Exception e) {
            return result;
        }
        return result;
    }

    public static void notifyLogout(@NonNull Context context) {
        Intent intent = new Intent("com.xdja.unifyauthorize.ACTION_THIRD_APP_LOGOUT");
        intent.putExtra("PACKAGE_NAME", context.getPackageName());
        context.sendBroadcast(intent);
    }

    private static boolean isUaacInstalled(Context mContext) {
        PackageManager mPackageManager = mContext.getPackageManager();
        ApplicationInfo mApplicationInfo = null;
        try {
            mApplicationInfo = mPackageManager.getApplicationInfo("com.xdja.uaac", 128);
            if (mApplicationInfo != null) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        return false;
    }

    private static void parseCursor(Cursor cursor, TokenCallback callback) {
        cursor.moveToFirst();
        int resultCode = cursor.getInt(cursor.getColumnIndex("resultCode"));
        if (resultCode == 0) {
            String token = cursor.getString(cursor.getColumnIndex("billStr"));
            callback.onSuccess(token);
        } else {
            String message = cursor.getString(cursor.getColumnIndex("message"));
            callback.onError(message);
        }
        cursor.close();
    }
}

