/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uaac.api;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.uaac.api.CredentialCallback;
import com.xdja.uaac.api.TokenCallback;
import com.xdja.uaac.api.UaacApiCallback;

public class UaacApi {
    private static final String UAAC_ACTION = "com.xdja.uaac.action.TOKEN_CREDENTIAL";

    public static void getCredential(@NonNull Context context, String messageId, String version, String appId, String orgId, String networkAreaCode, String packageName, @NonNull CredentialCallback callback) {
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            packageName = context.getPackageName();
        }
        Bundle bundle = new Bundle();
        bundle.putString("messageId", messageId);
        bundle.putString("version", version);
        bundle.putString("appId", appId);
        bundle.putString("orgId", orgId);
        bundle.putString("networkAreaCode", networkAreaCode);
        bundle.putString("packageName", packageName);
        bundle.putBinder("binder", new UaacApiCallback(callback).asBinder());
        Intent intent = new Intent(UAAC_ACTION);
        intent.putExtra("bundle", bundle);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        try {
            context.startActivity(intent);
        }
        catch (Exception e) {
            Bundle resultBundle = new Bundle();
            resultBundle.putInt("resultCode", -1);
            callback.onResult(resultBundle);
        }
    }

    public static void getToken(@NonNull Context context, @NonNull TokenCallback callback) {
        UaacApi.getToken(context, "", callback);
    }

    public static void getToken(@NonNull Context context, String packageName, @NonNull TokenCallback callback) {
        if (!(UaacApi.isUaacInstalled(context) || UaacApi.isUnifyAuthorizeInstalled(context) || UaacApi.isSafeClientInstalled(context) || UaacApi.isJxInstalled(context))) {
            callback.onError("\u672a\u68c0\u6d4b\u5230\u7edf\u4e00\u8ba4\u8bc1\uff0c\u8bf7\u5148\u5b89\u88c5\uff01");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            packageName = context.getPackageName();
        }
        Bundle bundle = new Bundle();
        bundle.putString("packageName", packageName);
        Intent intent = new Intent(UAAC_ACTION);
        intent.putExtra("bundle", bundle);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        try {
            context.startActivity(intent);
        }
        catch (Exception e) {
            UaacApi.getTokenByContentProvider(context, callback, packageName);
        }
    }

    private static void getTokenByContentProvider(Context context, TokenCallback callback, String packageName) {
        Uri uri = Uri.parse((String)("content://com.xdja.app.pj/" + packageName));
        ContentResolver resolver = context.getContentResolver();
        Log.d((String)"UaacApi", (String)"Query provider 1");
        Cursor cursor = resolver.query(uri, null, null, null, null);
        if (cursor == null) {
            try {
                Log.d((String)"UaacApi", (String)"Start activity!");
                Intent intent = new Intent("com.xdja.uaac.action.start");
                intent.setFlags(0x10000000);
                context.startActivity(intent);
            }
            catch (Exception e) {
                Log.e((String)"UaacApi", (String)e.getMessage());
                Log.d((String)"UaacApi", (String)"Start activity failed!");
                callback.onError("\u672a\u5f00\u542f\u7edf\u4e00\u8ba4\u8bc1\u5173\u8054\u542f\u52a8\u6743\u9650\uff01");
                return;
            }
            for (int i = 0; i < 30; ++i) {
                Log.d((String)"UaacApi", (String)("Query provider " + (i + 2)));
                cursor = resolver.query(uri, null, null, null, null);
                if (cursor != null) {
                    UaacApi.parseCursor(cursor, callback);
                    return;
                }
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            callback.onError("\u672a\u5f00\u542f\u7edf\u4e00\u8ba4\u8bc1\u5173\u8054\u542f\u52a8\u6743\u9650\uff01");
        } else {
            UaacApi.parseCursor(cursor, callback);
        }
    }

    public static int logoutUaac(@NonNull Context context) {
        Uri uri = Uri.parse((String)("content://com.xdja.app.pj/" + context.getPackageName()));
        ContentResolver contentResolver = context.getContentResolver();
        int result = 0;
        try {
            result = contentResolver.delete(uri, null, null);
        }
        catch (Exception e) {
            return result;
        }
        return result;
    }

    public static void notifyLogout(@NonNull Context context) {
        Intent intent = new Intent("com.xdja.unifyauthorize.ACTION_THIRD_APP_LOGOUT");
        intent.putExtra("PACKAGE_NAME", context.getPackageName());
        context.sendBroadcast(intent);
    }

    private static boolean isUaacInstalled(Context context) {
        PackageManager mPackageManager = context.getPackageManager();
        ApplicationInfo mApplicationInfo = null;
        try {
            mApplicationInfo = mPackageManager.getApplicationInfo("com.xdja.uaac", 128);
            if (mApplicationInfo != null) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        return false;
    }

    private static boolean isUnifyAuthorizeInstalled(Context context) {
        PackageManager mPackageManager = context.getPackageManager();
        ApplicationInfo mApplicationInfo = null;
        try {
            mApplicationInfo = mPackageManager.getApplicationInfo("com.xdja.unifyauthorize", 128);
            if (mApplicationInfo != null) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        return false;
    }

    private static boolean isSafeClientInstalled(Context context) {
        PackageManager mPackageManager = context.getPackageManager();
        ApplicationInfo mApplicationInfo = null;
        try {
            mApplicationInfo = mPackageManager.getApplicationInfo("com.xdja.safeclient", 128);
            if (mApplicationInfo != null) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        return false;
    }

    private static boolean isJxInstalled(Context context) {
        PackageManager mPackageManager = context.getPackageManager();
        ApplicationInfo mApplicationInfo = null;
        try {
            mApplicationInfo = mPackageManager.getApplicationInfo("com.xdja.jxclient", 128);
            if (mApplicationInfo != null) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        return false;
    }

    private static void parseCursor(Cursor cursor, TokenCallback callback) {
        cursor.moveToFirst();
        int resultCode = cursor.getInt(cursor.getColumnIndex("resultCode"));
        if (resultCode == 0) {
            int safeClientStatus;
            String token = cursor.getString(cursor.getColumnIndex("billStr"));
            try {
                safeClientStatus = cursor.getInt(cursor.getColumnIndex("safeClientStatus"));
            }
            catch (Exception e) {
                safeClientStatus = 1;
            }
            callback.onSuccess(token, safeClientStatus == 0);
        } else {
            String message = cursor.getString(cursor.getColumnIndex("message"));
            callback.onError(message);
        }
        cursor.close();
    }
}

