/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uaac.api;

import android.os.Bundle;
import android.os.RemoteException;
import com.xdja.uaac.api.CredentialCallback;
import com.xdja.uaac.api.IUaacApiCallback;
import com.xdja.uaac.api.TokenCallback;

public class UaacApiCallback
extends IUaacApiCallback.Stub {
    private TokenCallback tokenCallback;
    private CredentialCallback credentialCallback;

    public UaacApiCallback(TokenCallback tokenCallback) {
        this.tokenCallback = tokenCallback;
    }

    public UaacApiCallback(CredentialCallback credentialCallback) {
        this.credentialCallback = credentialCallback;
    }

    @Override
    public void callback(Bundle bundle) throws RemoteException {
        if (bundle == null) {
            return;
        }
        if (this.tokenCallback != null) {
            this.callbackToken(bundle);
            return;
        }
        if (this.credentialCallback != null) {
            this.callbackCredential(bundle);
        }
    }

    private void callbackToken(Bundle bundle) {
        int resultCode = bundle.getInt("resultCode");
        if (resultCode == 0) {
            this.tokenCallback.onSuccess(bundle.getString("token"), bundle.getBoolean("safeClientStatus"));
        } else {
            this.tokenCallback.onError(resultCode + "");
        }
    }

    private void callbackCredential(Bundle bundle) {
        this.credentialCallback.onResult(bundle);
    }
}

