/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uas.syn.service.impl;

import com.xdja.uas.bims.bean.QueryPersonBean;
import com.xdja.uas.bims.dao.PersonDao;
import com.xdja.uas.bims.entity.BimsGroup;
import com.xdja.uas.bims.entity.Department;
import com.xdja.uas.bims.entity.Mobile;
import com.xdja.uas.bims.entity.Person;
import com.xdja.uas.bims.service.DepManageService;
import com.xdja.uas.bims.service.GroupManageService;
import com.xdja.uas.bims.service.UserManageService;
import com.xdja.uas.bims.util.BimsUtil;
import com.xdja.uas.common.util.Md5PwdEncoder;
import com.xdja.uas.common.util.PinYin4j;
import com.xdja.uas.scms.dao.DeviceDao;
import com.xdja.uas.scms.entity.Device;
import com.xdja.uas.scms.service.DeviceService;
import com.xdja.uas.syms.service.SystemConfigPbService;
import com.xdja.uas.syn.bean.RegisterDepartmentParam;
import com.xdja.uas.syn.bean.RegisterDeviceParam;
import com.xdja.uas.syn.bean.RegisterPersonParam;
import com.xdja.uas.syn.service.BasicInfoRegisteService;
import com.xdja.uas.upms.entity.Role;
import com.xdja.uas.upms.service.SysRoleService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BasicInfoRegisteServiceImpl
implements BasicInfoRegisteService {
    private static final Logger log = LoggerFactory.getLogger(BasicInfoRegisteServiceImpl.class);
    @Autowired
    private DepManageService depManageService;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private GroupManageService groupManageService;
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private SystemConfigPbService systemConfigPbService;
    @Autowired
    private PersonDao personDao;
    @Autowired
    private DeviceDao deviceDao;
    @Autowired
    private DeviceService deviceService;

    @Override
    @Transactional
    public String registerPersonBatch(List<RegisterPersonParam> registerPersonParams) throws Exception {
        if (CollectionUtils.isEmpty(registerPersonParams)) {
            return "";
        }
        StringBuffer returnStr = new StringBuffer("");
        for (RegisterPersonParam personParam : registerPersonParams) {
            try {
                if (!StringUtils.hasText((String)personParam.getIdentifier())) {
                    returnStr.append("\u540c\u6b65\u4eba\u5458\u5931\u8d25-->\u4eba\u5458\u8eab\u4efd\u8bc1\u53f7\u4e3a\u7a7a:name=" + personParam.getName() + ",code=" + personParam.getCode() + ";\n");
                    continue;
                }
                if (!(StringUtils.hasText((String)personParam.getCode()) && StringUtils.hasText((String)personParam.getName()) && StringUtils.hasText((String)personParam.getDepCode()) && StringUtils.hasText((String)personParam.getMobile()))) {
                    returnStr.append("\u540c\u6b65\u4eba\u5458\u5931\u8d25-->\u4eba\u5458\u4fe1\u606f\u4e0d\u5b8c\u5584:name=" + personParam.getName() + ",code=" + personParam.getCode() + ",depCode=" + personParam.getDepCode() + ",mobile=" + personParam.getMobile() + ";\n");
                    continue;
                }
                Person person = this.userManageService.getUserByIdentifer(personParam.getIdentifier());
                if (person == null) {
                    Person orgPerson;
                    if ("1".equals(personParam.getFlag())) {
                        returnStr.append("\u540c\u6b65\u4eba\u5458\u5931\u8d25-->\u540c\u6b65\u7684\u5220\u9664\u4eba\u5458\u5df2\u88ab\u5220\u9664:ientifier=" + personParam.getIdentifier() + ",mobile=" + personParam.getMobile() + ";\n");
                        continue;
                    }
                    String tmp = this.userManageService.checkMobileIsExist(personParam.getMobile().split(","));
                    if (null != tmp) {
                        returnStr.append("\u540c\u6b65\u4eba\u5458\u5931\u8d25-->\u624b\u673a\u53f7\u5df2\u7ecf\u5b58\u5728:ientifier=" + personParam.getIdentifier() + ",mobile=" + personParam.getMobile() + ";\n");
                        continue;
                    }
                    if (this.userManageService.checkCode(personParam.getCode())) {
                        returnStr.append("\u540c\u6b65\u4eba\u5458\u5931\u8d25-->\u8b66\u53f7\u5df2\u7ecf\u5b58\u5728:ientifier=" + personParam.getIdentifier() + ",code=" + personParam.getCode() + ";\n");
                        continue;
                    }
                    if (StringUtils.hasText((String)personParam.getId()) && "1".equals(personParam.getIsIdReserved()) && (orgPerson = this.userManageService.queryPersonById(personParam.getId())) != null && !orgPerson.getIdentifier().equalsIgnoreCase(personParam.getIdentifier())) {
                        returnStr.append("\u540c\u6b65\u4eba\u5458\u5931\u8d25-->ID\u5df2\u7ecf\u5b58\u5728:ientifier=" + personParam.getIdentifier() + ",id=" + personParam.getIdentifier() + ";\n");
                        continue;
                    }
                    Department department = this.depManageService.getDepartmentByCode(personParam.getDepCode());
                    if (department == null) {
                        returnStr.append("\u540c\u6b65\u4eba\u5458\u5931\u8d25-->\u90e8\u95e8\u4e0d\u5b58\u5728:deptCode=" + personParam.getDepCode() + ",code=" + personParam.getCode() + ";\n");
                        continue;
                    }
                    Person p = this.getPerson(personParam);
                    p.setCreatorId("0");
                    this.addUser(p);
                    continue;
                }
                if ("0".equals(personParam.getBasis())) {
                    if ("1".equals(personParam.getFlag())) {
                        this.userManageService.delete(person.getId());
                        continue;
                    }
                    String[] mobiles = personParam.getMobile().split(",");
                    ArrayList<Mobile> mobileList = new ArrayList<Mobile>();
                    StringBuffer mobileErrorMsg = new StringBuffer("");
                    for (String m : mobiles) {
                        if (!StringUtils.hasText((String)m)) continue;
                        Mobile tmpMobile = this.userManageService.getMobile(m);
                        if (tmpMobile != null && !tmpMobile.getPerson().getId().equals(person.getId())) {
                            returnStr.append("\u540c\u6b65\u4eba\u5458\u5931\u8d25-->\u624b\u673a\u53f7\u5df2\u7ecf\u5b58\u5728:ientifier=" + personParam.getIdentifier() + ",mobile=" + personParam.getMobile() + ";\n");
                            mobileErrorMsg.append(tmpMobile.getMobile() + ";");
                            break;
                        }
                        if (tmpMobile == null) {
                            tmpMobile = new Mobile();
                            tmpMobile.setMobile(m);
                        }
                        mobileList.add(tmpMobile);
                    }
                    if (StringUtils.hasText((String)mobileErrorMsg.toString())) continue;
                    if (this.userManageService.checkCode(personParam.getCode(), person.getId())) {
                        returnStr.append("\u540c\u6b65\u4eba\u5458\u5931\u8d25-->\u8b66\u53f7\u5df2\u7ecf\u5b58\u5728:ientifier=" + personParam.getIdentifier() + ",code=" + personParam.getCode() + ";\n");
                        continue;
                    }
                    if (this.userManageService.checkIdentifer(personParam.getIdentifier(), person.getId())) {
                        returnStr.append("\u540c\u6b65\u4eba\u5458\u5931\u8d25-->\u8eab\u4efd\u8bc1\u53f7\u5df2\u7ecf\u5b58\u5728:ientifier=" + personParam.getIdentifier() + ",code=" + personParam.getCode() + ";\n");
                        continue;
                    }
                    QueryPersonBean personBean = new QueryPersonBean();
                    BeanUtils.copyProperties((Object)personParam, (Object)personBean);
                    personBean.setId(person.getId());
                    personBean.setMobiledList(mobileList);
                    Department department = this.depManageService.getDepartmentByCode(personParam.getDepCode());
                    if (department == null) {
                        returnStr.append("\u540c\u6b65\u4eba\u5458\u5931\u8d25-->\u90e8\u95e8\u4e0d\u5b58\u5728:deptCode=" + personParam.getDepCode() + ",code=" + personParam.getCode() + ";\n");
                        continue;
                    }
                    personBean.setDepId(department.getId());
                    this.userManageService.updatePersonForEdit(personBean, null, "0");
                } else {
                    returnStr.append("\u540c\u6b65\u4eba\u5458\u5931\u8d25-->\u4eba\u5458\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728\u4e0d\u518d\u540c\u6b65:ientifier=" + personParam.getIdentifier() + ",code=" + personParam.getCode() + ";\n");
                }
                this.deviceService.updateDeviceWhereMobileNotExist();
                this.userManageService.deleteNoPersonMobile();
            }
            catch (Exception e) {
                returnStr.append("\u540c\u6b65\u4eba\u5458\u5931\u8d25-->" + e.getMessage() + ",ientifier=" + personParam.getIdentifier() + ";\n");
                log.error("\u540c\u6b65\u4eba\u5458\u5931\u8d25", (Throwable)e);
            }
        }
        return returnStr.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional
    public String registerDepartment(RegisterDepartmentParam registerDepartmentParam) throws Exception {
        if (!StringUtils.hasText((String)registerDepartmentParam.getCode()) || !StringUtils.hasText((String)registerDepartmentParam.getName())) {
            return "\u540c\u6b65\u90e8\u95e8\u5931\u8d25-->\u90e8\u95e8\u4fe1\u606f\u4e0d\u5b8c\u5584:name=" + registerDepartmentParam.getName() + ",code=" + registerDepartmentParam.getCode() + ";\n";
        }
        Department department = this.depManageService.getDepartmentByCode(registerDepartmentParam.getCode());
        if (department != null) {
            if (!"0".equals(registerDepartmentParam.getBasis())) return "\u540c\u6b65\u90e8\u95e8\u5931\u8d25-->\u90e8\u95e8\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728\u4e0d\u518d\u540c\u6b65:" + registerDepartmentParam.getCode() + ";";
            if (!StringUtils.hasText((String)registerDepartmentParam.getParentCode())) return "\u540c\u6b65\u90e8\u95e8\u5931\u8d25-->\u90e8\u95e8\u7f16\u53f7" + registerDepartmentParam.getCode() + "\u9876\u7ea7\u90e8\u95e8\u4e0d\u5141\u8bb8\u66f4\u65b0;";
            if ("1".equals(registerDepartmentParam.getFlag())) {
                department.setFlag("1");
                this.depManageService.updateDep(department, false);
                return "";
            }
            if ("8888888888".equals(department.getId())) {
                department.setName(registerDepartmentParam.getName());
                department.setFlag(registerDepartmentParam.getFlag());
                this.depManageService.updateDep(department, false);
                return "";
            }
            if (!StringUtils.hasText((String)registerDepartmentParam.getParentCode())) {
                return "\u540c\u6b65\u90e8\u95e8\u5931\u8d25-->\u90e8\u95e8\u7f16\u53f7" + registerDepartmentParam.getCode() + "\u7236\u7ea7\u90e8\u95e8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
            }
            Department parentDepartment = this.depManageService.getDepartmentByCode(registerDepartmentParam.getParentCode());
            if (parentDepartment == null) {
                return "\u540c\u6b65\u90e8\u95e8\u5931\u8d25-->\u90e8\u95e8\u7f16\u53f7" + registerDepartmentParam.getCode() + "\u4e0d\u5b58\u5728\u7236\u7ea7\u90e8\u95e8\u7f16\u53f7:" + registerDepartmentParam.getParentCode() + ";";
            }
            department.setLevel(Integer.parseInt(parentDepartment.getLevel()) + 1 + "");
            department.setName(registerDepartmentParam.getName());
            department.setParentDep(parentDepartment);
            department.setFlag(registerDepartmentParam.getFlag());
            this.depManageService.updateDep(department, false);
            this.depManageService.changeChildDepsLevel(department);
            return "";
        } else {
            Department parentDepartment;
            if ("1".equals(registerDepartmentParam.getFlag())) {
                return "\u540c\u6b65\u90e8\u95e8\u5931\u8d25-->\u90e8\u95e8\u7f16\u53f7" + registerDepartmentParam.getCode() + "\u5df2\u88ab\u5220\u9664;";
            }
            department = new Department();
            department.setCode(registerDepartmentParam.getCode());
            department.setName(registerDepartmentParam.getName());
            department.setFlag(registerDepartmentParam.getFlag());
            if (StringUtils.hasText((String)registerDepartmentParam.getParentCode())) {
                parentDepartment = this.depManageService.getDepartmentByCode(registerDepartmentParam.getParentCode());
                if (parentDepartment == null || "1".equals(parentDepartment.getFlag())) {
                    return "\u540c\u6b65\u90e8\u95e8\u5931\u8d25-->\u90e8\u95e8\u7f16\u53f7" + registerDepartmentParam.getCode() + "\u4e0d\u5b58\u5728\u7236\u7ea7\u90e8\u95e8\u7f16\u53f7:" + registerDepartmentParam.getParentCode() + ";";
                }
                department.setParentDep(parentDepartment);
                department.setLevel(Integer.parseInt(parentDepartment.getLevel()) + 1 + "");
            } else {
                if (!"8888888888".equalsIgnoreCase(registerDepartmentParam.getId())) return "\u540c\u6b65\u90e8\u95e8\u5931\u8d25-->\u90e8\u95e8\u7f16\u53f7" + registerDepartmentParam.getCode() + "\u9876\u7ea7\u90e8\u95e8\u4e0d\u5141\u8bb8\u6ce8\u518c;";
                parentDepartment = this.depManageService.queryDepById("8888888888");
                if (parentDepartment == null || "1".equals(parentDepartment.getFlag())) {
                    return "\u540c\u6b65\u90e8\u95e8\u5931\u8d25-->\u90e8\u95e8\u7f16\u53f7" + registerDepartmentParam.getCode() + "\u4e0d\u5b58\u5728\u7236\u7ea7\u90e8\u95e8id:8888888888;";
                }
                department.setLevel(Integer.parseInt(parentDepartment.getLevel()) + 1 + "");
                department.setParentDep(parentDepartment);
            }
            this.depManageService.addDep(department, false);
            department.setTreeId(parentDepartment.getTreeId() + department.getId() + "-");
            department.setTreeCode(parentDepartment.getTreeCode() + department.getTreeCode() + "-");
            department.setTimestamp(System.currentTimeMillis());
            this.depManageService.updateDep(department, false);
        }
        return "";
    }

    @Override
    @Transactional
    public String registerDeviceBatch(List<RegisterDeviceParam> registerDeviceParams) throws Exception {
        if (CollectionUtils.isEmpty(registerDeviceParams)) {
            return "";
        }
        StringBuffer returnStr = new StringBuffer("");
        for (RegisterDeviceParam registerDeviceParam : registerDeviceParams) {
            try {
                Device device;
                if (!StringUtils.hasText((String)registerDeviceParam.getHardNo()) && !StringUtils.hasText((String)registerDeviceParam.getOriginalHardNo())) {
                    returnStr.append("\u540c\u6b65\u8bbe\u5907\u5931\u8d25-->\u8bbe\u5907\u7f16\u53f7\u4e3a\u7a7a:id=" + registerDeviceParam.getId() + ";\n");
                    continue;
                }
                if (!StringUtils.hasText((String)registerDeviceParam.getIdentifier())) {
                    returnStr.append("\u540c\u6b65\u8bbe\u5907\u5931\u8d25-->\u8eab\u4efd\u8bc1\u53f7\u4e3a\u7a7a:id=" + registerDeviceParam.getId() + ";\n");
                    continue;
                }
                if (StringUtils.hasText((String)registerDeviceParam.getHardNo())) {
                    device = this.deviceService.getByCardNO(registerDeviceParam.getHardNo());
                    if (device == null) {
                        Device newDevice = new Device();
                        BeanUtils.copyProperties((Object)registerDeviceParam, (Object)newDevice);
                        Person person = this.userManageService.getUserByIdentifer(registerDeviceParam.getIdentifier());
                        if (person == null) {
                            returnStr.append("\u540c\u6b65\u8bbe\u5907\u5931\u8d25-->\u4eba\u5458\u4e0d\u5b58\u5728:identifier=" + registerDeviceParam.getIdentifier() + ";\n");
                            continue;
                        }
                        newDevice.setPersonId(person.getId());
                        if (!StringUtils.hasText((String)registerDeviceParam.getMobileNum())) {
                            returnStr.append("\u540c\u6b65\u8bbe\u5907\u5931\u8d25-->\u624b\u673a\u53f7\u4e3a\u7a7a:id=" + registerDeviceParam.getId() + ";\n");
                            continue;
                        }
                        Mobile mobile = this.userManageService.getMobile(registerDeviceParam.getMobileNum());
                        if (mobile == null) {
                            returnStr.append("\u540c\u6b65\u8bbe\u5907\u5931\u8d25-->\u624b\u673a\u53f7\u4e0d\u5b58\u5728:mobile=" + registerDeviceParam.getMobileNum() + ";\n");
                            continue;
                        }
                        newDevice.setMobile(mobile);
                        this.deviceDao.save(newDevice);
                        continue;
                    }
                    if ("0".equals(registerDeviceParam.getBasis())) {
                        device.setState(registerDeviceParam.getState());
                        device.setName(registerDeviceParam.getName());
                        device.setAlgType(registerDeviceParam.getAlgType());
                        device.setApplyDate(registerDeviceParam.getApplyDate());
                        device.setBindingDate(registerDeviceParam.getBindingDate());
                        device.setBindingState(registerDeviceParam.getBindingState());
                        device.setCertificate(registerDeviceParam.getCertificate());
                        device.setCertificate2(registerDeviceParam.getCertificate2());
                        device.setCommType(registerDeviceParam.getCommType());
                        device.setEnaasDesc(registerDeviceParam.getEnaasDesc());
                        device.setEnaasUserId(registerDeviceParam.getEnaasUserId());
                        device.setExamineDate(registerDeviceParam.getExamineDate());
                        device.setFlag(registerDeviceParam.getFlag());
                        device.setEnaasState(registerDeviceParam.getEnaasState());
                        device.setIccid(registerDeviceParam.getIccid());
                        device.setImei(registerDeviceParam.getImei());
                        device.setImsi(registerDeviceParam.getImsi());
                        device.setLockState(registerDeviceParam.getLockState());
                        device.setOpenDate(registerDeviceParam.getOpenDate());
                        device.setPauseDate(registerDeviceParam.getPauseDate());
                        device.setRevocationDate(registerDeviceParam.getRevocationDate());
                        device.setRevokeFlag(registerDeviceParam.getRevokeFlag());
                        device.setSn(registerDeviceParam.getSn());
                        device.setSn2(registerDeviceParam.getSn2());
                        device.setType(registerDeviceParam.getType());
                        device.setUseType(registerDeviceParam.getUseType());
                        device.setVideoDeviceNO(registerDeviceParam.getVideoDeviceNO());
                        device.setVideoDeviceOpenState(registerDeviceParam.getVideoDeviceOpenState());
                        device.setWriteCardDate(registerDeviceParam.getWriteCardDate());
                        if (StringUtils.hasText((String)registerDeviceParam.getMobileNum())) {
                            Mobile mobile = this.userManageService.getMobile(registerDeviceParam.getMobileNum());
                            device.setMobile(mobile);
                        }
                        if (StringUtils.hasText((String)registerDeviceParam.getIdentifier())) {
                            Person person = this.userManageService.getUserByIdentifer(registerDeviceParam.getIdentifier());
                            if (person == null) {
                                returnStr.append("\u540c\u6b65\u8bbe\u5907\u5931\u8d25-->\u4eba\u5458\u4e0d\u5b58\u5728:identifier=" + registerDeviceParam.getIdentifier() + ";\n");
                                continue;
                            }
                            device.setPersonId(person.getId());
                        }
                        this.deviceDao.update(device);
                        continue;
                    }
                    returnStr.append("\u540c\u6b65\u8bbe\u5907\u5931\u8d25-->\u8bbe\u5907\u4fe1\u606f\u5df2\u5b58\u5728\u4e0d\u518d\u540c\u6b65:cardno=" + registerDeviceParam.getHardNo() + ";\n");
                    continue;
                }
                if (!StringUtils.hasText((String)registerDeviceParam.getOriginalHardNo())) continue;
                device = this.deviceService.getByCardNO(registerDeviceParam.getOriginalHardNo());
                if (device == null) {
                    returnStr.append("\u540c\u6b65\u8bbe\u5907\u5931\u8d25-->\u8bbe\u5907\u5df2\u7ecf\u88ab\u64a4\u9500\u4e0d\u518d\u540c\u6b65:cardno=" + registerDeviceParam.getOriginalHardNo() + ";\n");
                    continue;
                }
                if ("0".equals(registerDeviceParam.getBasis())) {
                    String hardNo = device.getHardNo();
                    device.setState("11");
                    device.setRevocationDate(new Date());
                    device.setRevokeFlag("1");
                    device.setHardNo("");
                    device.setIccid("");
                    device.setImei("");
                    device.setImsi("");
                    device.setCertificate("");
                    device.setMobile(null);
                    device.setSn("");
                    device.setOriginalHardNo(hardNo);
                    this.deviceService.update(device);
                    continue;
                }
                returnStr.append("\u540c\u6b65\u8bbe\u5907\u5931\u8d25-->\u8bbe\u5907\u4fe1\u606f\u5df2\u5b58\u5728\u4e0d\u518d\u540c\u6b65:cardno=" + registerDeviceParam.getHardNo() + ";\n");
            }
            catch (Exception e) {
                returnStr.append("\u540c\u6b65\u8bbe\u5907\u5931\u8d25-->" + e.getMessage() + ";id=" + registerDeviceParam.getHardNo() + "\n");
                log.error("\u540c\u6b65\u8bbe\u5907\u5931\u8d25", (Throwable)e);
            }
        }
        return returnStr.toString();
    }

    private Person getPerson(RegisterPersonParam personBean) {
        Role role;
        Person person = new Person();
        if ("1".equals(personBean.getIsIdReserved()) && StringUtils.hasText((String)personBean.getId())) {
            person.setId(personBean.getId());
        }
        person.setName(personBean.getName());
        person.setCode(personBean.getCode());
        person.setIdentifier(personBean.getIdentifier());
        person.setSex(personBean.getSex());
        person.setPosition(personBean.getPosition());
        person.setPolice(personBean.getPolice());
        person.setOfficePhone(personBean.getOfficePhone());
        person.setMobileMultimediaMessage(personBean.getMobileMultimediaMessage());
        person.setMobilePersonal(personBean.getMobilePersonal());
        ArrayList<Mobile> mobileList = new ArrayList<Mobile>();
        if (personBean.getMobile() != null) {
            String[] mobiles;
            for (String strMobile : mobiles = personBean.getMobile().split(",")) {
                Mobile mobile = new Mobile();
                mobile.setMobile(strMobile);
                mobileList.add(mobile);
            }
            person.setMobiledList(mobileList);
        }
        person.setMobile(personBean.getMobile());
        person.setOrderField(personBean.getOrderField());
        person.setDepartment(this.depManageService.getDepartmentByCode(personBean.getDepCode()));
        person.setPersonState(personBean.getPersonState());
        person.setDisplayState(personBean.getDisplayState());
        person.setLeaderLevel(personBean.getLeaderLevel());
        person.setPersonType(personBean.getPersonType());
        person.setCommType(personBean.getCommType());
        person.setDepCode(person.getDepartment().getCode());
        if (personBean.getGroupIds() != null) {
            String[] groupIdsArray = personBean.getGroupIds().split(",");
            ArrayList<BimsGroup> list = new ArrayList<BimsGroup>();
            for (String id : groupIdsArray) {
                BimsGroup group = this.groupManageService.queryGroupByID(id);
                list.add(group);
            }
            person.setGroupList(list);
        }
        ArrayList<Role> roleList = new ArrayList<Role>();
        String isSetSysRole = this.systemConfigPbService.getValueByCode("isSetSysRole");
        if ("0".equals(isSetSysRole)) {
            roleList.addAll(this.sysRoleService.queryDefaultRoleList());
        }
        if (personBean.getRoleIds() != null) {
            String[] roleIdsArray;
            for (String id : roleIdsArray = personBean.getRoleIds().split(",")) {
                role = this.sysRoleService.queryRoleById(id);
                roleList.add(role);
            }
        }
        if (personBean.getTerminalRoleIds() != null) {
            String[] roleIdsArray;
            for (String id : roleIdsArray = personBean.getTerminalRoleIds().split(",")) {
                role = this.sysRoleService.queryRoleById(id);
                roleList.add(role);
            }
        }
        person.setRoleList(roleList);
        person.setCreatorId(personBean.getCreatorId());
        person.setLastChangePwDate(new Date());
        return person;
    }

    public String addUser(Person person) {
        if (person.getIdentifier() != null) {
            person.setIdentifier(person.getIdentifier().toUpperCase());
        }
        person.setPassword(Md5PwdEncoder.getInstance().encodePassword(this.systemConfigPbService.getValueByCode("defaultPass")));
        person.setLockState("0");
        person.setFlag("0");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(person.getOrderField() + ""))) {
            person.setOrderField(999L);
        }
        person.setGrade(BimsUtil.checkLevel((String)person.getGrade(), (String)person.getDepartment().getCode()) + "");
        person.setNameBriefSpell(PinYin4j.getNameSimplicityWithPolyphone((String)person.getName()));
        String personId = this.personDao.addPerson(person);
        return personId;
    }
}

