package com.xdja.base.common.action;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.stereotype.Controller;

/**
 * 
 * @ProjectName：ucm
 * @ClassName：BaseAction
 * @Description：基础action
 * @author: mayanpei
 * @date: 2014-8-13 下午3:31:07
 */
@Controller
public class BaseAction implements MessageSourceAware {

	protected Logger logger = LoggerFactory.getLogger(getClass());

	protected MessageSource messageSource;

	protected final static String SUCCESS = "{\"flag\":\"1\"}"; // 操作成功

	protected final static String FAIL = "{\"flag\":\"0\"}"; // 操作失败

	protected final static String ERROR = "{\"flag\":\"2\"}"; // 异常或者其他错误

	/**
	 * @Description： 向前台AJAX调用输出值
	 * @author: mayanpei
	 * @date: 2014-5-12 上午9:10:51
	 * @param ret
	 *            需要输出到页面的内容
	 * @param response
	 *            响应
	 */
	public final void toClient(Object ret, HttpServletResponse response) {
		PrintWriter out = null;
		try {
			response.setCharacterEncoding("utf-8");
			out = response.getWriter();
			out.println(ret);
		} catch (IOException e) {
			logger.error("响应出错：", e);
		} finally {
			if (out != null) {
				out.flush();
				out.close();
				out = null;
			}
		}
	}

	public String getPageCount(Integer count) {
		return "{\"count\":" + count + "}";
	}

	public MessageSource getMessageSource() {
		return messageSource;
	}

	public void setMessageSource(MessageSource messageSource) {
		this.messageSource = messageSource;
	}
}
