package com.xdja.base.security;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;

import com.xdja.base.security.dao.ResourcesDao;
import com.xdja.base.system.entity.Function;

/**
 * @ProjectName：ucm
 * @ClassName：SystemInvocationSecurityMetadataSourceService
 * @Description：系统权限
 * @author: mayanpei
 * @date: 2014-8-13 下午5:42:25
 * 
 */
public class SystemInvocationSecurityMetadataSourceService implements FilterInvocationSecurityMetadataSource {

	private final Logger logger = LoggerFactory.getLogger(getClass());

	private ResourcesDao resourcesDao;

	// resourceMap及为key-url，value-Collection<ConfigAttribute>,资源权限对应Map
	private static Map<String, Collection<ConfigAttribute>> resourceMap = null;

	/**
	 * @Description：构造方法
	 * @param resourcesDao 资源数据操作类
	 */ 
	public SystemInvocationSecurityMetadataSourceService(ResourcesDao resourcesDao) {
		this.resourcesDao = resourcesDao;
		logger.debug("加载MyInvocationSecurityMetadataSourceService..." + resourcesDao);
		loadResourceDefine();
	}

	/**
	 * @Description：加载权限可访问的菜单权限
	 * @author: mayanpei
	 * @date: 2014-8-13 下午5:00:10
	 */
	private synchronized void loadResourceDefine() {
		resourceMap = new HashMap<String, Collection<ConfigAttribute>>();
		List<Function> resources = resourcesDao.findAll();
		// 加载资源对应的权限
		for (Function resource : resources) {
			Collection<ConfigAttribute> auths = resourcesDao.queryRoleByResource(resource.getLink());
			if (logger.isDebugEnabled()) {
				logger.debug("资源" + resource.getLink() + "对应的权限=" + auths);
			}
			resourceMap.put(resource.getLink(), auths);
		}
	}

	/**
	 * @Description：判断用户 是否有权限请求该URL
	 * @author mayanpei
	 * @date: 2014-8-13 下午5:00:10
	 * 
	 */
	@Override
	public Collection<ConfigAttribute> getAttributes(Object object) {
		// object是一个URL，被用户请求的url
		String requestUrl = ((FilterInvocation) object).getRequestUrl();
		if (logger.isDebugEnabled()) {
			logger.debug("requestUrl is " + requestUrl);
		}
		int firstQuestionMarkIndex = requestUrl.indexOf("?");

		if (firstQuestionMarkIndex != -1) {
			requestUrl = requestUrl.substring(0, firstQuestionMarkIndex);
		}

		if (resourceMap == null) {
			loadResourceDefine();
		}

		Iterator<String> ite = resourceMap.keySet().iterator();

		while (ite.hasNext()) {
			String resURL = ite.next();

			if (resURL.equals(requestUrl)) {
				return resourceMap.get(resURL);
			}
		}
		return null;
	}

	@Override
	public boolean supports(Class<?> arg0) {
		return true;
	}

	@Override
	public Collection<ConfigAttribute> getAllConfigAttributes() {
		return null;
	}
}
