package com.xdja.base.security.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.stereotype.Repository;

import com.xdja.base.common.dao.BaseDao;
import com.xdja.base.system.entity.Function;

/**
 * @Description：获取资源
 * @author: mayanpei
 * @date: 2014-8-13 下午4:24:30
 */
@Repository
public class ResourcesDao extends BaseDao {

	private final Logger logger = LoggerFactory.getLogger(getClass());

	/**
	 * @Description： 查询所有菜单
	 * @author: mayanpei
	 * @date: 2014-8-13 下午4:24:25
	 * @return List<Function>
	 */
	public List<Function> findAll() {
		try {
			List<Function> resourceList = new ArrayList<Function>();

			String sql = "SELECT n_id,c_name,c_type,c_link,c_icon,n_parent_id,c_note FROM t_ucm_function ORDER BY n_parent_id, n_sort, n_id";

			List<Map<String, Object>> resources = queryForList(sql, new MapSqlParameterSource());

			for (Map<String, Object> map : resources) {

				Function r = new Function();
				r.setId(Long.valueOf(map.get("n_id").toString()));
				r.setName(map.get("c_name").toString());
				r.setType(String.valueOf(map.get("c_type")));
				r.setLink(String.valueOf(map.get("c_link")));
				r.setNote(String.valueOf(map.get("c_note")));

				if (StringUtils.isNotBlank(r.getLink())) {
					resourceList.add(r);
				}

			}

			return resourceList;
		} catch (RuntimeException re) {
			logger.error("find all resource failed " + re);
			throw re;
		}
	}

	/**
	 * @Description：根据URL查询角色及对应的访问权限
	 * @author: mayanpei
	 * @date: 2014-8-13 下午4:29:42
	 * @param url
	 *            访问URL
	 * @return Collection<ConfigAttribute>
	 */
	public Collection<ConfigAttribute> queryRoleByResource(String url) {
		try {
			StringBuilder sql = new StringBuilder("SELECT r.c_name AS role,f.c_link AS url ");
			sql.append("FROM t_ucm_role r JOIN t_ucm_function_role fr ON r.n_id = fr.n_role_id ");
			sql.append("JOIN t_ucm_function f ON f.n_id = fr.n_function_id  WHERE f.c_link =:url");

			List<Map<String, Object>> authList = queryForList(sql.toString(),
					new MapSqlParameterSource().addValue("url", url));
			Collection<ConfigAttribute> auths = new ArrayList<ConfigAttribute>();

			for (Map<String, Object> map : authList) {
				ConfigAttribute auth = new SecurityConfig(map.get("role").toString());
				auths.add(auth);
			}

			sql = null;
			return auths;
		} catch (RuntimeException re) {
			logger.error("find roles by url failed " + re);
			throw re;
		}
	}
}
