package com.xdja.base.security.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.stereotype.Repository;

import com.xdja.base.common.dao.BaseDao;
import com.xdja.base.system.entity.User;
import com.xdja.base.util.Constants;

/**
 * @ProjectName：ucm
 * @ClassName：UserInfoDao
 * @Description：用户DAO
 * @author: mayanpei
 * @date: 2014-8-13 下午4:42:05
 * 
 */
@SuppressWarnings("deprecation")
@Repository
public class UserInfoDao extends BaseDao {

	/**
	 * @Description：根据用户名查询用户信息
	 * @author: mayanpei
	 * @date: 2014-8-13 下午4:41:09
	 * @param username
	 *            用户名
	 * @return
	 * @throws SQLException
	 *             异常
	 */
	public User findByName(String username) throws SQLException {
		StringBuilder sql = new StringBuilder();
		sql.append(" SELECT n_id,c_login_name,c_name,c_password,n_type,n_status,c_note FROM t_ucm_user");
		sql.append(" WHERE c_login_name=:username");

		RowMapper<User> mapper = new RowMapper<User>() {
			public User mapRow(ResultSet rs, int rowNum) throws SQLException {
				User user = new User();
				user.setId(rs.getLong("n_id"));
				user.setLoginName(rs.getString("c_login_name"));
				user.setName(rs.getString("c_name"));
				user.setPassword(rs.getString("c_password"));
				user.setType(rs.getInt("n_type"));
				user.setStatus(rs.getInt("n_status"));
				user.setNote(rs.getString("c_note"));
				return user;
			}
		};

		User user = queryForObject(sql.toString(), new MapSqlParameterSource().addValue("username", username), mapper);
		sql = null;
		return user;
	}

	/**
	 * @Description：通过用户名获得权限集合
	 * @author: mayanpei
	 * @date: 2014-8-13 下午4:41:00
	 * @param username
	 *            用户名
	 * @throws SQLException
	 *             sql异常
	 * @return
	 */
	public Collection<GrantedAuthority> loadUserAuthorityByName(String username) throws SQLException {
		try {
			List<GrantedAuthority> auths = new ArrayList<GrantedAuthority>();

			List<String> authsList = loadUserAuthorities(username);

			for (String roleName : authsList) {
				GrantedAuthorityImpl authority = new GrantedAuthorityImpl(roleName);
				auths.add(authority);
			}
			return auths;
		} catch (RuntimeException re) {
			logger.error("" + re);
			throw re;
		}
	}

	/**
	 * @Description：获取权限列表
	 * @author: mayanpei
	 * @date: 2014-8-13 下午4:40:50
	 * @param username
	 *            用户名
	 * @throws SQLException
	 *             异常
	 * @return List<String>
	 */
	public List<String> loadUserAuthorities(String username) throws SQLException {
		try {
			User user = this.findByName(username);

			StringBuilder sql = new StringBuilder("SELECT r.c_name as authority ");
			if (user.getType().intValue() == Constants.SUPER_ADMINISTRATOR.intValue()) {
				sql.append(" From t_ucm_role r ");
			} else {
				sql.append("FROM t_ucm_user u JOIN t_ucm_user_role ur ON u.n_id=ur.n_user_id ");
				sql.append("JOIN t_ucm_role r ON r.n_id=ur.n_role_id WHERE u.c_login_name=:username");
			}

			List<Map<String, Object>> list = queryForList(sql.toString(),
					new MapSqlParameterSource().addValue("username", username));

			List<String> roles = new ArrayList<String>();
			for (Map<String, Object> map : list) {
				roles.add((String) map.get("authority"));
			}

			sql = null;
			return roles;
		} catch (RuntimeException re) {
			logger.error("find by authorities by username failed." + re);
			throw re;
		}
	}
}
