package com.xdja.base.security.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.SecurityMetadataSource;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.access.intercept.InterceptorStatusToken;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;

/**
 * @ProjectName：ucm
 * @ClassName：SystemFilterSecurityInterceptor
 * @Description：自定义拦截器
 * @author: mayanpei
 * @date: 2014-8-13 下午5:13:25
 * 
 */
public class SystemFilterSecurityInterceptor extends AbstractSecurityInterceptor implements Filter {

	@Autowired
	private FilterInvocationSecurityMetadataSource securityMetadataSource;

	/**
	 * @Description：系统拦截器，对所有访问的URL进行拦截
	 * @author: mayanpei
	 * @param request
	 * @param response
	 * @param chain
	 * @date: 2014-8-13 下午5:13:25
	 */
	@Override
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException,
			ServletException {
		FilterInvocation fi = new FilterInvocation(request, response, chain);
		invoke(fi);
	}

	@Override
	public Class<? extends Object> getSecureObjectClass() {
		return FilterInvocation.class;
	}

	/**
	 * @author: mayanpei
	 * @date: 2014-8-13 下午5:31:05
	 * @param fi
	 * @throws IOException
	 * @throws ServletException
	 */
	public void invoke(FilterInvocation fi) throws IOException, ServletException {

		InterceptorStatusToken token = super.beforeInvocation(fi);

		try {
			fi.getChain().doFilter(fi.getRequest(), fi.getResponse());
		} finally {
			super.afterInvocation(token, null);
		}

	}

	@Override
	public SecurityMetadataSource obtainSecurityMetadataSource() {
		return this.securityMetadataSource;
	}

	public void setSecurityMetadataSource(FilterInvocationSecurityMetadataSource securityMetadataSource) {
		this.securityMetadataSource = securityMetadataSource;
	}

	/**
	 * @Description：销毁方法
	 * @author: mayanpei
	 * @date: 2014-8-13 下午5:13:25
	 */
	@Override
	public void destroy() {

	}

	/**
	 * @Description： 初始化
	 * @author: mayanpei
	 * @date: 2014-8-13 下午5:13:25
	 */
	@Override
	public void init(FilterConfig filterconfig) throws ServletException {

	}
}