package com.xdja.base.security.service;

import java.sql.SQLException;
import java.util.Collection;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserCache;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Service;

import com.xdja.base.security.dao.UserInfoDao;
import com.xdja.base.system.entity.User;

/**
 * @ProjectName：ucm
 * @ClassName：UserDetailService
 * @Description：查询当前登录用户帐户信息
 * @author: mayanpei
 * @date: 2014-8-13 下午4:30:39
 */
@Service
public class UserDetailService implements UserDetailsService {

	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private UserInfoDao userInfoDao;

	@Autowired
	private UserCache userCache;

	@Override
	public UserDetails loadUserByUsername(String username) {
		if (logger.isDebugEnabled()) {
			logger.debug("username is :" + username);
		}
		
		User user = null;
		try {
			user = this.userInfoDao.findByName(username);
		} catch (SQLException e) {
			logger.error(e.getMessage(), e);
		}
		
		Collection<GrantedAuthority> auths = null;
		
		try {
			auths = userInfoDao.loadUserAuthorityByName(username);
			
		} catch (Exception e) {
			logger.error("查询登录用户角色信息", e);
		}
		// 获得用户权限

		boolean enables = true;
		// 账户过期否
		boolean accountNonExpired = true;
		// 证书过期否
		boolean credentialsNonExpired = true;
		// 账户锁定否
		boolean accountNonLocked = true;
		// 封装成spring security的user
		if (null == user) {
			return null;
		}
		
		org.springframework.security.core.userdetails.User userdetail = new org.springframework.security.core.userdetails.User(
				username, user.getPassword(), enables, accountNonExpired, credentialsNonExpired, accountNonLocked,
				auths);
		
		return userdetail;

	}

	public UserInfoDao getUserInfoDao() {
		return userInfoDao;
	}

	public void setUserInfoDao(UserInfoDao userInfoDao) {
		this.userInfoDao = userInfoDao;
	}

	// 设置用户缓存功能。
	public UserCache getUserCache() {
		return userCache;
	}

	public void setUserCache(UserCache userCache) {
		this.userCache = userCache;
	}
}
