package com.xdja.base.system;

import java.util.Properties;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

/**
 * 
 * @ClassName：PropertiesLoader
 * @Description：加载配置文件
 * @author: yk
 * @date: 2014-3-4 16:01:27
 *
 */
public class PropertiesLoader extends PropertyPlaceholderConfigurer {

	private Properties properties;
	
	@Override
	protected void processProperties(
			ConfigurableListableBeanFactory beanFactoryToProcess,
			Properties props) throws BeansException {
		super.processProperties(beanFactoryToProcess, props);
		properties = props;
	}

	public Properties getProperties() {
		return properties;
	}
}
