package com.xdja.base.system;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/**
 * 
 * @ClassName：SystemPropertisInitListener
 * @Description：服务启动时的监听类，用于存放系统初始化参数
 * @author: yk
 * @date: 2014-3-7 上午10:57:49
 * 
 */
public class SystemPropertiesInitListener implements ServletContextListener {

	public void contextDestroyed(ServletContextEvent event) {

	}

	@Override
	public void contextInitialized(ServletContextEvent event) {
		WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext(event.getServletContext());
		PropertiesLoader loader = (PropertiesLoader) wac.getBean("propertiesLoader");
		String rootPath = event.getServletContext().getRealPath("/ucm");
		loader.getProperties().setProperty("rootPath", rootPath);
		SystemPropertiesConfig.setProperties(loader.getProperties());
	}
}
