package com.xdja.base.system.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.stereotype.Repository;

import com.xdja.base.common.dao.BaseDao;
import com.xdja.base.system.entity.Function;
import com.xdja.base.util.Constants;

/**
 * @ProjectName：ucm
 * @ClassName：SystemDao
 * @Description：系统DAO
 * @author: mayanpei
 * @date: 2014-8-13 下午5:29:08
 * 
 */
@Repository
public class SystemDao extends BaseDao {

	private final Logger logger = LoggerFactory.getLogger(getClass());

	/**
	 * @Description： 获取菜单列表
	 * @author: mayanpei
	 * @date: 2014-8-13 下午5:29:27
	 * @param username
	 *            用户名
	 * @param type
	 *            用户类型
	 * @return List<Function>
	 */
	public List<Function> getFunctions(String username, Integer type) {
		List<Function> topFunctions = new ArrayList<Function>();
		try {

			StringBuilder sql = new StringBuilder();
			List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
			if (type.intValue() == Constants.SUPER_ADMINISTRATOR.intValue()) {
				sql.append("SELECT f.n_id,f.c_name,f.c_icon,f.n_parent_id,f.c_type,f.c_link, f.n_sort FROM t_ucm_function f ORDER BY f.n_parent_id, f.n_sort");
				list = queryForList(sql.toString(), new MapSqlParameterSource());
			} else {
				sql.append("SELECT DISTINCT f.n_id,f.c_name,f.c_icon,f.n_parent_id,f.c_type,f.c_link,f.n_sort ");
				sql.append(" FROM t_ucm_function f JOIN t_ucm_function_role fr ON f.n_id = fr.n_function_id ");
				sql.append(" JOIN t_ucm_role r on r.n_id = fr.n_role_id ");
				sql.append(" JOIN t_ucm_user_role ur ON r.n_id=ur.n_role_id");
				sql.append(" JOIN t_ucm_user u on u.n_id = ur.n_user_id ");
				sql.append(" WHERE u.c_login_name=:username");
				sql.append(" ORDER BY f.n_parent_id, f.n_sort");
				list = queryForList(sql.toString(), new MapSqlParameterSource().addValue("username", username));
			}
			List<Function> functions = new ArrayList<Function>();
			for (Map<String, Object> map : list) {

				// 封装菜单权限
				Function function = new Function();
				function.setId(Long.valueOf(map.get("n_id").toString()));
				function.setName(map.get("c_name").toString());
				function.setParentId(Long.valueOf(map.get("n_parent_id").toString())); 
				function.setSort(Integer.parseInt((map.get("n_sort").toString()))); 
				function.setType(String.valueOf(map.get("c_type")));
				function.setIcon(String.valueOf(map.get("c_icon")));
				String link = String.valueOf(map.get("c_link"));
				if (!link.equals("")) {
					link = link.substring(1);
				}
				function.setLink(link);

				functions.add(function);

			}
			
			return generateTree(functions);
			
		} catch (Exception e) {
			logger.error("find functions by username failed." + e);
			return topFunctions;
		}
	}
	
	/**
	 * 生成菜单层级目录
	 * @param functions
	 * @return
	 */
	private List<Function> generateTree(List<Function> functions) {
		
		List<Function> result = new ArrayList<Function>();
 		
		Map<Long, List<Function>> childrens = new HashMap<Long, List<Function>>(); 
		
		List<Function> temp ;
		
		Long pid;
		
		for (Function f :  functions) {  
			
			pid = f.getParentId();
			
			if(childrens.containsKey(pid)) {
				temp = childrens.get(pid);
			} else {
				temp = new ArrayList<Function>();
			}
			
			temp.add(f);
			childrens.put(pid, temp);


			temp = null;
			pid =null;
		}
		
		for (Function f :  functions) {
			f.setChildren(childrens.get(f.getId()) );
			result.add(f);
		}
		
		childrens =null; 
		return result;  
	}
	
	
	
}
