package com.xdja.base.system.manager;

import java.sql.SQLException;
import java.util.List;

import com.xdja.base.system.entity.Function;
import com.xdja.base.system.entity.User;

/**
 * @ProjectName：ucm
 * @ClassName：SystemManager
 * @Description：系统管理业务处理接口
 * @author: mayanpei
 * @date: 2014-8-13 下午5:36:53
 * 
 */
public interface SystemManager {

	/**
	 * 
	 * @Description：根据用户名获得权限
	 * @author: mayanpei
	 * @date: 2014-8-13 下午1:18:32
	 * @param username
	 *            用户名
	 * @param type
	 *            用户类型
	 * @return
	 */
	List<Function> getFunctions(String username, Integer type);

	/**
	 * 
	 * @Description：根据父id和用户名获得权限
	 * @author: mayanpei
	 * @date: 2014-8-13 下午1:33:02
	 * @param parentId
	 *            父菜单ID
	 * @param username
	 *            用户名
	 * @return
	 */
	List<Function> getFunctionsByParentId(Long parentId, String username);

	/**
	 * @Description：根据用户名获得用户信息
	 * @author: mayanpei
	 * @date: 2014-8-14 下午5:24:15
	 * @param userName
	 *            用户名
	 * @return
	 */
	User getUserByUserName(String userName) throws SQLException;
}
