package com.xdja.base.system.manager.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xdja.base.security.dao.UserInfoDao;
import com.xdja.base.system.dao.SystemDao;
import com.xdja.base.system.entity.Function;
import com.xdja.base.system.entity.User;
import com.xdja.base.system.manager.SystemManager;

/**
 * 
 * ClassName：SystemManagerImpl Description：系统管理业务处理类
 * 
 * @author: yk
 * @date: 2014-3-15 11:35:29
 * 
 */
@Service
public class SystemManagerImpl implements SystemManager {

	private Map<String, List<Function>> map = new HashMap<String, List<Function>>();

	@Autowired
	private SystemDao systemDao;

	@Autowired
	private UserInfoDao userDao;

	@Override
	public List<Function> getFunctions(String username, Integer type) {
		List<Function> list = systemDao.getFunctions(username, type);
		map.put(username, list);
		return list;
	}

	@Override
	public List<Function> getFunctionsByParentId(Long parentId, String username) {
		List<Function> children = new ArrayList<Function>();
		List<Function> list = map.get(username);
		for (Function function : list) {
			if (function.getId().intValue() == parentId.intValue()) {
				children = function.getChildren();
			}
		}
		return children;
	}

	@Override
	public User getUserByUserName(String userName) throws SQLException {
		return userDao.findByName(userName);
	}
}
