package com.xdja.base.ucm.data.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.alibaba.fastjson.JSON;
import com.xdja.base.common.action.BaseAction;
import com.xdja.base.system.entity.User;
import com.xdja.base.ucm.data.bean.SendResult;
import com.xdja.base.ucm.systemconfig.bean.QueryStaticDataBean;
import com.xdja.base.ucm.systemconfig.entity.Client;
import com.xdja.base.ucm.systemconfig.entity.ClientData;
import com.xdja.base.ucm.systemconfig.manager.ConfigManager;
import com.xdja.base.ucm.systemconfig.manager.StaticDataManager;
import com.xdja.base.ucm.systemconfig.operate.JmxClient;
import com.xdja.base.ucm.systemconfig.operate.jmx.bean.SendDataBean;
import com.xdja.base.ucm.systemlog.entity.SystemLog;
import com.xdja.base.ucm.systemlog.manager.SystemLogManager;
import com.xdja.base.util.Constants;
import com.xdja.base.util.HttpSessionUtil;
import com.xdja.base.util.IPV4Util;

/**
 * 
 * @author mayanpei
 *
 */
@Controller
public class DataAction extends BaseAction {
	
	
	@Autowired
	private ConfigManager configManager;
	
	@Autowired
	private StaticDataManager dataManager;

	@Autowired
	private SystemLogManager logManager;
	
	/**
	 * @Description：跳转数据管理首页
	 * @author: mayanpei
	 * @date: 2014-8-20 上午11:36:11
	 * @return
	 */
	@RequestMapping(value = "/common/index.do", method = RequestMethod.POST)
	public String commonIndex() {
		User user = HttpSessionUtil.getUser();
		if (null == user) {
			return "login";
		}
		return "/ucm/common/index";
	}
	
	/**
	 * 公共数据管理查询数据 
	 * @param query
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "/common/queryDataList.do", method = RequestMethod.POST)
	public String queryDataList(QueryStaticDataBean query, ModelMap model) {
		try { 
			query.setUserId(HttpSessionUtil.getUser().getId());
			model.put("data", dataManager.queryCommonList(query));
		} catch (Exception e) {
			logger.error("查询子系统数据出错", e);
		}
		return "/ucm/common/data";
	}
	
	/**
	 * @Description：公共数据查询总数
	 * @author: mayanpei
	 * @date: 2014-8-20 上午11:36:58
	 * @param query
	 *            查询系统配置bean
	 * @param response
	 *            响应
	 */
	@RequestMapping(value = "/common/queryDataCount.do", method = RequestMethod.POST)
	public void queryDataCount(QueryStaticDataBean query, HttpServletResponse response) {
		try { 
			query.setUserId(HttpSessionUtil.getUser().getId());
			toClient(getPageCount(dataManager.queryCommonCount(query)), response);
		} catch (Exception e) {
			logger.error("查询子系统数据总数出错", e);
		}
	}
	
	/**
	 * 跳转添加公共数据页面
	 * @return
	 */
	@RequestMapping(value = "/common/toaddCommonData.do", method = RequestMethod.POST)
	public String toaddCommonData() {
		return "/ucm/common/add";
	}
	
	
	/**
	 * 保存公共数据
	 * @param request
	 * @param response
	 * @param data
	 */
	@RequestMapping(value = "/common/addCommonData.do", method = RequestMethod.POST)
	public void addCommonData(HttpServletRequest request , HttpServletResponse response , ClientData data) {
		SystemLog log = new SystemLog();
		
		//设置系统名称为公共系统
		data.setDataClient(Constants.COMMON_SYSTEM_CLIENT);
		data.setCategory(Constants.DATA_TYPE_OF_PUBLIC);
		
		try {
			User user = HttpSessionUtil.getUser();
		
			//保存新添加的公共数据
			data = dataManager.addStaticData(data, user.getId());
			
			/**
			 * 封装日志对象
			 */
			log.setAdminId(user.getId());
			log.setAdministrator(user.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setSystem(data.getDataClient());
			log.setLogContent("添加公共系统数据[" + data.getDataKey() + "]成功");
			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.add.value);
			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);

			// 添加子系统配置成功后 添加操作日志
			logManager.addSystemLog(log);
		} catch (Exception e) {
			logger.error("添加系统配置参数", e);
		} finally {
			log = null;
		}
		toClient(SUCCESS, response);
	}

	
	/**
	 * 跳转修改公共数据页面
	 * @param model
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/common/toUpdateCommonData.do", method = RequestMethod.POST)
	public String toUpdateCommonData(ModelMap model, Long id) {
		try {
			model.put("data", dataManager.queryClientCommonData(Constants.DATA_TYPE_OF_PUBLIC, id));
		} catch (Exception e) {
			logger.error("", e);
		}
		return "/ucm/common/update";
	}
	/**
	 * 修改公共数据
	 * @param data
	 * @param response
	 */
	@RequestMapping(value = "/common/updateCommonDate.do", method = RequestMethod.POST)
	public void updateCommonDate(ClientData data, HttpServletResponse response, HttpServletRequest request) {
		
		//初始化Log日志对象
		SystemLog log = new SystemLog();
		
		try {
			data.setDataClient(Constants.COMMON_SYSTEM_CLIENT);
			data.setCategory(Constants.DATA_TYPE_OF_PUBLIC);
			
			//1：修改公共数据信息
			dataManager.updateStaticData(data);
			User user = HttpSessionUtil.getUser();
			
			/**
			 * 封装日志对象
			 */
			log.setAdminId(user.getId());
			log.setAdministrator(user.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setSystem(data.getDataClient());
			log.setLogContent("修改公共系统数据[" + data.getDataKey() + "]成功");
			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.add.value);
			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);
			
		} catch (Exception e) {
			logger.error("修改公共数据出错！", e);
		}
		toClient(SUCCESS, response);
	}
	
	/**
	 * 删除公共数据
	 * @param data
	 * @param response
	 */
	@RequestMapping(value = "/common/deleteCommonDate.do", method = RequestMethod.POST)
	public void deleteCommonDate(HttpServletResponse response, HttpServletRequest request, Long id) throws Exception {
		try {

			// 1：根据公共数据ID，查询数据详情，获得配制信息的Key 及 value值
			Map<String, Object> keyValue = dataManager.queryCommonStaticDataById(id);
			
			
			// 查询出所有子系统
			List<Map<String, Object>> clientList = configManager.queryClientList();
			
			// 2:删除子系统配制的静态数据
			dataManager.deleteStaticData(id,keyValue, clientList);
			
			// 2.1：封装log日志对象
			SystemLog log = new SystemLog();
			User us = HttpSessionUtil.getUser();
			log.setAdminId(us.getId());
			log.setAdministrator(us.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setSystem(Constants.COMMON_SYSTEM_CLIENT);
			log.setLogContent("删除公共系统的静态数据[" + keyValue.get("c_data_key") + "]成功");
			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.delete.value);
			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);

			// 保存log日志
			logManager.addSystemLog(log);
			toClient(SUCCESS, response);
		} catch (Exception e) {
			toClient(FAIL, response);
		}
	}
	
	/**
	 * 
	 * @param model
	 * @param id
	 * @param pageSize
	 * @param pageNo
	 * @return
	 */
	@RequestMapping(value = "/common/toSendDataFun.do", method = RequestMethod.POST)
	public String toSendDataFun (ModelMap modelMap , Long id) {
		if(null == id){
			return "login";
		}
		modelMap.put("id", id);
		return "/ucm/common/sendClientList";
	}
	
	/**
	 * 查询子系统信息
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "/common/queryClientDataList.do", method = RequestMethod.POST)
	public String queryClientDataList (ModelMap model, Integer pageSize, Integer pageNo) {
		try {
			User user = HttpSessionUtil.getUser();
			if (user != null) {
				model.put("data", dataManager.queryClientDataList(user.getType(), user.getId(), pageSize, pageNo));
			}
		} catch (Exception e) {
			logger.error("跳转发送公共数据------->查询配制信息出错", e);
		}
		return "/ucm/common/clientData";
	}
	
	/**
	 * 查询子系统信息
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "/common/queryClientDataCount.do", method = RequestMethod.POST)
	public void queryClientDataCount (ModelMap model, Long id, HttpServletResponse response) {
		try {
			User user = HttpSessionUtil.getUser();
			if (user != null) {
				toClient(getPageCount(dataManager.queryClientDataCount(user.getType(), user.getId())), response);
			}
		} catch (Exception e) {
			logger.error("跳转发送公共数据------->查询配制信息出错", e);
		}
	}
	
	/**
	 * 发送公共数据
	 * @param request
	 * @param response
	 * @param id
	 * @param clientId
	 */
	@RequestMapping(value = "/common/sendDataFun.do", method = RequestMethod.POST)
	public void sendData(HttpServletRequest request, HttpServletResponse response, Long id, String clientId) throws Exception {

		// 校验所传参数是否正确
		if (id == null || id < 0 || clientId == null
				|| StringUtils.isBlank(clientId)) {

			// 返回异常结果
			toClient(ERROR, response);
		} else {

			SystemLog log = new SystemLog();
			User us = HttpSessionUtil.getUser();

			// 封装Log日志
			log.setAdminId(us.getId());
			log.setAdministrator(us.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.send.value);
			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);

			List<SendResult> sendResults = new ArrayList<SendResult>();

			// 初始化发送配置信息bean
			SendDataBean bean = new SendDataBean();

			// 1：根据配制ID，查出 配置数据 key value
			Map<String, Object> keyValue = dataManager.queyrStaticData(id);

			// 2：根据系统ID关联查询出集群IP,端口等信息
			String[] clientArray = clientId.split(",");
			List<Map<String, Object>> listClient = dataManager.queryColony(Arrays.asList(clientArray));

			// 3:组装发送的信息
			for (Map<String, Object> data : listClient) {

				SendResult sendResult = new SendResult();

				/**
				 * 封装发送集群配置信息
				 */
				if (data != null) {

					// 获得集群的IP及端口
					String ip = data.get("c_ip").toString();
					String port = data.get("c_port").toString();

					// 初例化发送配置信息bean
					bean = new SendDataBean();
					bean.setDataKey(keyValue.get("c_data_key").toString());
					bean.setDataValue(keyValue.get("c_data_value").toString());
					bean.setDataType(Integer.parseInt(keyValue.get("n_data_type").toString()));
					bean.setServerIp(ip);
					bean.setServerPort(port);
					bean.setAppCode(keyValue.get("c_data_client").toString());

					/**
					 * 封装发送结果bean
					 */
					sendResult.setIp(ip);
					sendResult.setPort(port);

					try {
						/**
						 * 调用jmx客户端工具类 发送私有数据
						 */
						JmxClient.sendData(bean);

						// 发送成功
						sendResult.setResult(1);
						sendResults.add(sendResult);

						log.setLogContent("发送给[ip:" + ip + "; port:" + port + "]公共数据(" + bean.getDataKey() + ")成功！");
						// 保存系统log日志
						logManager.addSystemLog(log);
					} catch (Exception e) {

						/**
						 * 发送失败
						 */
						sendResult.setResult(2);
						sendResults.add(sendResult);
						log.setLogContent("发送给[ip:" + ip + "; port:" + port	+ "]公共数据(" + bean.getDataKey() + ")失败！");

						// 保存系统log日志
						logManager.addSystemLog(log);
					}
				}
				request.getSession().setAttribute(Constants.SEND_RESULT, sendResults);
			}
			toClient(SUCCESS, response);
		}
	}
	
	/**
	 * 获取发送结果
	 * @param map
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/common/getResult.do", method = RequestMethod.POST)
	public String getCommonResult(ModelMap map, HttpServletRequest request) {
		map.put("data", request.getSession().getAttribute(Constants.SEND_RESULT));
		return "/ucm/common/sendResult";
	}
	/**************************************公共数据处理结束*******************************************************/
	
	
	
	
	/**
	 * @Description：跳转私有数据管理页面
	 * @author: mayanpei
	 * @date: 2014-8-20 上午11:36:11
	 * @return
	 */
	@RequestMapping(value = "/privilege/config.do", method = RequestMethod.POST)
	public String privilegeIndex(ModelMap map) {
		User user = HttpSessionUtil.getUser();
		if (null == user) {
			return "login";
		}
		if (user.getType().equals(Constants.USUAL_ADMINISTRATOR)) {
			map.put("data", configManager.queryConfigList(user.getId()));
		} else {
			map.put("data", configManager.queryConfigList(0L));
		}
		return "/ucm/privilege/index";
	}
	
	/**
	 * @Description：公共数据查询总数
	 * @author: mayanpei
	 * @date: 2014-8-20 上午11:36:58
	 * @param query
	 *            查询系统配置bean
	 * @param response
	 *            响应
	 */
	@RequestMapping(value = "/privilege/querypRrivilegeCount.do", method = RequestMethod.POST)
	public void queryPrivilegeCount(QueryStaticDataBean query, HttpServletResponse response) {
		try { 
			User user = HttpSessionUtil.getUser();
			if(user.getType() == Constants.SUPER_ADMINISTRATOR) {
				query.setUserId(0L);
			} else {
				query.setUserId(user.getId());
			}
			query.setCategory(Constants.DATA_TYPE_OF_PRIVATE);
			toClient(getPageCount(dataManager.queryCount(query)), response);
		} catch (Exception e) {
			logger.error("查询子系统数据总数出错", e);
		}
	}
	
	/**
	 * 公共数据管理查询数据 
	 * @param query
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "/privilege/querypRrivilegeList.do", method = RequestMethod.POST)
	public String queryPrivilegeList(QueryStaticDataBean query, ModelMap model) {
		try {
			User user = HttpSessionUtil.getUser();
			if(user.getType() == Constants.SUPER_ADMINISTRATOR) {
				query.setUserId(0L);
			} else {
				query.setUserId(user.getId());
			}
			query.setCategory(Constants.DATA_TYPE_OF_PRIVATE);
			model.put("data", dataManager.queryList(query));
		} catch (Exception e) {
			logger.error("查询子系统数据出错", e);
		}
		return "/ucm/privilege/data";
	}
	
	
	/**
	 * @Description：跳转添加子系统配置
	 * @author: mayanpei
	 * @date: 2014-8-20 下午3:45:36
	 * @param map
	 *            ModelMap
	 * @return
	 */
	@RequestMapping(value = "/privilege/toAddPrivilegeData.do", method = RequestMethod.POST)
	public String toAddPrivilegeData(ModelMap map) {
		User user = HttpSessionUtil.getUser();
		if (user.getType().intValue() == Constants.USUAL_ADMINISTRATOR.intValue()) {
			map.put("data", configManager.queryConfigList(user.getId()));
		} else {
			map.put("data", configManager.queryConfigList(0L));
		}
		return "/ucm/privilege/add";
	}

	/**
	 * 判断添加的系统健值是否存在
	 * 
	 * @author: mayanpei
	 * @date: 2014-9-4 下午3:02:43
	 * @param shortName
	 * @param key
	 * @param response
	 */
	@RequestMapping(value = "/privilege/queryKeyExist.do", method = RequestMethod.POST)
	public void queryKeyExist(String shortName, String key, HttpServletResponse response) {
		try {
			if (dataManager.queryKeyExist(shortName, key)) {
				toClient(SUCCESS, response);
			} else {
				toClient(FAIL, response);
			}
		} catch (Exception e) {
			logger.error("判断系统添加的配制参数是否存在", e);
			toClient(ERROR, response);
		}
	}
	/**
	 * @Description：添加子系统配置
	 * @author: mayanpei
	 * @date: 2014-8-20 下午3:45:16
	 * @param data
	 *            配置数据
	 * @param response
	 *            响应
	 * @param request
	 *            请求
	 * @return
	 */
	@RequestMapping(value = "/privilege/addPrivilegeData.do", method = RequestMethod.POST)
	public void addPrivilegeData(ClientData data, HttpServletResponse response, HttpServletRequest request) {
		SystemLog log = new SystemLog();
		Client client = new Client();
		try {
			User user = HttpSessionUtil.getUser();
			client = configManager.queryConfigByName(data.getDataClient());
			data = dataManager.addStaticData(data, user.getId());

			/**
			 * 封装日志对象
			 */
			log.setAdminId(user.getId());
			log.setAdministrator(user.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setSystem(data.getDataClient());
			log.setLogContent("添加" + client.getClientName() + "(" + client.getShortName() + ")系统的静态数据["
					+ data.getDataKey() + "]成功");
			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.add.value);
			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);

			// 添加子系统配置成功后 添加操作日志
			logManager.addSystemLog(log);
		} catch (Exception e) {
			logger.error("添加系统配置参数", e);
		} finally {
			log = null;
			client = null;
		}
		toClient(SUCCESS, response);
	}

	/**
	 * 跳转更新私有数据页面
	 * @param model
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/privilege/toUpdatePrivateData.do", method = RequestMethod.POST)
	public String toUpdatePrivateData(ModelMap model, Long id) {
		try {
			User user = HttpSessionUtil.getUser();
			if (user.getType().intValue() == Constants.USUAL_ADMINISTRATOR.intValue()) {
				model.put("config", configManager.queryConfigList(user.getId()));
			} else {
				model.put("config", configManager.queryConfigList(0L));
			}
			model.put("data", dataManager.queryStaticDataById(id));
		} catch (Exception e) {
			logger.error("根据 系统配置参数ID查询系统配置参数详情", e);
		}
		return "/ucm/privilege/update";
	}
	
	/**
	 * 更新私有数据
	 * @param response
	 * @param data
	 */
	@RequestMapping(value = "/privilege/updatePrivateData.do", method = RequestMethod.POST)
	public void updatePrivateData(HttpServletResponse response, ClientData data) {
		try {
			dataManager.updateStaticData(data);
		} catch (Exception e) {
			logger.error("修改私有数据出错!", e);
		}
		toClient(SUCCESS, response);
	}
	
	/**
	 * 删除私有数据
	 * @param response
	 * @param request
	 * @param id
	 */
	@RequestMapping(value = "/privilege/deletePirvateData.do", method = RequestMethod.POST)
	public void deletePirvateData(HttpServletResponse response,HttpServletRequest request, Long id) throws Exception{
		try {
			SystemLog log = new SystemLog();
			Map<String, Object> map = new HashMap<String, Object>();
			map = dataManager.queryStaticDataById(id);
			Client client = configManager.queryConfigByName(map
					.get("c_data_client").toString());

			// 删除静态数据
			dataManager.deleteStaticData(id, map, client);
			
			User us = HttpSessionUtil.getUser();
			log.setAdminId(us.getId());
			log.setAdministrator(us.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setSystem(client.getShortName());
			log.setLogContent("删除" + client.getClientName() + "("
					+ client.getShortName() + ")系统的静态数据[" + map.get("c_data_key")
					+ "]成功");
			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.delete.value);
			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);

			// 保存系统日志
			logManager.addSystemLog(log);
			toClient(SUCCESS, response);
		} catch (Exception e) {
			toClient(FAIL, response);
		}
	
	}
	
	/**
	 *跳转发送私有数据页面 
	 * @param model
	 * @param client
	 * @return
	 */
	@RequestMapping(value = "/privilege/toSendPrivateDate.do", method = RequestMethod.POST)
	public String toSendPrivateDate(ModelMap model, Long dataId, String client) {
		
		//判断传递参数是否为空
		if (StringUtils.isNotBlank(client)) {
			
			//根据子系统名称，查询系统群集信息
			model.put("data", dataManager.queryClientList(client));
			model.put("dataId", dataId);
			model.put("client", client);
			
		}
		return "/ucm/privilege/sendClientList";
	}
	
	
	/**
	 * 发送私有静态配制数据
	 * @param request
	 * @param response
	 * @param id
	 */
	@RequestMapping(value = "/privilege/sendPrivateData.do", method = RequestMethod.POST)
	public void sendPrivateData(HttpServletRequest request, HttpServletResponse response, Long dataId, String client, String clientId) {
		
		SystemLog log = new SystemLog();
		Map<String, Object> keyValue = new HashMap<String, Object>();
		List<SendResult> sendResults = new ArrayList<SendResult>();
		
		try {
			if(StringUtils.isNotBlank(clientId)){
				// 获得当前用户
				User us = HttpSessionUtil.getUser();
				
				//封装Log日志
				log.setAdminId(us.getId());
				log.setAdministrator(us.getLoginName());
				log.setIp(IPV4Util.getIpAddr(request));
				log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.send.value);
				log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
				log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);

				//根据私有数据ID，查询私有数据
				keyValue = dataManager.queyrStaticData(dataId);
				
				//根据系统简称，查询出集群信息
				List<Map<String, Object>> clientList = dataManager.queryClientById(clientId);
				
				//根据私有数据所属系统查询对应的子系统信息

				SendDataBean bean = new SendDataBean();
				
				//设置发送的私有数据key
				
				logger.info("c_data_key :--------" + keyValue.get("c_data_key").toString());
				bean.setDataKey(keyValue.get("c_data_key").toString());
				
				
				String dataValue = "";


				// 判断发送的配置信息类型
				/**
				 * 静态数据类型为文件
				 */
				if (Integer.valueOf(keyValue.get("n_data_type").toString()).intValue() == Constants.STATIC_DATA_TYPE_FILE.intValue()) {

					// 读取文件内容
					dataValue = dataManager.queryFileContents(dataId);
					bean.setDataType(Integer.valueOf(keyValue.get("n_data_type").toString()));

				}
				/**
				 * 静态数据类型为文本
				 */
				else {
					dataValue = String.valueOf(keyValue.get("c_data_value"));
					bean.setDataType(Integer.valueOf(keyValue.get("n_data_type").toString()));
				}

				// 设置发送数据的VALUE
				bean.setDataValue(dataValue);

				for (int i = 0; i < clientList.size(); i++) {
					
					SendResult sendResult = new SendResult();
					Map<String, Object> clientData = clientList.get(i);
					
					String ip = clientData.get("c_ip").toString();
					String port = clientData.get("c_port").toString();

					/**
					 * 封装发送配制参数对象
					 */
					bean.setServerIp(ip);
					bean.setServerPort(port);
					bean.setAppCode(client);
					
					/**
					 * 封装发送结果bean
					 */
					sendResult.setIp(ip);
					sendResult.setPort(port);
					
					try {
						/**
						 *  发送私有数据
						 */
						JmxClient.sendData(bean);
						
						//发送成功
						sendResult.setResult(1);
						sendResults.add(sendResult);
						
						log.setLogContent("发送给[ip:" + ip + "; port:" + port + "]私有数据(" + bean.getDataKey() + ")成功！");
						//保存系统log日志
						logManager.addSystemLog(log);
					} catch (Exception e) {
						
						/**
						 * 发送失败 
						 */
						sendResult.setResult(2);
						sendResults.add(sendResult);
						log.setLogContent("发送给[ip:" + ip + "; port:" + port + "]私有数据(" + bean.getDataKey() + ")失败！");
						
						//保存系统log日志
						logManager.addSystemLog(log);
					}
				}
				
				//更新发送结果
				dataManager.updateResult(dataId, Constants.SEND_RESULT_SUCCESS);
				
				//将发送结果保存,用于展示给用户
				request.getSession().setAttribute(Constants.SEND_RESULT, sendResults);
				toClient(SUCCESS, response);
			} else {
				toClient(FAIL, response);
			}
		} catch (Exception e) {
			logger.error("发送私有数据出错！", e);
			toClient(ERROR, response);
		}
	}
	
	/**
	 * 发送结果
	 * @param map
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/privilege/getResult.do", method = RequestMethod.POST)
	public String getResult(ModelMap map, HttpServletRequest request) {
		map.put("data", request.getSession().getAttribute(Constants.SEND_RESULT));
		return "/ucm/privilege/sendResult";
	}
}
