package com.xdja.base.ucm.jmx.server.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.stereotype.Repository;

import com.xdja.base.common.dao.BaseDao;
import com.xdja.base.ucm.jmx.server.bean.ClientListBean;

@Repository
public class RegistDao extends BaseDao {
	
	public List<Map<String, Object>> queryForClientList(String client) {
		return  queryForList("SELECT c_client, c_ip, c_port FROM t_ucm_client_list WHERE c_client = :CLIENT", new MapSqlParameterSource().addValue("CLIENT", client));
	} 
	
	public List<Map<String, Object>> queryForDataList(String client) {
		return  queryForList("SELECT c_data_key, c_data_value FROM t_ucm_client_data WHERE c_data_client = :CLIENT", new MapSqlParameterSource().addValue("CLIENT", client));
	}
	
	public List<ClientListBean> getList(String client) {
		
		return query("SELECT c_client, c_ip, c_port FROM t_ucm_client_list WHERE c_client = :CLIENT", new MapSqlParameterSource().addValue("CLIENT", client), new RowMapper<ClientListBean>() {

			@Override
			public ClientListBean mapRow(ResultSet rs, int rowNum)
					throws SQLException { 
				ClientListBean bean = new ClientListBean(); 
				bean.setClient( rs.getString("c_client"));
				bean.setIp( rs.getString("c_ip"));
				bean.setPort( rs.getString("c_port") ); 
 				return bean;
			} 
		});
	}
	
}
