package com.xdja.base.ucm.jmx.server.manager.impl;

import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Properties;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

import com.xdja.base.ucm.jmx.server.service.UcmRegist;


@Service
public class JmxRegistManagerImpl implements InitializingBean {

	private static Logger logger = LoggerFactory.getLogger(JmxRegistManagerImpl.class);
	
	private static final String JMX_SERVICE_NAME = "jmxServerApi";
	private static final String JMX_OBJECT_NAME = "com.xdja.ucm.service.jmx:name=serviceJMXConfigure";
	private static String JMX_SERVICE_IP = "";
	private static String JMX_SERVICE_PORT = "";
	
	
	
	@Override
	public void afterPropertiesSet() throws Exception {
		register();
	}
	
    
	public void register() {
		try {
			
			Properties prop = new Properties();
			prop.load(JmxRegistManagerImpl.class.getResourceAsStream("/system_init.properties")); 
		
			 
			logger.info(String.format("成功加载配置文件:[%s]", "/system_init.properties"));
			
			//获取 JMX 服务配置
			JMX_SERVICE_IP = prop.getProperty("jmx.service.ip").trim();
			JMX_SERVICE_PORT = prop.getProperty("jmx.service.port").trim();   
			MBeanServer server = MBeanServerFactory.createMBeanServer();
			
			ObjectName configName = new ObjectName(JMX_OBJECT_NAME);
			logger.info(String.format("注册统一配置管理JMX服务jmx:objectName=[%s]", JMX_OBJECT_NAME));
			
			UcmRegist configMBean = new UcmRegist();
			//注册MBEAN
			server.registerMBean(configMBean, configName);
			
			//完成端口服务注册
			rmiRegist(); 
			
			String jmxUrl = String.format("service:jmx:rmi:///jndi/rmi://%s:%s/%s/service", JMX_SERVICE_IP, JMX_SERVICE_PORT, JMX_SERVICE_NAME);
			
			logger.info(jmxUrl);
			
			JMXServiceURL url = new JMXServiceURL(jmxUrl);
			JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, server);
			cs.start();
			logger.info("统一配置管理服务端JMX服务注册成功 !!!");
			
		} catch(Exception ex) {
			logger.error("统一配置管理服务端JMX服务注册失败！！");
			logger.error(ex.getLocalizedMessage()); 
		}
	}	
		
	/**
	 * 注册JMX RMI端口
	 * @Description：
	 * @author: liqi
	 * @date: 2014-9-2 下午4:38:35
	 */
	private static void rmiRegist() {
		
		Registry registry = null;
		
		try {  
			
			logger.debug(String.format("开始检验服务器[%s]端口[%s]JMX注册状态。", JMX_SERVICE_IP, JMX_SERVICE_PORT));
			
			registry = LocateRegistry.getRegistry(JMX_SERVICE_IP, Integer.parseInt(JMX_SERVICE_PORT));
			
			logger.debug(String.format("获取服务器[%s]端口[%s]JMX注册信息。", JMX_SERVICE_IP, JMX_SERVICE_PORT));

			String[] sList = registry.list(); 
			
			if(null == sList || sList.length == 0) {
				logger.debug(String.format("服务器[%s]端口[%s]不存在JMX注册信息。", JMX_SERVICE_IP, JMX_SERVICE_PORT));
			} else { 
			
				for(String  temp : sList) {
					logger.info(String.format("服务器[%s]端口[%s]已经注册业务[%s]。", JMX_SERVICE_IP, JMX_SERVICE_PORT, temp));
				} 
			}
 			
		} catch(Exception ex) {
			
			try {
				
				//若端口尚未注册服务，则重新注册服务
				System.setProperty("java.rmi.server.hostname", JMX_SERVICE_IP);
				LocateRegistry.createRegistry(Integer.parseInt(JMX_SERVICE_PORT));
				logger.info(String.format("服务器[%s]端口[%s]注册JMX服务成功。", JMX_SERVICE_IP, JMX_SERVICE_PORT));
			
			} catch(Exception e) {
				
				logger.error(String.format("服务器[%s]端口[%s]注册JMX服务出现异常:%s", JMX_SERVICE_IP, JMX_SERVICE_PORT, e.getLocalizedMessage()));
			}
		}
		
		try {
			if (null != registry) {
				registry.unbind(JMX_SERVICE_NAME + "/service"); 
				logger.info(String.format("服务器[%s]端口[%s]解绑已经注册的JMX服务[%s/service]", JMX_SERVICE_IP, JMX_SERVICE_PORT, JMX_SERVICE_NAME)); 
			}
		} catch(Exception ex) {
			logger.error(String.format("服务器[%s]端口[%s]JMX服务[%s/service]尚未绑定。", JMX_SERVICE_IP, JMX_SERVICE_PORT, JMX_SERVICE_NAME));
 		}
	}
		
}
