package com.xdja.base.ucm.role.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.xdja.base.common.action.BaseAction;
import com.xdja.base.system.entity.Function;
import com.xdja.base.system.entity.Role;
import com.xdja.base.system.entity.User;
import com.xdja.base.ucm.role.manager.RoleManager;
import com.xdja.base.ucm.systemlog.entity.SystemLog;
import com.xdja.base.ucm.systemlog.manager.SystemLogManager;
import com.xdja.base.util.Constants;
import com.xdja.base.util.HttpSessionUtil;
import com.xdja.base.util.IPV4Util;

/**
 * @ProjectName：ucm
 * @ClassName：RoleAction
 * @Description：角色管理
 * @author: mayanpei
 * @date: 2014-8-22 上午9:53:58
 */
@Controller
public class RoleAction extends BaseAction {

	@Autowired
	private RoleManager manager;

	@Autowired
	private SystemLogManager logManager;

	/**
	 * @Description：角色管理首页
	 * @author: mayanpei
	 * @date: 2014-8-18 下午3:30:57
	 * @param map
	 *            ModelMap
	 * @return
	 */
	@RequestMapping(value = "/role/index.do", method = RequestMethod.POST)
	public String index(ModelMap map) {
		User user = HttpSessionUtil.getUser();
		if (null == user) {
			return "login";
		}
		return "/ucm/role/index";
	}

	/**
	 * @Description：查询角色信息
	 * @author: mayanpei
	 * @date: 2014-8-18 下午3:31:15
	 * @param map
	 *            ModelMap
	 * @param name
	 *            角色名
	 * @return
	 */
	@RequestMapping(value = "/role/queryList.do", method = RequestMethod.POST)
	public String queryList(ModelMap map, String name) {
		map.put("data", manager.queryRoleList(name));
		return "/ucm/role/data";
	}

	/**
	 * @Description： 跳转添加 角色信息
	 * @author: mayanpei
	 * @date: 2014-8-18 下午3:51:27
	 * @return
	 */
	@RequestMapping(value = "/role/toAddRole.do", method = RequestMethod.POST)
	public String toAddRole() {
		return "/ucm/role/add";
	}

	/**
	 * @Description：添加 角色信息
	 * @author: mayanpei
	 * @date: 2014-8-18 下午3:51:27
	 * @param role
	 *            角色
	 * @param map
	 *            ModelMap
	 * @param response
	 *            响应
	 * @param request
	 *            请求
	 * @return
	 */
	@RequestMapping(value = "/role/saveRole.do", method = RequestMethod.POST)
	public void addRole(Role role, ModelMap map, HttpServletResponse response, HttpServletRequest request) {
		try {
			manager.saveRole(role);
			SystemLog log = new SystemLog();
			User us = HttpSessionUtil.getUser();
			log.setAdminId(us.getId());
			log.setAdministrator(us.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);
			log.setLogContent("添加了角色(" + role.getName() + ")");
			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.add.value);
			logManager.addSystemLog(log);
			this.index(map);
			toClient(SUCCESS, response);
		} catch (Exception e) {
			logger.error("保存角色信息", e);
			toClient(FAIL, response);
		}
	}

	/**
	 * @Description：跳转修改角色信息页面
	 * @author: mayanpei
	 * @date: 2014-8-18 下午3:51:27
	 * @param roleId
	 *            角色ID
	 * @param map
	 *            ModelMap
	 * @return
	 */
	@RequestMapping(value = "/role/toUpdateRole.do", method = RequestMethod.POST)
	public String toUpdateRole(Long roleId, ModelMap map) {
		try {
			map.put("role", manager.queryRoleByRoleId(roleId));
		} catch (Exception e) {
			logger.error("根据角色ID查询角色信息出错", e);
		}
		return "/ucm/role/edit";
	}

	/**
	 * @Description：修改角色信息
	 * @author: mayanpei
	 * @date: 2014-8-18 下午5:27:54
	 * @param role
	 *            角色
	 * @param map
	 *            ModelMap
	 * @param response
	 *            响应
	 * @param request
	 *            请求
	 */
	@RequestMapping(value = "/role/upateRoleById.do", method = RequestMethod.POST)
	public void upateRoleById(Role role, ModelMap map, HttpServletResponse response, HttpServletRequest request) {
		try {
			manager.updateRole(role);
			SystemLog log = new SystemLog();
			User us = HttpSessionUtil.getUser();
			log.setAdminId(us.getId());
			log.setAdministrator(us.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setLogContent("修改了角色(" + role.getName() + ")");
			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);
			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.update.value);
			logManager.addSystemLog(log);
			toClient(SUCCESS, response);
		} catch (Exception e) {
			logger.error("修改角色信息出错！", e);
			toClient(FAIL, response);
		}
	}

	/**
	 * @Description：跳转添加角色信息页面
	 * @author: mayanpei
	 * @date: 2014-8-18 下午3:51:27
	 * @return
	 */
	@RequestMapping(value = "/role/toAddFunction.do", method = RequestMethod.POST)
	public String toAddFunction() {
		return "/ucm/role/add";
	}

	/**
	 * @Description：判断角色是否存在
	 * @author: mayanpei
	 * @date: 2014-8-18 下午4:08:39
	 * @param name
	 *            角色名
	 * @param response
	 *            响应
	 */
	@RequestMapping(value = "/role/queryRoleExist.do", method = RequestMethod.POST)
	public void queryRoleExist(String name, HttpServletResponse response) {
		try {
			if (manager.queryRoleExist(name)) {
				toClient(SUCCESS, response);
			} else {
				toClient(FAIL, response);
			}
		} catch (Exception e) {
			logger.error("查询角色名是否存在！", e);
		}
	}

	/**
	 * @Description：添加 角色信息
	 * @author: mayanpei
	 * @date: 2014-8-18 下午3:51:27
	 * @return
	 */
	@RequestMapping(value = "/role/addFunction.do", method = RequestMethod.POST)
	public String addFunction() {
		return "/ucm/role/add";
	}

	/**
	 * @Description：删除角色信息
	 * @author: mayanpei
	 * @date: 2014-8-18 下午4:36:50
	 * @param id
	 *            角色ID
	 * @param response
	 *            响应
	 * @param request
	 *            请求
	 */
	@RequestMapping(value = "/role/deleteRole.do", method = RequestMethod.POST)
	public void deleteRole(Long id, HttpServletResponse response, HttpServletRequest request) {
		try {
			Role role = manager.queryRoleByRoleId(id);
			manager.deleteRole(id);
			SystemLog log = new SystemLog();
			User us = HttpSessionUtil.getUser();
			log.setAdminId(us.getId());
			log.setAdministrator(us.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setLogContent("删除了角色(" + role.getName() + ")");
			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);
			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.delete.value);
			logManager.addSystemLog(log);
			toClient(SUCCESS, response);
		} catch (Exception e) {
			logger.error("删除角色信息出错", e);
			toClient(FAIL, response);
		}
	}

	/**
	 * @Description：角色权限分配页面
	 * @author: mayanpei
	 * @date: 2014-7-31 上午11:39:52
	 * @param map
	 *            ModelMap
	 * @param roleId
	 *            角色ID
	 * @return
	 */
	@RequestMapping(value = "role/function.do", method = RequestMethod.POST)
	public String rolePower(ModelMap map, Long roleId) {
		try {
			List<Long> roleFuncIds = new ArrayList<Long>();
			// 组装角色已有功能菜单
			List<Map<String, Object>> roleFuncs = manager.queryByRoleId(roleId);

			for (Map<String, Object> roleFunc : roleFuncs) {
				roleFuncIds.add(Long.parseLong(String.valueOf(roleFunc.get("n_function_id"))));
			}
			// 组装功能菜单树
			List<Function> funcs = manager.queryTreeFunction(0L, null);

			List<Map<String, Object>> result = this.getCheckedFun(funcs, roleFuncIds);

			JSONArray jsonArray = new JSONArray();
			for (int i = 0; i < result.size(); i++) {
				jsonArray.add(JSONObject.fromObject(result.get(i)));
			}
			logger.info("菜单：" + jsonArray.toString());
			map.put("roleFuncTree", jsonArray.toString());
			map.put("roleId", roleId);
		} catch (Exception e) {
			logger.error("管理员查询功能菜单", e);
		}
		return "/ucm/role/fun";
	}

	/**
	 * @Description：添加角色权限
	 * @author: mayanpei
	 * @date: 2014-7-31 上午11:40:06
	 * @param funcIds
	 *            菜单ID
	 * @param roleId
	 *            角色ID
	 * @param response
	 *            响应
	 * @param request
	 *            请求
	 * @return
	 */
	@RequestMapping(value = "/role/addRoleFunction.do", method = RequestMethod.POST)
	public void addRolePower(String funcIds, Long roleId, HttpServletResponse response, HttpServletRequest request) {
		try {
			manager.saveRoleFunc(roleId, StringUtils.split(funcIds, ";"));
			Role role = manager.queryRoleByRoleId(roleId);
			SystemLog log = new SystemLog();
			User us = HttpSessionUtil.getUser();
			log.setAdminId(us.getId());
			log.setAdministrator(us.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setLogContent("修改了角色(" + role.getName() + ")的权限");
			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);
			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.update.value);
			logManager.addSystemLog(log);
			toClient(SUCCESS, response);
		} catch (Exception e) {
			logger.error("保存角色功能菜单", e);
			toClient(FAIL, response);
		}
	}

	/**
	 * @Description：查询管辖范围内所有人员
	 * @author: mayanpei
	 * @date: 2014-7-8 上午10:04:43
	 * @param list
	 *            递归拼接部门及子部门ID
	 * @param funIdList
	 *            功能
	 */
	public List<Map<String, Object>> getCheckedFun(List<Function> list, List<Long> funIdList) {
		List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
		Map<String, Object> funcMap;
		for (int i = 0; i < list.size(); i++) {
			Function func = list.get(i);
			funcMap = new HashMap<String, Object>();
			funcMap.put("id", func.getId());
			funcMap.put("pId", func.getParentId());
			funcMap.put("name", func.getName());
			funcMap.put("checked", funIdList.contains(func.getId()));
			result.add(funcMap);
			if (func.getChildren().size() > 0) {
				result.addAll(this.getCheckedFun(func.getChildren(), funIdList));
			}
		}
		return result;
	}
}
