package com.xdja.base.ucm.role.manager;

import java.util.List;
import java.util.Map;

import com.xdja.base.system.entity.Function;
import com.xdja.base.system.entity.Role;

/**
 * @ProjectName：ucm
 * @ClassName：RoleManager
 * @Description：角色管理接口
 * @author: mayanpei
 * @date: 2014-8-15 下午2:01:02
 */
public interface RoleManager {

	/**
	 * @Description：查询角色信息
	 * @author: mayanpei
	 * @date: 2014-8-15 下午2:02:23
	 * @param name
	 *            角色名称
	 * @return
	 */
	List<Map<String, Object>> queryRoleList(String name);

	/**
	 * @Description：保存角色信息
	 * @author: mayanpei
	 * @date: 2014-8-15 下午2:04:14
	 * @param role
	 *            角色
	 */
	void saveRole(Role role);

	/**
	 * @Description：删除角色信息
	 * @author: mayanpei
	 * @date: 2014-8-15 下午2:04:25
	 * @param roleId
	 *            角色ID
	 */
	void deleteRole(Long roleId);

	/**
	 * @Description：更新角色信息
	 * @author: mayanpei
	 * @date: 2014-8-15 下午2:04:25
	 * @param role
	 *            角色
	 */
	void updateRole(Role role);

	/**
	 * @Description：根据角色ID查询角色信息
	 * @author: mayanpei
	 * @date: 2014-8-18 下午4:00:43
	 * @param roleId
	 *            角色ID
	 * @return role
	 */
	Role queryRoleByRoleId(Long roleId);

	/**
	 * @Description：判断角色名称是否存在
	 * @author: mayanpei
	 * @date: 2014-8-19 上午9:53:55
	 * @param name
	 *            角色名称
	 * @return
	 */
	boolean queryRoleExist(String name);

	/**
	 * @Description：查询角色已有权限
	 * @author: mayanpei
	 * @date: 2014-8-19 上午9:52:40
	 * @param roleId
	 *            角色ID
	 * @return
	 */
	List<Map<String, Object>> queryByRoleId(Long roleId);

	/**
	 * @Description：保存角色权限
	 * @author: mayanpei
	 * @date: 2014-8-15 下午2:04:37
	 * @param roleId
	 *            角色ID
	 * @param funcIds
	 *            功能菜单ID
	 */
	void saveRoleFunc(Long roleId, String[] funcIds);

	/**
	 * @Description：查询菜单权限
	 * @author: mayanpei
	 * @date: 2014-8-19 上午10:18:40
	 * @param functionId
	 *            菜单ID
	 * @param datas
	 *            菜单数据
	 * @return
	 */
	List<Function> queryTreeFunction(Long functionId, List<Function> datas);
}
