package com.xdja.base.ucm.role.manager.impl;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xdja.base.system.entity.Function;
import com.xdja.base.system.entity.Role;
import com.xdja.base.ucm.role.dao.RoleDao;
import com.xdja.base.ucm.role.manager.RoleManager;

/**
 * @ProjectName：ucm
 * @ClassName：RoleManagerImpl
 * @Description：角色管理接口实现
 * @author: mayanpei
 * @date: 2014-8-15 下午2:21:17
 */
@Service
public class RoleManagerImpl implements RoleManager {

	@Autowired
	private RoleDao dao;

	@Override
	public List<Map<String, Object>> queryRoleList(String name) {
		return dao.queryRoleList(name);
	}

	@Override
	public void saveRole(Role role) {
		dao.saveRole(role);
	}

	@Override
	public void updateRole(Role role) {
		dao.updateRole(role);
	}

	@Override
	public void deleteRole(Long roleId) {
		dao.deleteRole(roleId);
	}

	@Override
	public Role queryRoleByRoleId(Long roleId) {
		return dao.queryRoleByRoleId(roleId);
	}

	@Override
	public boolean queryRoleExist(String name) {
		if (dao.queryRoleList(name).size() > 0) {
			return false;
		}
		return true;
	}

	@Override
	public List<Map<String, Object>> queryByRoleId(Long roleId) {
		return dao.queryByRoleId(roleId);
	}

	@Override
	public void saveRoleFunc(Long roleId, String[] funcIds) {
		dao.saveRoleFunc(roleId, funcIds);
	}

	@Override
	public List<Function> queryTreeFunction(Long functionId, List<Function> datas) {
		return dao.queryTreeFunction(functionId, datas);
	}

}
