package com.xdja.base.ucm.systemconfig.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.alibaba.fastjson.JSON;
import com.xdja.base.common.action.BaseAction;
import com.xdja.base.system.entity.User;
import com.xdja.base.ucm.systemconfig.bean.QueryConfigBean;
import com.xdja.base.ucm.systemconfig.entity.Cluster;
import com.xdja.base.ucm.systemconfig.manager.ClusterManager;
import com.xdja.base.util.HttpSessionUtil;

/**
 * @ProjectName：ucm
 * @ClassName：ClusterAction
 * @Description：集群信息管理
 * @author: liqi
 * @date: 2014-8-20 上午11:36:27
 */
@Controller
public class ClusterAction extends BaseAction {
	
	@Autowired
	private ClusterManager manager;
	
	@RequestMapping(value = "/cluster/index.do", method = RequestMethod.POST)
	public String index(String shortName, ModelMap model) {
		User user = HttpSessionUtil.getUser();
		if (null == user) {
			return "login";
		}
		model.put("shortName", shortName);
		logger.debug(shortName);
		return "/ucm/cluster/index";
	}
	
	
	/**
	 * @Description：查询数据
	 * @author: mayanpei
	 * @date: 2014-8-20 上午11:36:48
	 * @param query
	 *            查询系统配置bean
	 * @param model
	 *            ModelMap
	 * @return
	 */
	@RequestMapping(value = "/cluster/queryClusterList.do", method = RequestMethod.POST)
	public String queryConfigList(QueryConfigBean query, ModelMap model) {
		try {
			query.setUserType(HttpSessionUtil.getUser().getType());
			query.setUserId(HttpSessionUtil.getUser().getId());
			logger.debug(JSON.toJSONString(manager.queryClusterList(query.getShortName())));
			model.put("data", manager.queryClusterList(query.getShortName()));
		} catch (Exception e) {
			logger.error("查询子系统数据出错", e);
		}
		return "/ucm/cluster/data";
	}

	/**
	 * @Description：查询总数
	 * @author: mayanpei
	 * @date: 2014-8-20 上午11:36:58
	 * @param query
	 *            查询系统配置bean
	 * @param response
	 *            响应
	 */
	@RequestMapping(value = "/cluster/queryClusterCount.do", method = RequestMethod.POST)
	public void queryConfigCount(QueryConfigBean query, HttpServletResponse response) {
		try { 
			toClient("{\"count\":10}", response);
		} catch (Exception e) {
			logger.error("查询子系统数据总数出错", e);
		}
	}
	
	
	@RequestMapping(value = "/cluster/toAddCluster.do", method = RequestMethod.POST)
	public String toAddCluster(String shortName, ModelMap model) {
		try {
 			model.put("shortName", shortName);
		} catch (Exception e) {
			logger.error("查询子系统数据出错", e);
		}
		return "/ucm/cluster/add";
	}
	
	@RequestMapping(value = "/cluster/toUpdateCluster.do", method = RequestMethod.POST)
	public String toUpdateCluster(Long id, ModelMap model) {
		try {
 			model.put("data", manager.queryClusterById(id));
		} catch (Exception e) {
			logger.error("查询子系统数据出错", e);
		}
		return "/ucm/cluster/update";
	}

	
	
	@RequestMapping(value = "/cluster/addCluster.do", method = RequestMethod.POST)
	public void addCluster(Cluster cluster, HttpServletResponse response, HttpServletRequest request) {
		try {
 			manager.addCluster(cluster);

//			SystemLog log = new SystemLog();
//			User us = HttpSessionUtil.getUser();
//			log.setAdminId(us.getId());
//			log.setAdministrator(us.getLoginName());
//			log.setLogContent("添加子系统(" + cluster.getClient() + ")");
//			log.setIp(IPV4Util.getIpAddr(request));
//			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
//			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);
//			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.add.value);
//			log.setSystem(client.getShortName());
			//logManager.addSystemLog(log);

			toClient(SUCCESS, response);
		} catch (Exception e) {
			logger.error("添加集群配置", e);
			toClient(FAIL, response);
		}
	}
	
	
	@RequestMapping(value = "/cluster/updateCluster.do", method = RequestMethod.POST)
	public void updateCluster(Cluster cluster, HttpServletResponse response, HttpServletRequest request) {
		try {
			//User user = HttpSessionUtil.getUser();
			manager.updateCluster(cluster);

//			SystemLog log = new SystemLog();
//			User us = HttpSessionUtil.getUser();
//			log.setAdminId(us.getId());
//			log.setAdministrator(us.getLoginName());
//			log.setLogContent("添加子系统(" + client.getClientName() + ")");
//			log.setIp(IPV4Util.getIpAddr(request));
//			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
//			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);
//			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.add.value);
//			log.setSystem(client.getShortName());
//			logManager.addSystemLog(log);

			toClient(SUCCESS, response);
		} catch (Exception e) {
			logger.error("更新集群配置", e);
			toClient(FAIL, response);
		}
	}
	
	@RequestMapping(value = "/cluster/delCluster.do", method = RequestMethod.POST)
	public void delCluster(Long id, HttpServletResponse response, HttpServletRequest request) {
		try {
			//User user = HttpSessionUtil.getUser();
			manager.deleteCluster(id);

//			SystemLog log = new SystemLog();
//			User us = HttpSessionUtil.getUser();
//			log.setAdminId(us.getId());
//			log.setAdministrator(us.getLoginName());
//			log.setLogContent("添加子系统(" + client.getClientName() + ")");
//			log.setIp(IPV4Util.getIpAddr(request));
//			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
//			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);
//			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.add.value);
//			log.setSystem(client.getShortName());
//			logManager.addSystemLog(log);

			toClient(SUCCESS, response);
		} catch (Exception e) {
			logger.error("删除集群配置", e);
			toClient(FAIL, response);
		}
	}

}
