package com.xdja.base.ucm.systemconfig.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.xdja.base.common.action.BaseAction;
import com.xdja.base.system.entity.User;
import com.xdja.base.ucm.systemconfig.bean.QueryConfigBean;
import com.xdja.base.ucm.systemconfig.entity.Client;
import com.xdja.base.ucm.systemconfig.manager.ConfigManager;
import com.xdja.base.ucm.systemconfig.manager.StaticDataManager;
import com.xdja.base.ucm.systemconfig.operate.JmxClient;
import com.xdja.base.ucm.systemconfig.operate.jmx.bean.SendDataBean;
import com.xdja.base.ucm.systemlog.entity.SystemLog;
import com.xdja.base.ucm.systemlog.manager.SystemLogManager;
import com.xdja.base.util.Constants;
import com.xdja.base.util.HttpSessionUtil;
import com.xdja.base.util.IPV4Util;

/**
 * @ProjectName：ucm
 * @ClassName：SystemDataAction
 * @Description：子系统数据管理
 * @author: mayanpei
 * @date: 2014-8-20 上午11:36:27
 */
@Controller
public class ConfigAction extends BaseAction {

	@Autowired
	private ConfigManager manager;

	@Autowired
	private SystemLogManager logManager;

	@Autowired
	private StaticDataManager dataManage;

	/**
	 * @Description：跳转数据管理首页
	 * @author: mayanpei
	 * @date: 2014-8-20 上午11:36:11
	 * @return
	 */
	@RequestMapping(value = "/config/index.do", method = RequestMethod.POST)
	public String index() {
		User user = HttpSessionUtil.getUser();
		if (null == user) {
			return "login";
		}
		if(1 == user.getType()) {
			return "/ucm/systemconfig/config";
		}
		return "/ucm/systemconfig/configA";
	}

	/**
	 * @Description：查询数据
	 * @author: mayanpei
	 * @date: 2014-8-20 上午11:36:48
	 * @param query
	 *            查询系统配置bean
	 * @param model
	 *            ModelMap
	 * @return
	 */
	@RequestMapping(value = "/config/queryConfigList.do", method = RequestMethod.POST)
	public String queryConfigList(QueryConfigBean query, ModelMap model) {
		try {
			query.setUserType(HttpSessionUtil.getUser().getType());
			query.setUserId(HttpSessionUtil.getUser().getId());
			model.put("data", manager.queryConfigList(query));
		} catch (Exception e) {
			logger.error("查询子系统数据出错", e);
		}
		return "/ucm/systemconfig/configData";
	}

	/**
	 * @Description：查询总数
	 * @author: mayanpei
	 * @date: 2014-8-20 上午11:36:58
	 * @param query
	 *            查询系统配置bean
	 * @param response
	 *            响应
	 */
	@RequestMapping(value = "/config/queryConfigCount.do", method = RequestMethod.POST)
	public void queryConfigCount(QueryConfigBean query, HttpServletResponse response) {
		try {
			query.setUserType(HttpSessionUtil.getUser().getType());
			query.setUserId(HttpSessionUtil.getUser().getId());
			toClient(getPageCount(manager.queryConfigCount(query)), response);
		} catch (Exception e) {
			logger.error("查询子系统数据总数出错", e);
		}
	}

	/**
	 * @Description：跳转添加子系统配置
	 * @author: mayanpei
	 * @date: 2014-8-20 下午3:45:36
	 * @return
	 */
	@RequestMapping(value = "/config/toAddConfig.do", method = RequestMethod.POST)
	public String toAddConfig() {
		return "/ucm/systemconfig/configAdd";
	}

	/**
	 * @Description：添加子系统配置
	 * @author: mayanpei
	 * @date: 2014-8-20 下午3:45:16
	 * @param client
	 *            子系统配置
	 * @param response
	 *            响应
	 * @param request
	 *            请求
	 * @return
	 */
	@RequestMapping(value = "/config/addConfig.do", method = RequestMethod.POST)
	public void addConfig(Client client, HttpServletResponse response, HttpServletRequest request) {
		try {
			User user = HttpSessionUtil.getUser();
			manager.addConfig(client, user.getId());

			SystemLog log = new SystemLog();
			User us = HttpSessionUtil.getUser();
			log.setAdminId(us.getId());
			log.setAdministrator(us.getLoginName());
			log.setLogContent("添加子系统(" + client.getClientName() + ")");
			log.setIp(IPV4Util.getIpAddr(request));
			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);
			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.add.value);
			log.setSystem(client.getShortName());
			logManager.addSystemLog(log);

			toClient(SUCCESS, response);
		} catch (Exception e) {
			logger.error("添加子系统配置", e);
			toClient(FAIL, response);
		}
	}

	/**
	 * @Description：根据子系统配置ID查询配置详情
	 * @author: mayanpei
	 * @date: 2014-8-20 下午3:44:51
	 * @param map
	 *            ModelMap
	 * @param id
	 *            子系统配置ID
	 * @return
	 */
	@RequestMapping(value = "/config/toUpdateConfig.do", method = RequestMethod.POST)
	public String toUpdateConfig(ModelMap map, Long id) {
		try {
			map.put("data", manager.queryConfigById(id));
		} catch (Exception e) {
			logger.error("根据子系统配置ID查询配置详情", e);
		}
		return "/ucm/systemconfig/configupdate";
	}

	/**
	 * @Description：更新子系统配置
	 * @author: mayanpei
	 * @date: 2014-8-20 下午3:44:36
	 * @param client
	 *            子系统配置对象
	 * @param response
	 *            响应
	 * @param request
	 *            请求
	 * @return
	 */
	@RequestMapping(value = "/config/updateConfig.do", method = RequestMethod.POST)
	public void updateConfig(Client client, HttpServletResponse response, HttpServletRequest request) {

		try {
			manager.updateConfig(client);
			SystemLog log = new SystemLog();
			User us = HttpSessionUtil.getUser();
			log.setAdminId(us.getId());
			log.setAdministrator(us.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setLogContent("修改子系统(" + client.getClientName() + ")");
			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.update.value);
			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);
			log.setSystem(client.getShortName());
			logManager.addSystemLog(log);
			toClient(SUCCESS, response);
		} catch (Exception e) {
			logger.error("修改子系统配置", e);
			toClient(FAIL, response);
		}
	}

	/**
	 * @Description：删除子系统配置
	 * @author: mayanpei
	 * @date: 2014-8-20 下午3:44:14
	 * @param id
	 *            子系统配置id
	 * @param response
	 *            响应
	 * @param request
	 *            请求
	 * @return
	 */
	@RequestMapping(value = "/config/deleteConfig.do", method = RequestMethod.POST)
	public void deleteConfig(Long id, HttpServletResponse response, HttpServletRequest request) {
		try {
			Map<String, Object> map = manager.queryConfigById(id);
			SystemLog log = new SystemLog();
			StringBuffer content = new StringBuffer(1000);
			try {
				 
				Client client = manager.queryConfigByName((String)map.get("c_short_name"));
				User user = HttpSessionUtil.getUser();
				if (user == null) {
					toClient(SUCCESS, response);
					return;
				} 
				log.setAdminId(user.getId());
				log.setAdministrator(user.getLoginName());
				log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
				log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);
				log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.send.value);
				log.setIp(IPV4Util.getIpAddr(request));
				List<Map<String, Object>> listData = manager.queryConfigStaticData(client.getShortName());

				content.append(client.getClientName());
				content.append("(").append(client.getShortName()).append(")子系统的静态数据[");

				// 构造发送静态参数配置bean
				SendDataBean bean = new SendDataBean();
				bean.setServerIp(client.getClientIp());
				bean.setServerPort(client.getClientPort());
				bean.setAppCode(client.getShortName());
				if (listData.size() > 0) {

					for (int i = 0; i < listData.size(); i++) {
						String key = "";
						//String value = "";
						Map<String, Object> dataMap = listData.get(i);
						// 判断发送的配置参数信息是文本还是文件
						/**
						 * 文件
						 */
//						int dataType = Integer.parseInt(dataMap.get("n_data_type").toString());
//						if (dataType == Constants.SEND_RESULT_FAIL) {
//							// 读取文件内容并作为发送信息
//							value = dataManage.queryFileContents(Long.parseLong(dataMap.get("n_id").toString()));
//						}
//						/**
//						 * 文本
//						 */
//						else {
//							value = dataMap.get("c_data_value").toString();
//						}

						key = dataMap.get("c_data_key").toString(); 
					 
						if (i != 0) {
							content.append("、");
						}
						content.append(key); 
					}
					content.append("]成功");
					
					log.setLogContent(content.toString());
					log.setSystem(client.getShortName()); 
					JmxClient.delClient(bean);
					logManager.addSystemLog(log);
				}
			}catch(Exception ex) {
				logger.error("发送子系统删除JMX消息异常");
				logger.error(ex.getLocalizedMessage());
			}
				
				
			manager.deleteConfig(id);
			
			User us = HttpSessionUtil.getUser();
			log.setAdminId(us.getId());
			log.setAdministrator(us.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setLogContent("删除子系统(" + map.get("c_client_name") + ")");
			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);
			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.delete.value);
			log.setSystem((String)map.get("c_short_name"));
			logManager.addSystemLog(log);
				
			toClient(SUCCESS, response);
		} catch (Exception e) {
			logger.error("删除子系统配置", e);
			toClient(FAIL, response);
		}
	}

	/**
	 * @Description：判断子系统名称或者简称是否存在
	 * @author: mayanpei
	 * @date: 2014-8-25 上午9:17:25
	 * @param name
	 * @param shortName
	 * @param response
	 */
	@RequestMapping(value = "/config/queryConfigByName.do", method = RequestMethod.POST)
	public void queryConfigByName(String name, String shortName, HttpServletResponse response) {
		try {
			boolean flag = manager.queryConfigByName(name, shortName);
			if (flag) {
				toClient(SUCCESS, response);
			} else {
				toClient(FAIL, response);
			}
		} catch (Exception e) {
			logger.error("判断添加和子系统和简称是否存在", e);
		}

	}

	/**
	 * @Description：发送系统静态配置参数信息
	 * @author: mayanpei
	 * @date: 2014-8-25 上午9:17:25
	 * @param shortName
	 * @param response
	 */
	@RequestMapping(value = "/config/sendConfig.do", method = RequestMethod.POST)
	public String sendConfig(String shortName, HttpServletRequest request, HttpServletResponse response) {
		List<Map<String, Object>> listData = new ArrayList<Map<String, Object>>();
		Map<String, Object> sendMap = new HashMap<String, Object>();
		SystemLog log = new SystemLog();
		Client client = new Client();
		List<Long> listId = new ArrayList<Long>();
		// 拼接日志内容
		StringBuffer content = new StringBuffer("发送");
		try {
			client = manager.queryConfigByName(shortName);
			User user = HttpSessionUtil.getUser();
			if (user == null) {
				return "redirect:/index.do";
			}

			log.setAdminId(user.getId());
			log.setAdministrator(user.getLoginName());
			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);
			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.send.value);
			log.setIp(IPV4Util.getIpAddr(request));
 			listData = manager.queryConfigStaticData(shortName);

			content.append(client.getClientName());
			content.append("(").append(client.getShortName()).append(")子系统的静态数据[");

			// 构造发送静态参数配置bean
			SendDataBean bean = new SendDataBean();
			bean.setServerIp(client.getClientIp());
			bean.setServerPort(client.getClientPort());
			bean.setAppCode(shortName);
			if (listData.size() > 0) {

				for (int i = 0; i < listData.size(); i++) {
					String key = "";
					String value = "";
					Map<String, Object> dataMap = listData.get(i);
					// 判断发送的配置参数信息是文本还是文件
					/**
					 * 文件
					 */
					int dataType = Integer.parseInt(dataMap.get("n_data_type").toString());
					if (dataType == Constants.SEND_RESULT_FAIL) {
						// 读取文件内容并作为发送信息
						value = dataManage.queryFileContents(Long.parseLong(dataMap.get("n_id").toString()));
					}
					/**
					 * 文本
					 */
					else {
						value = dataMap.get("c_data_value").toString();
					}

					key = dataMap.get("c_data_key").toString();

					sendMap.put(key, value);
					if (i != 0) {
						content.append("、");
					}
					content.append(key);
					listId.add(Long.parseLong(dataMap.get("n_id").toString()));
				}
				content.append("]成功");
				
				log.setLogContent(content.toString());
				log.setSystem(shortName);
				bean.setDataMap(sendMap);
				JmxClient.sendData(bean);
				logManager.addSystemLog(log);
				toClient(SUCCESS, response);
				dataManage.updateResult(listId, Constants.SEND_RESULT_SUCCESS);
			} else {
				toClient(ERROR, response);
			}
		} catch (Exception e) {
			logger.error("判断添加和子系统和简称是否存在", e);
			log.setSystem(shortName);
			log.setLogContent(content.toString().replace("成功", "失败"));
			logManager.addSystemLog(log);
			dataManage.updateResult(listId, Constants.SEND_RESULT_FAIL);
			toClient(FAIL, response);
		} finally {
			sendMap = null;
			listData = null;
			client = null;
			log = null;
		}
		return null;
	}
}
