package com.xdja.base.ucm.systemconfig.action;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.xdja.base.common.action.BaseAction;
import com.xdja.base.system.entity.User;
import com.xdja.base.ucm.systemconfig.manager.StaticDataManager;
import com.xdja.base.ucm.systemlog.entity.SystemLog;
import com.xdja.base.ucm.systemlog.manager.SystemLogManager;
import com.xdja.base.util.Constants;
import com.xdja.base.util.HttpSessionUtil;
import com.xdja.base.util.IPV4Util;

/**
 * @ProjectName：ucm
 * @ClassName：FileDownloadAction
 * @Description：文件下载
 * @author: mayanpei
 * @date: 2014-8-21 下午2:46:41
 */
@Controller
public class FileDownloadAction extends BaseAction {
	private Logger logger = LoggerFactory.getLogger(FileDownloadAction.class);

	@Autowired
	private StaticDataManager manager;

	@Autowired
	private SystemLogManager logManager;

	/**
	 * @Description: 下载文件
	 * @author: mayanpei
	 * @date: 2014-5-19 上午9:20:37
	 * @param fileName
	 *            文件名
	 * @param request
	 *            请求
	 * @param response
	 *            响应
	 */
	@RequestMapping(value = "/download.do", method = RequestMethod.POST)
	public String download(String fileName, Long id, HttpServletRequest request, HttpServletResponse response) {

		User user = HttpSessionUtil.getUser();
		if (null == user) {
			return "redirect:/index.do";
		}
		BufferedOutputStream fout = null;
		BufferedInputStream fin = null;
		SystemLog log = new SystemLog();
		try {

			// 读取文件
			InputStream in = manager.queryFile(id);

			// 下载文件
			fout = new BufferedOutputStream(response.getOutputStream());
			fin = new BufferedInputStream(in);

			// 设置响应头和下载保存的文件名
			response.setContentType("application/x-msdownload");
			response.setHeader("Content-Disposition", "attachment; filename="
					+ new String(fileName.getBytes("UTF-8"), "ISO8859-1"));

			if (fin != null) {
				// 文件太大时内存不能一次读出,要循环
				byte[] b = new byte[in.available()];
				int i = 0;
				while ((i = fin.read(b)) > 0) {
					fout.write(b, 0, i);
					fout.flush();
				}
			}
			fout.flush();
			fout.close();
			fin.close();
			fout = null;
			fin = null;

			// 封装Log日志
			log.setAdminId(user.getId());
			log.setAdministrator(user.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setLogContent("下载了" + fileName + "文件");
			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.download.value);
			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);
			// 保存log日志
			logManager.addSystemLog(log);
		} catch (Exception e) {
			logger.error("文件下载失败" + e.toString());
		} finally {
			try {
				log = null;

				if (fout != null) {
					fout.close();
				}

				if (fin != null) {
					fin.close();
				}

			} catch (Exception e) {
				logger.error("关闭打开的文件失败" + e.toString());
			}

		}
		return null;
	}
}
