package com.xdja.base.ucm.systemconfig.action;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import com.xdja.base.common.action.BaseAction;
import com.xdja.base.system.entity.User;
import com.xdja.base.ucm.systemlog.entity.SystemLog;
import com.xdja.base.ucm.systemlog.manager.SystemLogManager;
import com.xdja.base.util.Constants;
import com.xdja.base.util.HttpSessionUtil;
import com.xdja.base.util.IPV4Util;

/**
 * @ProjectName：ucm
 * @ClassName：FileUploadAction
 * @Description：
 * @author: mayanpei
 * @date: 2014-8-21 上午11:41:33
 * 
 */
@Controller
public class FileUploadAction extends BaseAction {

	private Logger logger = LoggerFactory.getLogger(FileUploadAction.class);

	@Autowired
	private SystemLogManager logManager;

	/**
	 * @Description：文件上传功能实现
	 * @author: mayanpei
	 * @date: 2014-5-14 下午1:55:10
	 * @param file
	 *            上传的文件
	 * @param model
	 *            ModelMap
	 * @param response
	 *            响应
	 * @param request
	 *            请求
	 * @return
	 */
	@RequestMapping(value = "/upload.do", method = RequestMethod.POST)
	public String upload(@RequestParam MultipartFile file, ModelMap model, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			User us = HttpSessionUtil.getUser();
			if (us == null) {
				return "redirect:/index.do";
			}

			String[] fileType = new String[] { ".properties", ".xml", ".json" };
			if (!file.isEmpty()) {
				String fileName = file.getOriginalFilename(); // 获得上传文件的文件名
				String name = fileName.substring(fileName.lastIndexOf("."), fileName.length());
				// 判断上传的文件是否符合规定的类型
				boolean flag = false;
				for (int i = 0; i < fileType.length; i++) {
					if (name.toLowerCase().equals(fileType[i].toLowerCase())) {
						flag = true;
						break;
					}
				}
				if (flag == false) {
					model.put("flag", "2");
				} else if (file.getSize() > Constants.UPLOAD_FILE_SIZE) {
					model.put("flag", "0");
				} else {
					String rename = this.getNewFileName(fileName);
					File newFile = new File(HttpSessionUtil.getUploadPath(), rename);
					logger.info(newFile.toString());
					this.copyFile(file.getInputStream(), newFile.toString());
					model.put("flag", "1");
					model.put("fileName", fileName);
					model.put("newName", rename);
					SystemLog log = new SystemLog();
					log.setAdminId(us.getId());
					log.setAdministrator(us.getLoginName());
					log.setIp(IPV4Util.getIpAddr(request));
					log.setLogContent("上传了" + fileName + "文件");
					log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.upload.value);
					log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
					log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);
					logManager.addSystemLog(log);
				}
			} else {
				model.put("flag", "3");
			}
		} catch (FileNotFoundException e) {
			logger.error("上传文件丢失!", e);
		} catch (IOException e) {
			logger.error("将文件上传至服务器出错！", e);
		}
		return "/ucm/systemconfig/uploadResult";
	}

	/**
	 * @Description：将文件写入本地
	 * @author: mayanpei
	 * @date: 2014-5-14 下午1:39:45
	 * @param in
	 *            输入流
	 * @param fileName
	 *            文件名
	 */
	private void copyFile(InputStream in, String fileName) {
		FileOutputStream fs = null;
		try {
			fs = new FileOutputStream(new File(fileName));
			byte[] buffer = new byte[1024];
			int byteread = 0;
			while ((byteread = in.read(buffer)) != -1) {
				fs.write(buffer, 0, byteread);
			}
		} catch (FileNotFoundException e) {
			logger.error("文件：" + fileName);
			logger.error("文件丢失--------!", e);
		} catch (IOException e) {
			logger.error("定时将安全数据文件上传至服务器出错!", e);
		} finally {
			try {
				if (in != null) {
					in.close();
				}
			} catch (Exception ine) {
				logger.error("关闭文件输入流出错!", ine);
			}
			try {
				if (fs != null) {
					fs.flush();
					fs.close();
				}
			} catch (Exception fse) {
				logger.error("关闭文件输出流出错!", fse);
			}
		}
	}

	/**
	 * 用来把上传的文件重命名的。
	 * 
	 * @author: mayanpei
	 * @date: 2014-8-21 上午11:48:02
	 * @param fileName
	 *            文件名
	 * @return
	 */
	public String getNewFileName(String fileName) {
		String uuidName = java.util.UUID.randomUUID().toString().replace("-", "");
		uuidName = uuidName + fileName.substring(fileName.lastIndexOf("."), fileName.length());
		return uuidName;
	}
}
