package com.xdja.base.ucm.systemconfig.action;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.alibaba.fastjson.JSON;
import com.xdja.base.common.action.BaseAction;
import com.xdja.base.system.entity.User;
import com.xdja.base.ucm.systemconfig.bean.QueryStaticDataBean;
import com.xdja.base.ucm.systemconfig.entity.Client;
import com.xdja.base.ucm.systemconfig.entity.ClientData;
import com.xdja.base.ucm.systemconfig.manager.ConfigManager;
import com.xdja.base.ucm.systemconfig.manager.StaticDataManager;
import com.xdja.base.ucm.systemconfig.operate.JmxClient;
import com.xdja.base.ucm.systemconfig.operate.jmx.bean.SendDataBean;
import com.xdja.base.ucm.systemlog.entity.SystemLog;
import com.xdja.base.ucm.systemlog.manager.SystemLogManager;
import com.xdja.base.util.Constants;
import com.xdja.base.util.HttpSessionUtil;
import com.xdja.base.util.IPV4Util;

/**
 * @ProjectName：ucm
 * @ClassName：StaticDataAction
 * @Description：静态数据处理
 * @author: mayanpei
 * @date: 2014-8-20 下午2:24:30
 */
@Controller
public class StaticDataAction extends BaseAction {

	@Autowired
	private StaticDataManager manager;

	@Autowired
	private ConfigManager configManager;

	@Autowired
	private SystemLogManager logManager;

	/**
	 * @Description：跳转静态数据管理首页
	 * @author: mayanpei
	 * @date: 2014-8-20 上午11:36:11
	 * @param map
	 *            ModelMap
	 * @return
	 */
	@RequestMapping(value = "/staticdata/index.do", method = RequestMethod.POST)
	public String index(ModelMap map) {
		try {
			User user = HttpSessionUtil.getUser();
			if (null == user) {
				return "login";
			}
			if (user.getType().equals(Constants.USUAL_ADMINISTRATOR)) {
				map.put("data", configManager.queryConfigList(user.getId()));
			} else {
				map.put("data", configManager.queryConfigList(0L));
			}
		} catch (Exception e) {
			logger.error("查询子系统配制信息-----", e);
		}
		return "/ucm/systemconfig/static";
	}

	/**
	 * @Description：查询数据
	 * @author: mayanpei
	 * @date: 2014-8-20 上午11:36:48
	 * @param query
	 *            查询bean
	 * @param model
	 *            ModelMap
	 * @return
	 */
	@RequestMapping(value = "/staticdata/queryList.do", method = RequestMethod.POST)
	public String queryStaticDataList(QueryStaticDataBean query, ModelMap model) {
		try {
			User user = HttpSessionUtil.getUser();
			if (user.getType().intValue() == Constants.USUAL_ADMINISTRATOR.intValue()) {
				query.setUserId(user.getId());
			}
			model.put("data", manager.queryList(query));
		} catch (Exception e) {
			logger.error("查询系统配置参数出错", e);
		}
		return "/ucm/systemconfig/staticData";
	}

	/**
	 * @Description：查询总数
	 * @author: mayanpei
	 * @date: 2014-8-20 上午11:36:58
	 * @param query
	 *            查询bean
	 * @param response
	 *            响应
	 */
	@RequestMapping(value = "/staticdata/queryCount.do", method = RequestMethod.POST)
	public void queryStaticDataCount(QueryStaticDataBean query, HttpServletResponse response) {
		try {
			User user = HttpSessionUtil.getUser();
			if (user.getType().intValue() == Constants.USUAL_ADMINISTRATOR.intValue()) {
				query.setUserId(user.getId());
			}
			toClient(getPageCount(manager.queryCount(query)), response);
		} catch (Exception e) {
			logger.error("查询系统配置参数总数出错", e);
		}
	}

	/**
	 * @Description：跳转添加子系统配置
	 * @author: mayanpei
	 * @date: 2014-8-20 下午3:45:36
	 * @param map
	 *            ModelMap
	 * @return
	 */
	@RequestMapping(value = "/staticdata/toAddStaticData.do", method = RequestMethod.POST)
	public String toAddStaticData(ModelMap map) {
		User user = HttpSessionUtil.getUser();
		if (user.getType().intValue() == Constants.USUAL_ADMINISTRATOR.intValue()) {
			map.put("data", configManager.queryConfigList(user.getId()));
		} else {
			map.put("data", configManager.queryConfigList(0L));
		}
		return "/ucm/systemconfig/staticAdd";
	}

	/**
	 * @Description：添加子系统配置
	 * @author: mayanpei
	 * @date: 2014-8-20 下午3:45:16
	 * @param data
	 *            配置数据
	 * @param response
	 *            响应
	 * @param request
	 *            请求
	 * @return
	 */
	@RequestMapping(value = "/staticdata/addStaticData.do", method = RequestMethod.POST)
	public String addStaticData(ClientData data, HttpServletResponse response, HttpServletRequest request) {
		SystemLog log = new SystemLog();
		Client client = new Client();
		//SendDataBean bean = new SendDataBean();
		//Integer sendResult = Constants.SEND_RESULT_UNSEND ;
		try {
			User user = HttpSessionUtil.getUser();
			if (null == user) {
				return "redirect:/index.do";
			}
			
			client = configManager.queryConfigByName(data.getDataClient());
			
//			try {
//
//				/**
//				 * 封装发送静态配置bean
//				 */
//				bean = new SendDataBean();
//				bean.setServerIp(client.getClientIp());
//				bean.setServerPort(client.getClientPort());
//				bean.setDataKey(data.getDataKey());
//				bean.setDataValue(data.getDataValue());
//				bean.setDataType(data.getDataType());
//
//				// 发送子系统静态参数数据配置
//				JmxClient.sendData(bean);
//				sendResult = 1;
//
//				log.setLogContent("发送" + client.getClientName() + "(" + client.getShortName() + ")子系统的静态数据["
//						+ data.getDataKey().toString() + "]成功");
//				log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.send.value);
//				// 保存发送日志
//				logManager.addSystemLog(log);
//				// 更新发送结果
//				sendResult = Constants.SEND_RESULT_SUCCESS;
//				//manager.updateResult(data.getId(), );
//			} catch (Exception e) {
//				log.setLogContent("发送" + client.getClientName() + "(" + client.getShortName() + ")子系统的静态数据["
//						+ bean.getDataKey() + "]失败");
//				// 操作类型
//				log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.send.value);
//				logManager.addSystemLog(log);
//
//				// 更新发送结果
//				manager.updateResult(data.getId(), Constants.SEND_RESULT_FAIL);
//				sendResult = 2;
//				logger.error("添加静态配制参数后发送配制参数", e);
//			} 
			data = manager.addStaticData(data, user.getId());

			

			/**
			 * 封装日志对象
			 */
			log.setAdminId(user.getId());
			log.setAdministrator(user.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setSystem(data.getDataClient());
			log.setLogContent("添加" + client.getClientName() + "(" + client.getShortName() + ")系统的静态数据["
					+ data.getDataKey() + "]成功");
			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.add.value);
			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);

			// 添加子系统配置成功后 添加操作日志
			logManager.addSystemLog(log);


		} catch (Exception e) {
			logger.error("添加系统配置参数", e);
		} finally {
			log = null;
			client = null;
			//bean = null;
		}
		
		toClient(SUCCESS, response);

//		/**
//		 * 对执行结果作判断
//		 */
//		if (sendResult == 0) {
//			// 添加子系统静态配置参数失败
//			toClient(FAIL, response);
//		} else if (sendResult == 1) {
//			// 保存并发送成功
//			toClient(SUCCESS, response);
//		} else {
//			// 发送子系统静态配置出错
//			toClient(ERROR, response);
//		}
		return null;
	}

	/**
	 * @Description：根据子系统配置ID查询配置详情
	 * @author: mayanpei
	 * @date: 2014-8-20 下午3:44:51
	 * @param map
	 *            data
	 * @param id
	 *            系统配置参数ID
	 * @return
	 */
	@RequestMapping(value = "/staticdata/toUpdateStaticData.do", method = RequestMethod.POST)
	public String toUpdateStaticData(ModelMap map, Long id) {
		try {
			User user = HttpSessionUtil.getUser();
			if (user.getType().intValue() == Constants.USUAL_ADMINISTRATOR.intValue()) {
				map.put("config", configManager.queryConfigList(user.getId()));
			} else {
				map.put("config", configManager.queryConfigList(0L));
			}
			map.put("data", manager.queryStaticDataById(id));
		} catch (Exception e) {
			logger.error("根据 系统配置参数ID查询系统配置参数详情", e);
		}
		return "/ucm/systemconfig/staticUpdate";
	}

	/**
	 * @Description：更新子系统配置
	 * @author: mayanpei
	 * @date: 2014-8-20 下午3:44:36
	 * @param data
	 *            子系统配置对象
	 * @param response
	 *            响应
	 * @param request
	 *            请求
	 * @return
	 */
	@RequestMapping(value = "/staticdata/updateStaticData.do", 
			method = RequestMethod.POST)
	public void updateStaticData(ClientData data, HttpServletResponse response, HttpServletRequest request) {
		SystemLog log = new SystemLog();
		Client client = new Client();
		//SendDataBean bean = new SendDataBean();
		//Integer result = 1;
		try {
			// 更新子系统配置静态参数信息
			data.setResult(Constants.SEND_RESULT_UNSEND);
			manager.updateStaticData(data);

			// 根据子系统系统简称查询子系统详情
			client = configManager.queryConfigByName(data.getDataClient());

			/**
			 * 封装日志对象
			 */
			User us = HttpSessionUtil.getUser();
			log.setAdminId(us.getId());
			log.setAdministrator(us.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setSystem(data.getDataClient());
			log.setLogContent("修改" + client.getClientName() + "(" + client.getShortName() + ")系统的静态数据["
					+ data.getDataKey() + "]成功");
			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.update.value);
			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);
			// 保存操作日志
			logManager.addSystemLog(log);

//			try {
//				/**
//				 * 封装子发送子系统静态配置数据
//				 */
//				bean.setServerIp(client.getClientIp());
//				bean.setServerPort(client.getClientPort());
//				bean.setDataKey(data.getDataKey());
//
//				// 判断发送的配置参数信息是文本还是文件
//				/**
//				 * 文件
//				 */
//				if (data.getDataType().intValue() == Constants.SEND_RESULT_FAIL.intValue()) {
//					// 读取文件内容并作为发送信息
//					bean.setDataValue(manager.queryFileContents(data.getId()));
//				}
//				/**
//				 * 文本
//				 */
//				else {
//					bean.setDataValue(data.getDataValue());
//				}
//				bean.setDataType(data.getDataType());
//
//				JmxClient.sendData(bean);
//
//				log.setLogContent("发送" + client.getClientName() + "(" + client.getShortName() + ")子系统的静态数据["
//						+ data.getDataKey().toString() + "]成功");
//				log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.send.value);
//				// 保存发送配置参数日志
//				logManager.addSystemLog(log);
//
//				// 更新发送结果
//				manager.updateResult(data.getId(), Constants.SEND_RESULT_SUCCESS);
//			} catch (Exception e) {
//				log.setLogContent("发送" + client.getClientName() + "(" + client.getShortName() + ")子系统的静态数据["
//						+ bean.getDataKey() + "]失败");
//				log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.send.value);
//				logManager.addSystemLog(log);
//				// 更新发送结果
//				manager.updateResult(data.getId(), Constants.SEND_RESULT_FAIL);
//				result = 2;
//				logger.error("修改静态配制参数后发送配制参数", e);
//			}

		} catch (Exception e) {
			manager.updateResult(data.getId(), Constants.SEND_RESULT_FAIL);
			logger.error("修改系统配置参数配置", e);
			//result = 0;
		} finally {
			log = null;
			client = null;
			//bean = null;
		}

		
		
		toClient(SUCCESS, response);
//		/**
//		 * 对执行结果作判断
//		 */
//		if (result == 0) {
//			// 添加子系统静态配置参数失败
//			toClient(FAIL, response);
//		} else if (result == 1) {
//			// 保存并发送成功
//			toClient(SUCCESS, response);
//		} else {
//			// 发送子系统静态配置出错
//			toClient(ERROR, response);
//		}
	}

	/**
	 * @Description：删除子系统配置
	 * @author: mayanpei
	 * @date: 2014-8-20 下午3:44:14
	 * @param id
	 *            子系统配置id
	 * @param response
	 *            响应
	 * @param request
	 *            请求
	 * @return
	 */
	@RequestMapping(value = "/staticdata/deleteStaticData.do", method = RequestMethod.POST)
	public void deleteStaticData(Long id, HttpServletResponse response, HttpServletRequest request) {
		try {
			Map<String, Object> map = manager.queryStaticDataById(id);
			Client client = configManager.queryConfigByName(map.get("c_data_client").toString());

			// 删除静态数据
			manager.deleteStaticData(id);

			// log
			SystemLog log = new SystemLog();
			User us = HttpSessionUtil.getUser();
			log.setAdminId(us.getId());
			log.setAdministrator(us.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setSystem(client.getShortName());
			log.setLogContent("删除" + client.getClientName() + "(" + client.getShortName() + ")系统的静态数据["
					+ map.get("c_data_key") + "]成功");
			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.delete.value);
			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);
			logManager.addSystemLog(log);
			try {
				
				SendDataBean bean = new SendDataBean();
				
				bean.setDataKey((String)map.get("c_data_key") );
				bean.setDataValue("");
				bean.setDataType(1);
				bean.setServerIp(client.getClientIp().trim());
				bean.setServerPort(client.getClientPort().trim());
				bean.setAppCode(client.getShortName());
				JmxClient.delKey(bean);
				
				logger.info("发送数据删除：" + JSON.toJSONString(bean));
				
			} catch (Exception ex) {
				log.setLogContent("发送" + client.getClientName() + "(" + client.getShortName() + ")系统的静态数据["
						+ map.get("c_data_key") + "]失败:" + ex.getLocalizedMessage() );
				log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.send.value);
				log.setLogType(Constants.UCM_LOG_TYPE.runtimeLog.value);
				log.setLogLevel(Constants.UCM_LOG_LEVEL.error.value);
				logManager.addSystemLog(log);
			}
			map = null;
			log = null;
			toClient(SUCCESS, response);
		} catch (Exception e) {
			logger.error("删除系统配置参数配置", e);
			toClient(FAIL, response);
		}
	}

	/**
	 * @Description：发送子系统配置
	 * @author: mayanpei
	 * @date: 2014-9-2 下午5:33:23
	 * @param id
	 *            静态数据ID
	 * @param response
	 *            响应
	 * @param request
	 *            请求
	 */
	@RequestMapping(value = "/staticdata/sendData.do", method = RequestMethod.POST)
	public void sendData(Long id, HttpServletResponse response, HttpServletRequest request) {
		SystemLog log = new SystemLog();
		Client client = new Client();
		Map<String, Object> map = new HashMap<String, Object>();
		try {
			map = manager.queryStaticDataById(id);
			client = configManager.queryConfigByName(map.get("c_data_client").toString());

			SendDataBean bean = new SendDataBean();
			bean.setServerIp(client.getClientIp());
			bean.setServerPort(client.getClientPort());

			bean.setAppCode(map.get("c_data_client").toString().trim());
			String dataValue = "";

			// 键
			bean.setDataKey(String.valueOf(map.get("c_data_key").toString()));

			// 判断发送的配置信息类型
			/**
			 * 静态数据类型为文件
			 */
			if (Integer.valueOf(map.get("n_data_type").toString()).intValue() == Constants.STATIC_DATA_TYPE_FILE.intValue()) {

				// 读取文件内容
				dataValue = manager.queryFileContents(id);

			}
			/**
			 * 静态数据类型为文本
			 */
			else {
				dataValue = String.valueOf(map.get("c_data_value"));
			}

			// 值
			bean.setDataValue(dataValue);
			logger.error(JSON.toJSONString(bean));
			if (map.get("n_data_type") != null) {
				bean.setDataType(Integer.valueOf(map.get("n_data_type").toString()));
			}

			// 封装日志对象
			User us = HttpSessionUtil.getUser();
			log.setAdminId(us.getId());
			log.setAdministrator(us.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setSystem(client.getShortName());
			log.setLogContent("发送" + client.getClientName() + "(" + client.getShortName() + ")子系统的静态数据["
					+ map.get("c_data_key").toString() + "]成功");
			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.send.value);
			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
			log.setLogLevel(Constants.UCM_LOG_LEVEL.info.value);

			// 发送
			JmxClient.sendData(bean);

			// 更新发送结果
			manager.updateResult(id, Constants.SEND_RESULT_SUCCESS);

			// 保存日志
			logManager.addSystemLog(log);
		} catch (Exception e) {
			log.setLogContent("发送" + client.getClientName() + "(" + client.getShortName() + ")子系统的静态数据["
					+ map.get("c_data_key").toString() + "]失败");
			manager.updateResult(id, Constants.SEND_RESULT_FAIL);
			log.setLogTypeDetail(Constants.UCM_LOG_TYPE_DETAIL.send.value);
			log.setLogType(Constants.UCM_LOG_TYPE.operateLog.value);
			log.setLogLevel(Constants.UCM_LOG_LEVEL.error.value);
			logManager.addSystemLog(log);
			logger.error("发送子系统静态配置数据", e);
			toClient(FAIL, response);
		} finally {
			log = null;
			map = null;
			client = null;
		}
		toClient(SUCCESS, response);
	}

	/**
	 * 判断添加的系统健值是否存在
	 * 
	 * @author: mayanpei
	 * @date: 2014-9-4 下午3:02:43
	 * @param shortName
	 * @param key
	 * @param response
	 */
	@RequestMapping(value = "/staticdata/queryKeyExist.do", method = RequestMethod.POST)
	public void queryKeyExist(String shortName, String key, HttpServletResponse response) {
		try {
			if (manager.queryKeyExist(shortName, key)) {
				toClient(SUCCESS, response);
			} else {
				toClient(FAIL, response);
			}
		} catch (Exception e) {
			logger.error("判断系统添加的配制参数是否存在", e);
			toClient(ERROR, response);
		}
	}
}
