package com.xdja.base.ucm.systemconfig.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.stereotype.Repository;

import com.xdja.base.common.dao.BaseDao;
import com.xdja.base.ucm.systemconfig.entity.Cluster;

/**
 * 注册服务DAO层实现
 * @author liqi
 *
 */
@Repository
public class ClusterDao extends BaseDao {
	
	/**
	 * 查询集群配制信息
	 * @param client
	 * @return
	 */
	public List<Cluster> queryClusterList(String client) {
		StringBuffer sql = new StringBuffer("SELECT n_id,c_client, ");
		sql.append(" c_ip,c_port,c_note,d_date  ");
		sql.append(" FROM t_ucm_client_list  WHERE c_client = :client ");
		
		List<Cluster> list =  super.query(sql.toString(), new MapSqlParameterSource().addValue("client", client), new RowMapper<Cluster>() {
 
			@Override
			public Cluster mapRow(ResultSet rs, int rowNum) throws SQLException {
				Cluster cls = new Cluster();
				cls.setId(rs.getLong("n_id"));
				cls.setClient(rs.getString("c_client"));
				cls.setIp(rs.getString("c_ip"));
				cls.setNote(rs.getString("c_note"));
				cls.setAddTime(rs.getString("d_date"));
				cls.setPort(rs.getString("c_port"));
				return cls;
			}
			
		});  
		return list;
	}
	
	/**
	 * 查询集群某一主机配制信息
	 * @param id
	 * @return
	 */
	public Cluster queryClusterById(Long id) {
		StringBuffer sql = new StringBuffer("SELECT n_id,c_client, ");
		sql.append(" c_ip,c_port,c_note,d_date  ");
		sql.append(" FROM t_ucm_client_list  WHERE n_id=:id ");
		
		List<Cluster> list =  super.query(sql.toString(), new MapSqlParameterSource().addValue("id", id), new RowMapper<Cluster>() {
 
			@Override
			public Cluster mapRow(ResultSet rs, int rowNum) throws SQLException {
				Cluster cls = new Cluster();
				cls.setId(rs.getLong("n_id"));
				cls.setClient(rs.getString("c_client"));
				cls.setIp(rs.getString("c_ip"));
				cls.setNote(rs.getString("c_note"));
				cls.setAddTime(rs.getString("d_date"));
				cls.setPort(rs.getString("c_port"));
				return cls;
			}
			
		});
		
		if(list.size() > 0) {
			return list.get(0);
		}
		return null;
		
	}
	
	/**
	 * 添加集群某一主机配制信息
	 * @param obj
	 */
	public void addCluster(Cluster obj) {
	 	StringBuilder sql  = new StringBuilder("insert into t_ucm_client_list(c_client, c_ip, c_port, c_note, d_date)");
	 	sql.append(" values(:client, :ip, :port, :note, now())");
	 	
	 	
	 	MapSqlParameterSource param = new MapSqlParameterSource();
	 	param.addValue("client", obj.getClient());
	 	param.addValue("ip", obj.getIp());
	 	param.addValue("port", obj.getPort());
	 	param.addValue("note", obj.getNote());
	 	
	 	super.executeSql(sql.toString(), param);
		
	}
	
	/**
	 * 更新集群某一主机配制信息
	 * @param obj
	 */
	public void updateCluster(Cluster obj) {
		StringBuilder sql = new StringBuilder( "update t_ucm_client_list");
		sql.append(" set c_ip = :ip, c_port = :port, c_note = :note, d_date = now()");
		sql.append(" where n_id = :id and c_client = :client"); 
	 	
	 	MapSqlParameterSource param = new MapSqlParameterSource();
	 	param.addValue("client", obj.getClient());
	 	param.addValue("ip", obj.getIp());
	 	param.addValue("port", obj.getPort());
	 	param.addValue("note", obj.getNote());
	 	param.addValue("id", obj.getId());
	 	super.executeSql(sql.toString(), param);
		
	}
	
	/**
	 * 根据ID,删除集群某一主机配制信息
	 * @param id
	 */
	public void delCluster(Long id) {
		String sql = "delete from t_ucm_client_list where n_id = :id";
		super.executeSql(sql, new MapSqlParameterSource().addValue("id", id));
	}

}
