package com.xdja.base.ucm.systemconfig.dao;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.stereotype.Repository;

import com.alibaba.fastjson.JSON;
import com.xdja.base.common.dao.BaseDao;
import com.xdja.base.system.entity.User;
import com.xdja.base.ucm.systemconfig.bean.QueryStaticDataBean;
import com.xdja.base.ucm.systemconfig.entity.Client;
import com.xdja.base.ucm.systemconfig.entity.ClientData;
import com.xdja.base.ucm.systemconfig.operate.JmxClient;
import com.xdja.base.ucm.systemconfig.operate.jmx.bean.SendDataBean;
import com.xdja.base.ucm.systemlog.entity.SystemLog;
import com.xdja.base.util.Constants;
import com.xdja.base.util.DateUtils;
import com.xdja.base.util.HttpSessionUtil;
import com.xdja.base.util.IPV4Util;
import com.xdja.base.util.page.SQLUtil;

/**
 * @ProjectName：ucm
 * @ClassName：StaticDataDao
 * @Description：静态数据处理DAO
 * @author: mayanpei
 * @date: 2014-8-20 下午2:07:48
 */
@Repository
public class StaticDataDao extends BaseDao {

	/**
	 * @Description：查询系统配置静态数据
	 * @author: mayanpei
	 * @date: 2014-8-20 下午2:08:07
	 * @param queryBean
	 *            查询bean
	 * @return
	 */
	public List<Map<String, Object>> queryList(QueryStaticDataBean queryBean) {

		StringBuffer sql = new StringBuffer("SELECT cd.n_id,cl.c_client_name,cd.c_data_client,");
		sql.append(" cd.c_data_key,cd.c_data_value,cd.c_data_note,cd.n_data_type,cd.c_data_file,");
		sql.append(" cd.c_add_time,cd.n_user_id,cd.c_update_time,cd.c_notice_time,cd.n_notice_result ");
		sql.append(" FROM t_ucm_client_data cd ,t_ucm_client cl");
		sql.append(" WHERE cd.c_data_client = cl.c_short_name AND cd.c_category = :category");

		MapSqlParameterSource parameterSource = new MapSqlParameterSource();

		// 系统名称
		if (StringUtils.isNotBlank(queryBean.getSystemName())) {
			sql.append(" AND cd.c_data_client LIKE :name ");
			parameterSource.addValue("name", "%" + queryBean.getSystemName() + "%");
		}

		// 参数配置类型 文本或者文件
		if (StringUtils.isNotBlank(queryBean.getType())) {
			sql.append(" AND cd.n_data_type  =:type");
			parameterSource.addValue("type", queryBean.getType());
		}

		// 发送结果
		if (StringUtils.isNotBlank(queryBean.getResult())) {
			sql.append(" AND cd.n_notice_result  =:result");
			parameterSource.addValue("result", queryBean.getResult());
		}

		// 当普通用户查询可管理的子系统参数配置数据时
		if (queryBean.getUserId() != null && queryBean.getUserId() > 0) {
			sql.append(" AND cl.n_id IN(SELECT uc.n_client_id ");
			sql.append(" FROM t_ucm_user_client uc ");
			sql.append(" WHERE uc.n_user_id = :userId)");
			parameterSource.addValue("userId", queryBean.getUserId());
		}
		parameterSource.addValue("category", queryBean.getCategory());
		sql.append(" ORDER BY n_id DESC");
		SQLUtil util = new SQLUtil(sql.toString(), queryBean.getPageNo(), queryBean.getPageSize());
		return queryForList(util.getPageSql(), parameterSource);
	}

	/**
	 * @Description：查询系统配置静态数据总数
	 * @author: mayanpei
	 * @date: 2014-8-20 下午2:08:07
	 * @param queryBean
	 *            查询bean
	 * @return
	 */
	public Integer queryCount(QueryStaticDataBean queryBean) {

		StringBuffer sql = new StringBuffer("SELECT cd.n_id,cl.c_client_name,cd.c_data_client,");
		sql.append(" cd.c_data_key,cd.c_data_value,cd.c_data_note,cd.n_data_type,cd.c_data_file,");
		sql.append(" cd.c_add_time,cd.n_user_id,cd.c_update_time,cd.c_notice_time,cd.n_notice_result");
		sql.append(" FROM t_ucm_client_data cd ,t_ucm_client cl");
		sql.append(" WHERE cd.c_data_client = cl.c_short_name AND cd.c_category = :category");

		MapSqlParameterSource parameterSource = new MapSqlParameterSource();

		// 子系统名称
		if (StringUtils.isNotBlank(queryBean.getSystemName())) {
			sql.append(" AND cd.c_data_client LIKE :name ");
			parameterSource.addValue("name", "%" + queryBean.getSystemName() + "%");
		}

		// 参数配置类型：文本或者文件
		if (StringUtils.isNotBlank(queryBean.getType())) {
			sql.append(" AND cd.n_data_type  =:type");
			parameterSource.addValue("type", queryBean.getType());
		}

		// 通知结果
		if (StringUtils.isNotBlank(queryBean.getResult())) {
			sql.append(" AND cd.n_notice_result  =:result");
			parameterSource.addValue("result", queryBean.getResult());
		}

		// 当普通用户查询可管理的子系统参数配置数据时
		if (queryBean.getUserId() != null && queryBean.getUserId() > 0) {
			sql.append(" AND cl.n_id IN(SELECT uc.n_client_id ");
			sql.append(" FROM t_ucm_user_client uc ");
			sql.append(" WHERE uc.n_user_id = :userId)");
			parameterSource.addValue("userId", queryBean.getUserId());
		}
		
		parameterSource.addValue("category", queryBean.getCategory());
		sql.append(" ORDER BY n_id DESC");
		SQLUtil util = new SQLUtil(sql.toString());
		
		if(logger.isDebugEnabled()){
			logger.debug(sql.toString());
		}
		
		return queryForInt(util.getCountSQL(), parameterSource);
	}
	
	
	/**
	 * @Description：查询系统配置静态数据
	 * @author: mayanpei
	 * @date: 2014-8-20 下午2:08:07
	 * @param queryBean
	 *            查询bean
	 * @return
	 */
	public List<Map<String, Object>> queryCommonList(QueryStaticDataBean queryBean) {

		StringBuffer sql = new StringBuffer("SELECT cd.n_id,");
		sql.append(" cd.c_data_key,cd.c_data_value,cd.c_data_note,cd.n_data_type,cd.c_data_file,");
		sql.append(" cd.c_add_time,cd.n_user_id,cd.c_update_time,cd.c_notice_time,cd.n_notice_result ");
		sql.append(" FROM t_ucm_client_data cd  WHERE cd.c_category = :category");

		MapSqlParameterSource parameterSource = new MapSqlParameterSource();

	    if(!StringUtils.isBlank(queryBean.getKeys())) {
	    	sql.append(" AND c_data_key like :keys");
			parameterSource.addValue("keys", "%" + queryBean.getKeys().trim() +"%");
	    }
		
		parameterSource.addValue("category", queryBean.getCategory());
		sql.append(" ORDER BY n_id DESC");
		SQLUtil util = new SQLUtil(sql.toString(), queryBean.getPageNo(), queryBean.getPageSize());
		return queryForList(util.getPageSql(), parameterSource);
	}

	/**
	 * @Description：查询系统配置静态数据总数
	 * @author: mayanpei
	 * @date: 2014-8-20 下午2:08:07
	 * @param queryBean
	 *            查询bean
	 * @return
	 */
	public Integer queryCommonCount(QueryStaticDataBean queryBean) {

		StringBuffer sql = new StringBuffer("SELECT cd.n_id,");
		sql.append(" cd.c_data_key,cd.c_data_value,cd.c_data_note,cd.n_data_type,cd.c_data_file,");
		sql.append(" cd.c_add_time,cd.n_user_id,cd.c_update_time,cd.c_notice_time,cd.n_notice_result");
		sql.append(" FROM t_ucm_client_data cd  WHERE cd.c_category = :category");

		MapSqlParameterSource parameterSource = new MapSqlParameterSource();

		// 子系统名称
		if (StringUtils.isNotBlank(queryBean.getKeys())) {
			sql.append(" AND c_data_key like :keys");
			parameterSource.addValue("keys", "%" + queryBean.getKeys().trim() +"%");
		}  
		
		parameterSource.addValue("category", queryBean.getCategory());
 		SQLUtil util = new SQLUtil(sql.toString());
		
		if(logger.isDebugEnabled()){
			logger.debug(sql.toString());
		}
		
		return queryForInt(util.getCountSQL(), parameterSource);
	}

	/**
	 * @Description：根据ID，查询静态数据详情
	 * @author: mayanpei
	 * @date: 2014-8-20 下午2:08:07
	 * @param id
	 *            配置数据ID
	 * @return
	 */
	public Map<String, Object> queryStaticDataById(Long id) {

		StringBuffer sql = new StringBuffer("SELECT cd.n_id,cl.c_client_name,cd.c_data_client,");
		sql.append(" cd.c_data_key,cd.c_data_value,cd.c_data_note,cd.n_data_type,cd.c_data_file,");
		sql.append(" cd.c_add_time,cd.n_user_id,cd.c_update_time,cd.c_notice_time,cd.n_notice_result ");
		sql.append(" FROM t_ucm_client_data cd ,t_ucm_client cl ");
		sql.append(" WHERE cd.c_data_client = cl.c_short_name AND cd.n_id=:id");

		return queryForMap(sql.toString(), new MapSqlParameterSource().addValue("id", id));
	}
	
	
	/**
	 * @Description：根据ID，查询静态数据详情
	 * @author: mayanpei
	 * @date: 2014-8-20 下午2:08:07
	 * @param id
	 *            配置数据ID
	 * @return
	 */
	public Map<String, Object> queryCommonStaticDataById(Long id) {

		StringBuffer sql = new StringBuffer("SELECT cd.n_id, cd.c_data_client,");
		sql.append(" cd.c_data_key,cd.c_data_value,cd.c_data_note,cd.n_data_type,cd.c_data_file,");
		sql.append(" cd.c_add_time,cd.n_user_id,cd.c_update_time,cd.c_notice_time,cd.n_notice_result ");
		sql.append(" FROM t_ucm_client_data cd  ");
		sql.append(" WHERE cd.c_category=2 AND cd.n_id=:id");

		return queryForMap(sql.toString(), new MapSqlParameterSource().addValue("id", id));
	}
	
	/**
	 * 查询配置数据详情
	 * @param categroy
	 * @param id
	 * @return
	 */
	public Map<String, Object> queryClientCommonData(String categroy, Long id) {
		StringBuffer sql = new StringBuffer("SELECT cd.n_id,");
		sql.append(" cd.c_data_key,cd.c_data_value,cd.c_data_note,cd.n_data_type,cd.c_data_file,");
		sql.append(" cd.c_add_time,cd.n_user_id,cd.c_update_time,cd.c_notice_time,cd.n_notice_result ");
		sql.append(" FROM t_ucm_client_data cd  WHERE cd.c_category = :category AND n_id=:id");
		MapSqlParameterSource param = new MapSqlParameterSource();
		param.addValue("category", categroy);
		param.addValue("id", id);
		return queryForMap(sql.toString(),param);
	}
	
	
	

	/**
	 * @Description：添加系统配置静态数据
	 * @author: mayanpei
	 * @date: 2014-8-20 下午5:03:59
	 * @param data
	 *            数据
	 * @param userId
	 *            用户ID
	 */
	public void addStaticData(ClientData data, Long userId) {
		StringBuffer sql = new StringBuffer();
		sql.append("INSERT INTO t_ucm_client_data (c_data_client,c_data_key,c_data_value,");
		sql.append(" c_data_note,n_data_type,c_data_file,c_add_time,n_user_id,");
		sql.append(" c_update_time,c_notice_time,n_notice_result,c_category)");
		sql.append(" VALUES(:clientName,:key,:value,:note,:type,:file,:time,:userId,");
		sql.append(" :updateTime,:noticeTime,:noticeResult, :category)");

		// 构造参数
		MapSqlParameterSource mapSqlParameterSource = new MapSqlParameterSource();
		mapSqlParameterSource.addValue("clientName", data.getDataClient());
		mapSqlParameterSource.addValue("key", data.getDataKey());
		mapSqlParameterSource.addValue("value", data.getDataValue());
		mapSqlParameterSource.addValue("note", data.getNote());
		mapSqlParameterSource.addValue("type", data.getDataType());
		mapSqlParameterSource.addValue("file", data.getDataFile());
		mapSqlParameterSource.addValue("time", DateUtils.getToday());
		mapSqlParameterSource.addValue("userId", userId);
		mapSqlParameterSource.addValue("updateTime", DateUtils.getToday());
		mapSqlParameterSource.addValue("noticeTime", DateUtils.getToday());
		mapSqlParameterSource.addValue("noticeResult", Constants.SEND_RESULT_UNSEND);
		mapSqlParameterSource.addValue("category", data.getCategory());

		executeSql(sql.toString(), mapSqlParameterSource);
	}

	/**
	 * @Description： 更新系统配置静态数据
	 * @author: mayanpei
	 * @date: 2014-8-20 下午5:03:51
	 * @param data
	 *            数据
	 */
	public void updateStaticData(ClientData data) {
		StringBuffer sql = new StringBuffer();
		sql.append(" UPDATE  t_ucm_client_data SET c_data_client =:clientName,c_data_value=:value,");
		sql.append(" c_data_note=:note,n_data_type=:type,c_data_file=:file,");
		sql.append(" c_update_time=:updateTime,n_notice_result=:result");
		sql.append(" WHERE n_id=:id");

		// 构造参数
		MapSqlParameterSource mapSqlParameterSource = new MapSqlParameterSource();
		mapSqlParameterSource.addValue("clientName", data.getDataClient());
		mapSqlParameterSource.addValue("value", data.getDataValue());
		mapSqlParameterSource.addValue("note", data.getNote());
		mapSqlParameterSource.addValue("type", data.getDataType());
		mapSqlParameterSource.addValue("file", data.getDataFile());
		mapSqlParameterSource.addValue("updateTime", DateUtils.getToday());
		mapSqlParameterSource.addValue("result", Constants.SEND_RESULT_UNSEND);
		mapSqlParameterSource.addValue("id", data.getId());

		executeSql(sql.toString(), mapSqlParameterSource);
	}

	/**
	 * @Description：删除系统配置公共静态数据
	 * @author: mayanpei
	 * @date: 2014-8-20 下午5:03:38
	 * @param id
	 *            数据ID
	 */
	public void deleteStaticData(Long id, Map<String,Object> keyValue, List<Map<String, Object>>clientList) throws Exception{
		
		StringBuffer sql = new StringBuffer("DELETE FROM t_ucm_client_data WHERE n_id=:id");
		executeSql(sql.toString(), new MapSqlParameterSource().addValue("id", id));
		
		
		SendDataBean bean = new SendDataBean();

			
			//3：分别对各个子系统群集信息进行处理
			for ( int i = 0; i < clientList.size(); i++ ) {
				
				Map<String, Object> client = clientList.get(i);

				// 4：查询子系统群集主机配置信息(主要获得群集各个主机的ip地址及端口)
				List<Map<String, Object>> listChild = this.queryClientChild(Long.parseLong(client.get("n_id").toString()));
				for (Map<String, Object> child : listChild) {

					/**
					 * 封装发送配制参数对象
					 */
					bean = new SendDataBean();
					bean.setDataKey(keyValue.get("c_data_key").toString());
					bean.setDataValue(keyValue.get("c_data_value").toString());
					bean.setDataType(2);
					bean.setServerIp(child.get("c_ip").toString());
					bean.setServerPort(child.get("c_port").toString());
					bean.setAppCode(Constants.COMMON_SYSTEM_CLIENT);

					// 5：发送配制参数
					JmxClient.delKey(bean);
				}

			}
			logger.info("发送数据删除：" + JSON.toJSONString(bean));
	}
	
	public void deleteStaticData(Long id, Map<String, Object> map, Client client) throws Exception{
		
		StringBuffer sql = new StringBuffer("DELETE FROM t_ucm_client_data WHERE n_id=:id");
		executeSql(sql.toString(), new MapSqlParameterSource().addValue("id", id));
		SendDataBean bean = new SendDataBean();
		
		List<Map<String, Object>> listChild = this.queryClientChild(Long.parseLong(client.getId().toString()));
		for (Map<String, Object> child : listChild) {

			/**
			 * 封装发送配制参数对象
			 */
			bean = new SendDataBean();
			bean.setDataKey(map.get("c_data_key").toString());
			bean.setDataValue(map.get("c_data_value").toString());
			bean.setDataType(1);
			bean.setServerIp(child.get("c_ip").toString());
			bean.setServerPort(child.get("c_port").toString());
			bean.setAppCode(map.get("c_data_client").toString());

			// 5：发送配制参数
			JmxClient.delKey(bean);
		}
	}
	
	public void deleteStaticData(Long id) throws Exception {
		
		StringBuffer sql = new StringBuffer("DELETE FROM t_ucm_client_data WHERE n_id=:id");
		executeSql(sql.toString(), new MapSqlParameterSource().addValue("id", id));
	}

	/**
	 * @Description：下载文件时用IO流将字段中保存的文件内容读出
	 * @author: mayanpei
	 * @date: 2014-8-21 下午2:55:49
	 * @param fileName
	 *            文件名
	 * @return
	 */
	public InputStream queryFile(Long id) throws Exception {
		StringBuilder sql = new StringBuilder("SELECT c_data_value FROM t_ucm_client_data ");
		sql.append("WHERE  n_id=? ");
		ResourceBundle bundle = ResourceBundle.getBundle("system_init");
		String url = bundle.getString("db.url");
		String user = bundle.getString("db.username");
		String pwd = bundle.getString("db.password");
		Connection connection = DriverManager.getConnection(url, user, pwd);
		PreparedStatement ps = connection.prepareStatement(sql.toString());
		ps.setLong(1, id);
		ResultSet rs = ps.executeQuery();
		rs.next();
		InputStream in = rs.getBinaryStream("c_data_value");
		rs.close();
		return in;
	}

	/**
	 * @Description：修改发送结果
	 * @author: mayanpei
	 * @date: 2014-8-29 下午3:48:17
	 * @param id
	 * @param result
	 */
	public void updateResult(Long id, Integer result) {
		String updateSql = "UPDATE t_ucm_client_data SET n_notice_result =:result,c_notice_time = :time WHERE n_id =:id";
		MapSqlParameterSource param = new MapSqlParameterSource();
		param.addValue("result", result);
		param.addValue("time", DateUtils.getToday());
		param.addValue("id", id);
		executeSql(updateSql, param);
	}

	/**
	 * @Description： 修改发送结果
	 * @author: mayanpei
	 * @date: 2014-9-4 下午12:09:03
	 * @param listId
	 * @param result
	 */
	public void updateResult(List<Long> listId, Integer result) {
		if (listId.size() > 0) {
			String updateSql = "UPDATE t_ucm_client_data SET n_notice_result =:result,c_notice_time = :time WHERE n_id =:id";
			MapSqlParameterSource[] sqlParams = new MapSqlParameterSource[listId.size()];
			for (int i = 0; i < listId.size(); i++) {
				MapSqlParameterSource param = new MapSqlParameterSource();
				param.addValue("result", result);
				param.addValue("time", DateUtils.getToday());
				param.addValue("id", listId.get(i));
				sqlParams[i] = param;
			}
			addOrUpdate(updateSql, sqlParams);
		}
	}
	
 

	/**
	 * @Description：判断添加的系统配置参数键值是否存在
	 * @author: mayanpei
	 * @date: 2014-9-4 下午3:04:53
	 * @param shortName
	 * @param key
	 * @return
	 */
	public boolean queryKeyExist(String shortName, String key) {
		String sql = "SELECT n_id FROM t_ucm_client_data WHERE c_data_client =:shortName AND c_data_key=:key";
		MapSqlParameterSource sqlParam = new MapSqlParameterSource();
		sqlParam.addValue("shortName", shortName);
		sqlParam.addValue("key", key);
		if (queryForList(sql, sqlParam).size() > 0) {
			return false;
		}
		return true;
	}
	
	/**
	 * 根据静态数据ID，查询静态数据详情
	 * @author: mayanpei
	 * @date: 2014-9-4 下午3:04:53
	 * @param staticDataId
	 * @return
	 */
	public Map<String, Object> queyrStaticData(Long staticDataId){
		StringBuilder sql = new StringBuilder("select n_id,c_data_client,");
		sql.append(" c_data_key,c_data_value,c_data_note,n_data_type,c_data_file, ");
		sql.append(" c_add_time,n_user_id,c_update_time,c_notice_time,n_notice_result,c_category  ");
		sql.append(" FROM t_ucm_client_data WHERE n_id =:id ");
		return queryForMap(sql.toString(), new MapSqlParameterSource().addValue("id", staticDataId));
	}
	
	/**
	 * 根据系统id,查询系统群集下的所有系统配置信息
	 * @return
	 */
	public List<Map<String, Object>> queryClientChild(Long clientId) {
		StringBuilder sql = new StringBuilder("SELECT ucl.n_id,ucl.c_client,ucl.c_ip,");
		sql.append(" ucl.c_port,ucl.c_note,ucl.d_date");
		sql.append(" FROM t_ucm_client_list ucl ");
		sql.append(" LEFT JOIN t_ucm_client uc ON ucl.c_client = uc.c_short_name WHERE uc.n_id = :id");
		return queryForList(sql.toString(), new MapSqlParameterSource().addValue("id", clientId));
	}
	
	/**
	 * 根据系统名称，查询集群主机配制信息
	 * @param client
	 * @return
	 */
	public List<Map<String, Object>> queryClientList(String client) {
		String sql = "SELECT n_id,c_client,c_ip,c_port,c_note,d_date FROM t_ucm_client_list WHERE c_client=:client ";
		return queryForList(sql, new MapSqlParameterSource().addValue("client", client));
	}
	
	
	/**
	 * 根据系统名称，查询集群主机配制信息
	 * @param client
	 * @return
	 */
	public List<Map<String, Object>> queryClientById(String clientId) {
		String sql = "SELECT n_id,c_client,c_ip,c_port,c_note,d_date FROM t_ucm_client_list WHERE n_id IN(:clientId) ";
		return queryForList(sql, new MapSqlParameterSource().addValue("clientId", Arrays.asList(clientId.split(","))));
	}
	/**
	 * 查询所有子系统群集Ip、port信息
	 * @param userType
	 * @param userId
	 * @param pageSize
	 * @param pageNo
	 * @return
	 */
	public List<Map<String, Object>> queryClientDataList(Integer userType, Long userId, Integer pageSize, Integer pageNo) {
		
		if(userType == Constants.SUPER_ADMINISTRATOR){
			
			StringBuilder sql = new StringBuilder("SELECT ucl.n_id,ucl.c_client,ucl.c_ip,ucl.c_port");
			sql.append("  FROM t_ucm_client_list ucl ORDER BY ucl.c_client , ucl.d_date ASC");
			
			SQLUtil util = new SQLUtil(sql.toString(), pageNo, pageSize);
			return queryForList(util.getPageSql(), new MapSqlParameterSource());
		} else {
			
			StringBuilder builder = new StringBuilder("SELECT ucl.n_id,ucl.c_client,ucl.c_ip,ucl.c_port ");
			builder.append(" FROM t_ucm_client_list ucl RIGHT  JOIN (SELECT uc.c_client_name FROM t_ucm_user_client uuc ");
			builder.append(" LEFT JOIN t_ucm_client uc ON uuc.n_client_id = uc.n_id WHERE uuc.n_user_id =:userId) tb  ");
			builder.append(" ON ucl.c_client = tb.c_client_name ORDER BY ucl.c_client , ucl.d_date ASC");
			
			SQLUtil util = new SQLUtil(builder.toString(), pageNo, pageSize);
			return queryForList(util.getPageSql(), new MapSqlParameterSource().addValue("userId", userId));
		}
	}
	
	/**
	 * 查询子系统集群配置总数
	 * @param userType
	 * @param userId
	 * @return
	 */
	public Integer queryClientDataCount(Integer userType, Long userId) {
		if(userType == Constants.SUPER_ADMINISTRATOR){
			StringBuilder sql = new StringBuilder( "SELECT ucl.n_id,ucl.c_client,ucl.c_ip,ucl.c_port  ");
			sql.append(" FROM t_ucm_client_list ucl");
			sql.append(" ORDER BY ucl.c_client , ucl.d_date ASC");
			SQLUtil sqlUtil = new SQLUtil(sql.toString());
			return queryForInt(sqlUtil.getCountSQL(), new MapSqlParameterSource());
		} else {
			StringBuilder builder = new StringBuilder("SELECT ucl.n_id,ucl.c_client,ucl.c_ip,ucl.c_port ");
			builder.append(" FROM t_ucm_client_list ucl RIGHT  JOIN (SELECT uc.c_client_name FROM t_ucm_user_client uuc ");
			builder.append(" LEFT JOIN t_ucm_client uc ON uuc.n_client_id = uc.n_id WHERE uuc.n_user_id =:userId) tb  ");
			builder.append(" ON ucl.c_client = tb.c_client_name ORDER BY ucl.c_client , ucl.d_date ASC");
			SQLUtil sqlUtil = new SQLUtil(builder.toString());
			return queryForInt(sqlUtil.getCountSQL(), new MapSqlParameterSource().addValue("userId", userId));
		}
	}
	/**
	 * 根据集群里的ID，查询集群列表
	 * @param clientId
	 * @return
	 */
	public List<Map<String, Object>> queryColony(List<String> clientId) {
		String sql = "SELECT ul.n_id,ul.c_ip,ul.c_port FROM t_ucm_client_list ul WHERE ul.n_id IN(:clientId)";
		return queryForList(sql, new MapSqlParameterSource().addValue("clientId", clientId));
	}
	
	/**
	 * @Description： 根据子系统简称查询数据子系统详情
	 * @author: mayanpei
	 * @date: 2014-8-25 上午9:15:22
	 * @param shortName
	 *            系统简称
	 * @return Client
	 */
	public Client queryConfigByName(String shortName) {
		StringBuffer sql = new StringBuffer("SELECT n_id,c_client_name,c_short_name, ");
		sql.append(" c_client_ip,c_client_port,n_user_id,c_note,c_add_time,c_update_time  ");
		sql.append(" FROM t_ucm_client WHERE 1=1 ");
		MapSqlParameterSource param = new MapSqlParameterSource();

		// 系统名称简称
		if (StringUtils.isNotBlank(shortName)) {
			sql.append(" AND c_short_name = :shortName");
			param.addValue("shortName", shortName.toLowerCase());
		}

		RowMapper<Client> mapper = new RowMapper<Client>() {
			public Client mapRow(ResultSet rs, int rowNum) throws SQLException {
				Client client = new Client();
				client.setId(rs.getLong("n_id"));
				client.setClientName(rs.getString("c_client_name"));
				client.setShortName(rs.getString("c_short_name"));
				client.setClientIp(rs.getString("c_client_ip"));
				client.setClientPort(rs.getString("c_client_port"));
				client.setUserId(rs.getLong("n_user_id"));
				client.setAddTime(rs.getString("c_add_time"));
				client.setUpdateTime(rs.getString("c_update_time"));
				return client;
			}
		};
		return queryForObject(sql.toString(), param, mapper);
	}
}
