package com.xdja.base.ucm.systemconfig.manager;

import java.util.List;

import com.xdja.base.ucm.systemconfig.entity.Cluster;

/**
 * 
 * @author liqi
 *
 */

public interface ClusterManager { 
 
	/**
	 * 根据系统简称，查询群集列表
	 * @param shortName
	 * @return
	 */
	List<Cluster> queryClusterList(String shortName);  
	 
	/**
	 * 根据集群ID，查询详情
	 * @param id
	 * @return
	 */
	Cluster queryClusterById(Long id); 
	 
	/**
	 * 添加集群主机配制
	 * @param Cluster
	 */
	void addCluster(Cluster Cluster);
 
	/**
	 * 更新集群主机配制
	 * @param Cluster
	 */
	void updateCluster(Cluster Cluster); 
	 
	/**
	 * 根据ID删除集群主机配制
	 * @param id
	 */
	void deleteCluster(Long id);

}
