package com.xdja.base.ucm.systemconfig.manager;

import java.util.List;
import java.util.Map;

import com.xdja.base.ucm.systemconfig.bean.QueryConfigBean;
import com.xdja.base.ucm.systemconfig.entity.Client;

/**
 * @ProjectName：ucm
 * @ClassName：SystemDataManager
 * @Description：子系统数据管理接口
 * @author: mayanpei
 * @date: 2014-8-20 上午11:22:00
 * 
 */
public interface ConfigManager {

	/**
	 * @Description：查询子系统数据总数
	 * @author: mayanpei
	 * @date: 2014-8-20 上午11:22:13
	 * @param queryBean
	 *            查询bean
	 * @return Integer
	 */
	Integer queryConfigCount(QueryConfigBean queryBean);

	/**
	 * @Description：查询子系统数据信息
	 * @author: mayanpei
	 * @date: 2014-8-20 上午11:22:13
	 * @param queryBean
	 *            查询bean
	 * @return List<Map<String, Object>>
	 */
	List<Map<String, Object>> queryConfigList(QueryConfigBean queryBean);

	/**
	 * @Description：查询所有子系统数据
	 * @author: mayanpei
	 * @date: 2014-8-20 上午11:34:14
	 * @param userId
	 *            用户ID
	 * @return
	 */
	List<Map<String, Object>> queryConfigList(Long userId);

	/**
	 * @Description：根据ID查询子系统数据详情
	 * @author: mayanpei
	 * @date: 2014-8-20 上午11:34:14
	 * @param id
	 *            子系统配置id
	 * @return Map<String, Object>
	 */
	Map<String, Object> queryConfigById(Long id);

	/**
	 * @Description：添加子系统数据
	 * @author: mayanpei
	 * @date: 2014-8-20 下午3:35:24
	 * @param client
	 *            子系统
	 * @param userId
	 *            操作人ID
	 */
	void addConfig(Client client, Long userId);

	/**
	 * @Description：修改子系统数据
	 * @author: mayanpei
	 * @date: 2014-8-20 下午3:35:31
	 * @param client
	 *            子系统
	 */
	void updateConfig(Client client);

	/**
	 * @Description：删除子系统数据
	 * @author: mayanpei
	 * @date: 2014-8-20 下午3:35:07
	 * @param id
	 *            配置ID
	 */
	void deleteConfig(Long id);

	/**
	 * 查询子系统配置名和系统简称是否存在
	 * 
	 * @author: mayanpei
	 * @date: 2014-8-25 上午9:10:50
	 * @param name
	 *            系统名称
	 * @param shortName
	 *            系统简称
	 * @return boolean true:系统名或者简称不存在；false：系统名或者系统简称存在
	 */
	boolean queryConfigByName(String name, String shortName);

	/**
	 * @Description： 根据子系统简称查询数据子系统详情
	 * @author: mayanpei
	 * @date: 2014-8-25 上午9:15:22
	 * @param shortName
	 *            系统简称
	 * @return Client
	 */
	Client queryConfigByName(String shortName);
	

	/**
	 * @Description： 根据子系统简称查询系统列表
	 * @author: mayanpei
	 * @date: 2014-8-25 上午9:15:22
	 * @param shortName
	 *            系统简称
	 * @return Client
	 */
	public List<Map<String, Object>> queryClientList();

	/**
	 * 根据系统简称，查询所有系统静态配置参数
	 * 
	 * @author: mayanpei
	 * @date: 2014-9-4 上午11:32:44
	 * @param shortName
	 *            系统简称
	 * @return
	 */
	List<Map<String, Object>> queryConfigStaticData(String shortName);
}
