package com.xdja.base.ucm.systemconfig.manager;

import java.io.InputStream;
import java.util.List;
import java.util.Map;

import com.xdja.base.ucm.systemconfig.bean.QueryStaticDataBean;
import com.xdja.base.ucm.systemconfig.entity.Client;
import com.xdja.base.ucm.systemconfig.entity.ClientData;

/**
 * @ProjectName：ucm
 * @ClassName：StaticDataManager
 * @Description：静态数据处理
 * @author: mayanpei
 * @date: 2014-8-20 下午2:10:03
 */
public interface StaticDataManager {

	/**
	 * @Description：查询静态数据
	 * @author: mayanpei
	 * @date: 2014-8-20 下午2:08:07
	 * @param queryBean
	 *            查询bean
	 * @return
	 */
	List<Map<String, Object>> queryList(QueryStaticDataBean queryBean);

	/**
	 * @Description：查询静态数据总数
	 * @author: mayanpei
	 * @date: 2014-8-20 下午2:08:07
	 * @param queryBean
	 *            查询bean
	 * @return
	 */
	Integer queryCommonCount(QueryStaticDataBean queryBean);
	
	/**
	 * @Description：查询静态数据
	 * @author: mayanpei
	 * @date: 2014-8-20 下午2:08:07
	 * @param queryBean
	 *            查询bean
	 * @return
	 */
	List<Map<String, Object>> queryCommonList(QueryStaticDataBean queryBean);

	/**
	 * @Description：查询静态数据总数
	 * @author: mayanpei
	 * @date: 2014-8-20 下午2:08:07
	 * @param queryBean
	 *            查询bean
	 * @return
	 */
	Integer queryCount(QueryStaticDataBean queryBean);

	/**
	 * @Description：根据ID，查询静态数据详情
	 * @author: mayanpei
	 * @date: 2014-8-20 下午2:08:07
	 * @param id
	 *            配置数据ID
	 * @return
	 */
	Map<String, Object> queryStaticDataById(Long id);
	
	/**
	 * @Description：根据ID，查询公共静态数据详情
	 * @author: mayanpei
	 * @date: 2014-8-20 下午2:08:07
	 * @param id
	 *            配置数据ID
	 * @return
	 */
	Map<String, Object> queryCommonStaticDataById(Long id);

	/**
	 * @Description：添加系统配置静态数据
	 * @author: mayanpei
	 * @date: 2014-8-20 下午5:03:59
	 * @param data
	 *            数据
	 * @param userId
	 *            用户ID
	 * @throws Exception
	 *             异常
	 */
	ClientData addStaticData(ClientData data, Long userId) throws Exception;

	/**
	 * @Description： 更新系统配置静态数据
	 * @author: mayanpei
	 * @date: 2014-8-20 下午5:03:51
	 * @param data
	 *            数据
	 * @throws Exception
	 *             异常
	 */
	void updateStaticData(ClientData data) throws Exception;

	/**
	 * @Description：删除系统配置静态数据
	 * @author: mayanpei
	 * @date: 2014-8-20 下午5:03:38
	 * @param id
	 *            数据ID
	 */
	void deleteStaticData(Long id, Map<String,Object> keyValue, List<Map<String, Object>>clientList) throws Exception;
	
	/**
	 * 删除系统配置静态数据
	 * @param id
	 * @throws Exception
	 */
	void deleteStaticData(Long id, Map<String, Object> map, Client client) throws Exception;
	
	public void deleteStaticData(Long id) throws Exception;

	/**
	 * @Description：用IO流将文件读出
	 * @author: mayanpei
	 * @date: 2014-8-21 下午2:53:16
	 * @param id
	 *            静态数据ID
	 * @throws Exception
	 *             抛出的异常
	 * @return
	 */
	InputStream queryFile(Long id) throws Exception;

	/**
	 * @Description：修改执行结果
	 * @author: mayanpei
	 * @date: 2014-8-29 下午3:49:06
	 * @param id
	 *            静态配置参数数据ID
	 * @param result
	 *            发送结果
	 */
	void updateResult(Long id, Integer result);

	/**
	 * @Description：修改执行结果
	 * @author: mayanpei
	 * @date: 2014-8-29 下午3:49:06
	 * @param listId
	 *            静态配置参数数据ID
	 * @param result
	 *            发送结果
	 */
	void updateResult(List<Long> listId, Integer result);

	/**
	 * @Description：获取文件内容
	 * @author: mayanpei
	 * @date: 2014-8-21 下午2:53:16
	 * @param id
	 *            静态数据ID
	 * @throws Exception
	 *             抛出的异常
	 * @return
	 */
	String queryFileContents(Long id) throws Exception;

	/**
	 * 判断添加的系统健值是否存在
	 * 
	 * @author: mayanpei
	 * @date: 2014-9-4 下午3:02:43
	 * @param shortName
	 *            系统简称
	 * @param key
	 *            键值
	 */
	boolean queryKeyExist(String shortName, String key);
	
	
	/**
	 * 根据静态数据ID，查询静态数据详情
	 * @author: mayanpei
	 * @date: 2014-9-4 下午3:04:53
	 * @param staticDataId
	 * @return  Map<String, Object> 静态数据
	 */
	Map<String, Object> queyrStaticData(Long staticDataId);
	
	
	/**
	 * 根据系统id,查询系统群集下的所有系统配置信息
	 * @author: mayanpei
	 * @date: 2014-9-4 下午3:04:53
	 * @param clientId
	 * @return List<Map<String, Object>> 群集列表
	 */
	List<Map<String, Object>> queryClientChild(Long clientId);
	
	
	/**
	 * 查询配置数据详情
	 * @param categroy
	 * @param id
	 * @return Map<String, Object> 配制数据
	 */
	Map<String, Object> queryClientCommonData(String categroy, Long id);
	
	/**
	 * 根据系统名称，查询集群主机配制信息
	 * @param client
	 * @return List<Map<String, Object>> 
	 */
	List<Map<String, Object>> queryClientList(String client);
	
	/**
	 * 根据系统名称，查询集群主机配制信息
	 * @param client
	 * @return List<Map<String, Object>> 
	 */
	List<Map<String, Object>> queryClientById(String clientId);
	
	/**
	 * 查询所有子系统群集Ip、port信息
	 * @param userType
	 * @param userId
	 * @param pageSize
	 * @param pageNo
	 * @return
	 */
	public List<Map<String, Object>> queryClientDataList(Integer userType, Long userId, Integer pageSize, Integer pageNo);
	
	/**
	 *  查询所有子系统群集Ip、port信息总数
	 * @param userType
	 * @param userId
	 * @return
	 */
	public Integer queryClientDataCount(Integer userType, Long userId);
	
	/**
	 * 根据集群里的ID，查询集群列表
	 * @param clientId
	 * @return
	 */
	public List<Map<String, Object>> queryColony(List<String> clientId);
}
