package com.xdja.base.ucm.systemconfig.manager.impl;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xdja.base.ucm.systemconfig.bean.QueryConfigBean;
import com.xdja.base.ucm.systemconfig.dao.ConfigDao;
import com.xdja.base.ucm.systemconfig.entity.Client;
import com.xdja.base.ucm.systemconfig.manager.ConfigManager;

/**
 * @ProjectName：ucm
 * @ClassName：ConfigManagerImpl
 * @Description：配置管理接口实现
 * @author: mayanpei
 * @date: 2014-8-20 下午3:37:48
 */
@Service
public class ConfigManagerImpl implements ConfigManager {

	@Autowired
	private ConfigDao dao;

	@Override
	public Integer queryConfigCount(QueryConfigBean queryBean) {
		return dao.queryConfigCount(queryBean);
	}

	@Override
	public List<Map<String, Object>> queryConfigList(QueryConfigBean queryBean) {
		return dao.queryConfigList(queryBean);
	}

	@Override
	public List<Map<String, Object>> queryConfigList(Long userId) {
		return dao.queryConfigList(userId);
	}

	@Override
	public void addConfig(Client client, Long userId) {
		dao.addConfig(client, userId);
	}

	@Override
	public void updateConfig(Client client) {
		dao.updateConfig(client);
	}

	@Override
	public void deleteConfig(Long id) {
		dao.deleteConfig(id);
	}

	@Override
	public Map<String, Object> queryConfigById(Long id) {
		return dao.queryConfigById(id);
	}

	@Override
	public boolean queryConfigByName(String name, String shortName) {
		if (dao.queryConfigByName(name, shortName).size() > 0) {
			return false;
		}
		return true;
	}
	
	/**
	 * @Description： 根据子系统简称查询系统列表
	 * @author: mayanpei
	 * @date: 2014-8-25 上午9:15:22
	 * @return Client
	 */
	public List<Map<String, Object>> queryClientList()  {
		return dao.queryClientList();
	}

	@Override
	public Client queryConfigByName(String shortName) {
		return dao.queryConfigByName(shortName);
	}

	@Override
	public List<Map<String, Object>> queryConfigStaticData(String shortName) {
		return dao.queryConfigStaticData(shortName);
	}
}
