package com.xdja.base.ucm.systemconfig.manager.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xdja.base.ucm.systemconfig.bean.QueryStaticDataBean;
import com.xdja.base.ucm.systemconfig.dao.StaticDataDao;
import com.xdja.base.ucm.systemconfig.entity.Client;
import com.xdja.base.ucm.systemconfig.entity.ClientData;
import com.xdja.base.ucm.systemconfig.manager.StaticDataManager;
import com.xdja.base.util.Constants;
import com.xdja.base.util.HttpSessionUtil;

/**
 * @ProjectName：ucm
 * @ClassName：StaticDataManagerImpl
 * @Description：接口实现
 * @author: mayanpei
 * @date: 2014-8-20 下午2:11:20
 */
@Service
public class StaticDataManagerImpl implements StaticDataManager {

	@Autowired
	private StaticDataDao dao;
	
	
	@Override
	public List<Map<String, Object>> queryCommonList(QueryStaticDataBean queryBean) {
		return dao.queryCommonList(queryBean);
	}

	@Override
	public Integer queryCommonCount(QueryStaticDataBean queryBean) {
		return dao.queryCommonCount(queryBean);
	}
	

	@Override
	public List<Map<String, Object>> queryList(QueryStaticDataBean queryBean) {
		return dao.queryList(queryBean);
	}

	@Override
	public Integer queryCount(QueryStaticDataBean queryBean) {
		return dao.queryCount(queryBean);
	}

	@Override
	public Map<String, Object> queryStaticDataById(Long id) {
		return dao.queryStaticDataById(id);
	}

	@Override
	public ClientData addStaticData(ClientData data, Long userId) throws Exception {
		StringBuilder dataBuilder = new StringBuilder();
		if (data.getDataType().intValue() == Constants.STATIC_DATA_TYPE_FILE.intValue()) {

			File file = new File(HttpSessionUtil.getUploadPath(), data.getDataValue());
			BufferedReader reader = new BufferedReader(new FileReader(file));

			String line = reader.readLine();

			while (line != null) {
				dataBuilder.append(line);
				line = reader.readLine();
			}

			data.setDataValue(dataBuilder.toString());
			reader.close(); // 关闭流
			file.delete(); // 删除文件
		}
		dao.addStaticData(data, userId);
		return data;
	}

	@Override
	public void updateStaticData(ClientData data) throws Exception {
		StringBuilder dataBuilder = new StringBuilder();
		if (data.getDataType().intValue() == Constants.STATIC_DATA_TYPE_FILE.intValue()) {

			File file = new File(HttpSessionUtil.getUploadPath(), data.getDataValue());
			BufferedReader reader = new BufferedReader(new FileReader(file));

			String line = reader.readLine();

			while (line != null) {
				dataBuilder.append(line);
				line = reader.readLine();
			}

			data.setDataValue(dataBuilder.toString());
			reader.close(); // 关闭流
			file.delete(); // 删除文件
		}
		dao.updateStaticData(data);
	}

	@Override
	public void deleteStaticData(Long id, Map<String,Object> keyValue, List<Map<String, Object>>clientList)  throws Exception{
		dao.deleteStaticData(id, keyValue, clientList);
	}
	@Override
	public void deleteStaticData(Long id,Map<String, Object> map, Client client) throws Exception{
		dao.deleteStaticData(id, map, client);
	}
	
	@Override
	public void deleteStaticData(Long id) throws Exception {
		dao.deleteStaticData(id);
	}

	@Override
	public InputStream queryFile(Long id) throws Exception {
		return dao.queryFile(id);
	}

	@Override
	public void updateResult(Long id, Integer result) {
		dao.updateResult(id, result);
	}

	@Override
	public String queryFileContents(Long id) throws Exception {
		StringBuilder dataBuilder = new StringBuilder();
		InputStream in = dao.queryFile(id);
		InputStreamReader ir = new InputStreamReader(in);
		BufferedReader reader = new BufferedReader(ir);
		String line = reader.readLine();

		while (line != null) {
			dataBuilder.append(line);
			line = reader.readLine();
		}
		return dataBuilder.toString();
	}

	@Override
	public void updateResult(List<Long> listId, Integer result) {
		dao.updateResult(listId, result);
	}

	@Override
	public boolean queryKeyExist(String shortName, String key) {
		return dao.queryKeyExist(shortName, key);
	}

	@Override
	public Map<String, Object> queyrStaticData(Long staticDataId) {
		return dao.queyrStaticData(staticDataId);
	}

	@Override
	public List<Map<String, Object>> queryClientChild(Long clientId) {
		return dao.queryClientChild(clientId);
	}
	
	@Override
	public Map<String, Object> queryClientCommonData(String categroy, Long id) {
		return dao.queryClientCommonData(categroy, id);
	}
	
	@Override
	public List<Map<String, Object>> queryClientList(String client) {
		return dao.queryClientList(client);
	} 
	
	@Override
	public List<Map<String, Object>> queryClientById(String clientId) {
		return dao.queryClientById(clientId);
	}

	@Override
	public List<Map<String, Object>> queryClientDataList(Integer userType, Long userId, Integer pageSize, Integer pageNo) {
		return dao.queryClientDataList(userType, userId, pageSize ,pageNo);
	}

	@Override
	public Integer queryClientDataCount(Integer userType, Long userId) {
		return dao.queryClientDataCount(userType, userId);
	}
	@Override
	public List<Map<String, Object>> queryColony(List<String> clientId) {
		return dao.queryColony(clientId);
	}
	
	@Override
	public Map<String, Object> queryCommonStaticDataById(Long id) {
		return dao.queryCommonStaticDataById(id);
	}
	
}
