package com.xdja.base.ucm.systemconfig.operate;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSON;
import com.xdja.base.ucm.systemconfig.operate.jmx.bean.SendDataBean;
import com.xdja.base.ucm.systemconfig.operate.jmx.bean.UcmMessageMBean;
import com.xdja.base.util.Constants;

/**
 * @ProjectName：ucm
 * @ClassName：JmxClient
 * @Description： JMX客户端
 * @author: mayanpei
 * @date: 2014-9-3 下午4:23:17
 * 
 */
public class JmxClient {

	private static Logger logger = LoggerFactory.getLogger(JmxClient.class);
	
	private static final String JMX_OBJECTNAME = "com.xdja.ucm.%s.jmx:name=%sJMXConfigure";
	private static final String JMX_SERVICE_NAME = "jmxServerApi";

	
	/**
	 * 
	 * @Description：删除子系统，小心操作
	 * @author: liqi
	 * @date: 2014-9-23 下午3:44:50
	 * @param dataBean 子系统相关数据
	 * @throws Exception
	 */
	public static void delClient(SendDataBean dataBean) throws Exception {
		String rmiUrl = String.format("service:jmx:rmi:///jndi/rmi://%s:%s/%s/%s", 
				dataBean.getServerIp().trim(), 
				dataBean.getServerPort().trim(), 
				JMX_SERVICE_NAME,
				dataBean.getAppCode().trim()
				);

		//logger.info(rmiUrl);

		JMXServiceURL url = null;
		JMXConnector jmxc = null;
		
		try {
			url = new JMXServiceURL(rmiUrl);

			jmxc = JMXConnectorFactory.connect(url, null);
	
			MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
	
			ObjectName mbeanName = new ObjectName(String.format(JMX_OBJECTNAME, dataBean.getAppCode().trim(), dataBean.getAppCode().trim()));
			UcmMessageMBean mbeanProxy = JMX.newMBeanProxy(mbsc, mbeanName, UcmMessageMBean.class, true);
			mbeanProxy.delClient();
		
			logger.info("delClient发送数据:" + JSON.toJSONString(dataBean));
		} catch(Exception ex) {
			
			logger.error("delClient发送消息出现异常：", ex.getLocalizedMessage());
			throw ex;
			
		} finally {
			try {
				
				jmxc.close();
			} catch(Exception ex) {
				
				logger.error("delClient RMI资源关闭异常：", ex.getLocalizedMessage());
			} finally {
				
				jmxc = null;
			}
		}
	}
	
	
	
	/**
	 * 
	 * @Description：删除某一个key
	 * @author: liqi
	 * @date: 2014-9-23 下午3:43:25
	 * @param dataBean 子系统相关数据
	 * @throws Exception
	 */
	public static void delKey(SendDataBean dataBean) throws Exception {
		String rmiUrl = String.format("service:jmx:rmi:///jndi/rmi://%s:%s/%s/%s", 
				dataBean.getServerIp().trim(), 
				dataBean.getServerPort().trim(), 
				JMX_SERVICE_NAME,
				dataBean.getAppCode().trim()
				);

		//logger.info(rmiUrl);

		JMXServiceURL url = null;
		JMXConnector jmxc = null;
		
		try {
			url = new JMXServiceURL(rmiUrl);

			jmxc = JMXConnectorFactory.connect(url, null);
	
			MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
	
			ObjectName mbeanName = new ObjectName(String.format(JMX_OBJECTNAME, dataBean.getAppCode().trim(), dataBean.getAppCode().trim()));
			UcmMessageMBean mbeanProxy = JMX.newMBeanProxy(mbsc, mbeanName, UcmMessageMBean.class, true);
			mbeanProxy.delData(dataBean.getDataKey());
		
			logger.info("delKey发送数据:" + JSON.toJSONString(dataBean));
		} catch(Exception ex) {
			
			logger.error("delKey发送消息出现异常：", ex.getLocalizedMessage());
			throw ex;
			
		} finally {
			try {
				
				jmxc.close();
			} catch(Exception ex) {
				
				logger.error("delKey RMI资源关闭异常：", ex.getLocalizedMessage());
			} finally {
				
				jmxc = null;
			}
		}
	}
	
	/**
	 * 发送配置参数数据
	 * 
	 * @author: mayanpei
	 * @date: 2014-9-3 下午4:24:26
	 * @update:2014-9-5 上午10:24:26
	 * @description: 将测试JMX变更为正式的JMX配置 liqi
	 * @param dataBean
	 *            配置参数bean
	 * @throws Exception
	 *             向上抛出异常
	 */
	public static void sendData(SendDataBean dataBean) throws Exception {
		
		String rmiUrl = String.format("service:jmx:rmi:///jndi/rmi://%s:%s/%s/%s", 
				dataBean.getServerIp().trim(), 
				dataBean.getServerPort().trim(), 
				JMX_SERVICE_NAME,
				dataBean.getAppCode().trim()
				);

		//logger.info(rmiUrl);

		JMXServiceURL url = null;
		JMXConnector jmxc = null;
		
		try {
			url = new JMXServiceURL(rmiUrl);

			jmxc = JmxClient.connectWithTimeout(url, Constants.SEND_TIME_OUT, TimeUnit.SECONDS);
//			jmxc = JMXConnectorFactory.connect(url, null);
	
			MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
	
			ObjectName mbeanName = new ObjectName(String.format(JMX_OBJECTNAME, dataBean.getAppCode().trim(), dataBean.getAppCode().trim()));
			UcmMessageMBean mbeanProxy = JMX.newMBeanProxy(mbsc, mbeanName, UcmMessageMBean.class, true);
	
			// 单个静态配置参数发送
			// 2014-09-05 liqi 按真实数据发送静态数据，取消非空限制
			if (StringUtils.isNotBlank(dataBean.getDataKey())) {
				Map<String, Object> dataMap = new ConcurrentHashMap<String, Object>();
				dataMap.put(dataBean.getDataKey(), dataBean.getDataValue());
				mbeanProxy.setData(dataMap);
			}
	
			// 如果不为空则为批量发送，
			if (dataBean.getDataMap() != null && !dataBean.getDataMap().isEmpty()) {
				mbeanProxy.setData(dataBean.getDataMap());
			}
		
			logger.info("发送数据:" + JSON.toJSONString(dataBean));
		} catch(Exception ex) {
			
			logger.error("发送消息出现异常：", ex.getLocalizedMessage());
			throw ex;
			
		} finally {
			try {
				
				jmxc.close();
			} catch(Exception ex) {
				
				logger.error("RMI资源关闭异常：", ex.getLocalizedMessage());
			} finally {
				
				jmxc = null;
			}
		}
		
	}

	public static void sendListData(List<SendDataBean> listBeans) throws Exception {
		for (SendDataBean dataBean : listBeans) {
			sendData(dataBean);
		}
	}
	
	/**
	 * 获得连接对象，并设置超时时间
	 * @author mayanpei
	 * @param url
	 * @param timeout
	 * @param unit
	 * @return
	 * @throws Exception 
	 * @throws IOException
	 */
	public static JMXConnector connectWithTimeout(final JMXServiceURL url, long timeout, TimeUnit unit) throws Exception {
		final BlockingQueue<Object> mailbox = new ArrayBlockingQueue<Object>(1);
		ExecutorService executor = Executors.newSingleThreadExecutor(daemonThreadFactory);
		executor.submit(new Runnable() {
			public void run() {
				try {
					JMXConnector connector = JMXConnectorFactory.connect(url);
					if (!mailbox.offer(connector))
						connector.close();
				} catch (Throwable t) {
					mailbox.offer(t);
				}
			}
		});
		Object result;
		try {
			result = mailbox.poll(timeout, unit);
			if (result == null) {
				if (!mailbox.offer(""))
					result = mailbox.take();
			}
		} catch (InterruptedException e) {
			throw e;
		} finally {
			executor.shutdown();
		}
		if (result == null) {
			logger.error("Connect timed out: " + url);
			throw new Exception("Connect timed out: " + url);
		}
		if (result instanceof JMXConnector)
			return (JMXConnector) result;
		
		return null;
	}
  
	private static class DaemonThreadFactory implements ThreadFactory {
		public Thread newThread(Runnable r) {
			Thread t = Executors.defaultThreadFactory().newThread(r);
			t.setDaemon(true);
			return t;
		}
	}

	private static final ThreadFactory daemonThreadFactory = new DaemonThreadFactory();
}
