package com.xdja.base.ucm.systemlog.action;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.xdja.base.common.action.BaseAction;
import com.xdja.base.system.entity.User;
import com.xdja.base.ucm.systemconfig.manager.ConfigManager;
import com.xdja.base.ucm.systemlog.bean.QueryLog;
import com.xdja.base.ucm.systemlog.manager.SystemLogManager;
import com.xdja.base.util.Constants;
import com.xdja.base.util.HttpSessionUtil;

/**
 * @ProjectName：ucm
 * @ClassName：SystemLogAction
 * @Description：日志管理
 * @author: mayanpei
 * @date: 2014-8-14 下午8:03:37
 */
@Controller
public class SystemLogAction extends BaseAction {

	@Autowired
	private SystemLogManager manager;

	@Autowired
	private ConfigManager configManager;

	/**
	 * @Description：日志管理首页
	 * @author: mayanpei
	 * @date: 2014-8-14 上午10:42:24
	 * @param log
	 * @param map
	 *            ModelMap
	 * @return
	 */
	@RequestMapping(value = "/log/index.do", method = RequestMethod.POST)
	public String index(ModelMap map) {
		User user = HttpSessionUtil.getUser();
		if (user == null) {
			return "redirect:/index.do";
		}
		Long userId = 0L;
		
		if(1 != user.getType()) {
			userId = user.getId();
		}
		map.put("data", configManager.queryConfigList(userId));
		map.put("userType", user.getType());
		return "/ucm/log/index";
	}

	/**
	 * @Description：查询日志总数
	 * @author: mayanpei
	 * @date: 2014-8-14 下午8:03:31
	 * @param log
	 *            日志bean
	 * @param map
	 *            ModelMap
	 * @param response
	 *            响应
	 */
	@RequestMapping(value = "/log/queryDataCount.do", method = RequestMethod.POST)
	public void queryDataCount(QueryLog log, ModelMap map, HttpServletResponse response) {
		try {
			User user = HttpSessionUtil.getUser();
			if (user.getType().intValue() == Constants.USUAL_ADMINISTRATOR.intValue()) {
				log.setUserName(user.getLoginName());
			}
			log.setUserType(user.getType());
			log.setUserId(user.getId());
			String result = getPageCount(manager.querySystemLogCount(log));
			logger.info(result);
			this.toClient(result, response);
		} catch (Exception e) {
			logger.error("查询日志记录总数出错！", e);
		}

	}

	/**
	 * @Description：查询日志数据
	 * @author: mayanpei
	 * @date: 2014-8-14 下午8:03:31
	 * @param log
	 *            日志bean
	 * @param map
	 *            ModelMap
	 * @param response
	 */
	@RequestMapping(value = "/log/queryDataList.do", method = RequestMethod.POST)
	public String queryDataList(QueryLog log, ModelMap map) {
		try {
			User user = HttpSessionUtil.getUser();
			if (user.getType().intValue() == Constants.USUAL_ADMINISTRATOR.intValue()) {
				log.setUserName(user.getLoginName());
			}
			log.setUserType(user.getType());
			log.setUserId(user.getId());
			map.put("data", manager.querySystemLogList(log));
		} catch (Exception e) {
			logger.error("查询日志数据出错", e);
		}
		return "/ucm/log/data";
	}

}
