package com.xdja.base.ucm.systemlog.dao;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.stereotype.Repository;

import com.xdja.base.common.dao.BaseDao;
import com.xdja.base.ucm.systemlog.bean.QueryLog;
import com.xdja.base.ucm.systemlog.entity.SystemLog;
import com.xdja.base.util.DateUtils;
import com.xdja.base.util.page.SQLUtil;

/**
 * @Description：系统日志
 * @author: mayanpei
 * @date: 2014-8-14 上午9:27:06
 * 
 */
@Repository
public class SystemLogDao extends BaseDao {

	/**
	 * @Description：添加系统日志
	 * @author: mayanpei
	 * @date: 2014-8-14 上午9:27:18
	 * @param log
	 *            日志
	 */
	public void addSystemLog(SystemLog log) {
		StringBuilder sql = new StringBuilder("INSERT INTO t_ucm_system_log ");
		sql.append(" ( n_admin_id,c_administrator,c_ip,c_log_content,n_log_level,");
		sql.append(" 	n_log_type,n_log_type_detail,c_log_time,c_system ) ");
		sql.append(" VALUES (:adminId,:admin,:ip,:content,:level,:type,:typeDetail,:time,:system)");

		// 构造参数
		MapSqlParameterSource map = new MapSqlParameterSource();
		map.addValue("adminId", log.getAdminId());
		map.addValue("admin", log.getAdministrator());
		map.addValue("ip", log.getIp());
		map.addValue("content", log.getLogContent());
		map.addValue("level", log.getLogLevel());
		map.addValue("type", log.getLogType());
		map.addValue("typeDetail", log.getLogTypeDetail());
		map.addValue("time", DateUtils.getToday());
		map.addValue("system", log.getSystem());

		executeSql(sql.toString(), map);
	}

	/**
	 * @Description：查询系统日志
	 * @author: mayanpei
	 * @date: 2014-8-14 上午9:53:37
	 * @param query
	 *            查询bean
	 * @return
	 */
	public List<Map<String, Object>> querySystemLogList(QueryLog query) {

		StringBuilder sql = new StringBuilder();
		sql.append(" SELECT n_id,n_admin_id,c_administrator,c_ip,c_log_content, ");
		sql.append(" 	 n_log_level,n_log_type,c_log_time,c_system,n_log_type_detail  ");
		sql.append(" FROM t_ucm_system_log WHERE 1=1");

		MapSqlParameterSource parameterSource = new MapSqlParameterSource();

		// 用户名
		if (StringUtils.isNotBlank(query.getUserName())) {
			sql.append(" AND c_administrator = :userName");
			parameterSource.addValue("userName", query.getUserName());
		}
		// 开始时间
		if (StringUtils.isNotBlank(query.getStartDate())) {
			sql.append(" AND c_log_time >= :start");
			parameterSource.addValue("start", query.getStartDate() + DateUtils.START);
		}

		// 结束时间
		if (StringUtils.isNotBlank(query.getEndDate())) {
			sql.append(" AND c_log_time <= :end");
			parameterSource.addValue("end", query.getEndDate() + DateUtils.END);
		}

		// 所属系统
		if (StringUtils.isNotBlank(query.getSystem())) {
			sql.append(" AND c_system LIKE :system");
			parameterSource.addValue("system", "%" + query.getSystem() + "%");
		}

		// 系统操作类型
		if (StringUtils.isNotBlank(query.getOperate())) {
			sql.append(" AND n_log_type_detail = :detail");
			parameterSource.addValue("detail", query.getOperate());
		}
		
		if(1 != query.getUserType()) {
			sql.append(" AND (n_admin_id = :userId or c_system in (SELECT c_short_name FROM t_ucm_client WHERE n_id in (SELECT n_client_id FROM t_ucm_user_client WHERE n_user_id = :cUserId ) )) ");
			parameterSource.addValue("userId", query.getUserId());
			parameterSource.addValue("cUserId", query.getUserId());
		}
		sql.append(" ORDER BY n_id DESC");
		SQLUtil util = new SQLUtil(sql.toString(), query.getPageNo(), query.getPageSize());
		return queryForList(util.getPageSql(), parameterSource);
	}

	/**
	 * @Description：查询系统日志
	 * @author: mayanpei
	 * @date: 2014-8-14 上午9:53:37
	 * @param query
	 *            查询bean
	 * @return int 总数
	 */
	public int querySystemLogCount(QueryLog query) {

		StringBuilder sql = new StringBuilder();
		sql.append(" SELECT n_id FROM t_ucm_system_log WHERE 1=1");

		MapSqlParameterSource parameterSource = new MapSqlParameterSource();

		// 用户名
		if (StringUtils.isNotBlank(query.getUserName())) {
			sql.append(" AND c_administrator = :userName");
			parameterSource.addValue("userName", query.getUserName());
		}

		// 开始时间
		if (StringUtils.isNotBlank(query.getStartDate())) {
			sql.append(" AND c_log_time >= :start");
			parameterSource.addValue("start", query.getStartDate() + DateUtils.START);
		}

		// 结束时间
		if (StringUtils.isNotBlank(query.getEndDate())) {
			sql.append(" AND c_log_time <= :end");
			parameterSource.addValue("end", query.getEndDate() + DateUtils.END);
		}

		// 所属系统
		if (StringUtils.isNotBlank(query.getSystem())) {
			sql.append(" AND c_system LIKE :system");
			parameterSource.addValue("system", "%" + query.getSystem() + "%");
		}

		// 系统操作类型
		if (StringUtils.isNotBlank(query.getOperate())) {
			sql.append(" AND n_log_type_detail = :detail");
			parameterSource.addValue("detail", query.getOperate());
		}
		
		if(1 != query.getUserType()) {
			sql.append(" AND (n_admin_id = :userId or c_system in (SELECT c_short_name FROM t_ucm_client WHERE n_id in (SELECT n_client_id FROM t_ucm_user_client WHERE n_user_id = :cUserId ) )) ");
			parameterSource.addValue("userId", query.getUserId());
			parameterSource.addValue("cUserId", query.getUserId());
		}
		//sql.append(" ORDER BY n_id DESC");
		SQLUtil util = new SQLUtil(sql.toString());
		return queryForObject(util.getCountSQL(), parameterSource, Integer.class);
	}
}
