package com.xdja.base.ucm.systemlog.entity;

import com.xdja.base.util.Constants;

/**
 * @ProjectName：ucm
 * @ClassName：SystemLog
 * @Description：系统日志
 * @author: mayanpei
 * @date: 2014-8-14 上午9:09:12
 */
public class SystemLog {
	// id
	private Long id;

	// 管理员ID
	private Long adminId;

	// 管理员帐户名
	private String administrator;

	// ip地址
	private String ip;

	// 日志内容
	private String logContent;

	// 日志级别:1-debug,2-info,3-warn,4-error
	private Integer logLevel;

	// 日志类型:1-登录退出，2-操作日志，3-运行日志，4-安全日志
	private Integer logType = Constants.UCM_LOG_TYPE.operateLog.value;

	private Integer logTypeDetail;

	// 记录日志时间
	private Long time = System.currentTimeMillis();

	// 所属系统
	private String system = "ucm";

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getAdminId() {
		return adminId;
	}

	public void setAdminId(Long adminId) {
		this.adminId = adminId;
	}

	public String getAdministrator() {
		return administrator;
	}

	public void setAdministrator(String administrator) {
		this.administrator = administrator;
	}

	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public String getLogContent() {
		return logContent;
	}

	public void setLogContent(String logContent) {
		this.logContent = logContent;
	}

	public Integer getLogLevel() {
		return logLevel;
	}

	public void setLogLevel(Integer logLevel) {
		this.logLevel = logLevel;
	}

	public Integer getLogType() {
		return logType;
	}

	public void setLogType(Integer logType) {
		this.logType = logType;
	}

	public Integer getLogTypeDetail() {
		return logTypeDetail;
	}

	public void setLogTypeDetail(Integer logTypeDetail) {
		this.logTypeDetail = logTypeDetail;
	}

	public Long getTime() {
		return time;
	}

	public void setTime(Long time) {
		this.time = time;
	}

	public String getSystem() {
		return system;
	}

	public void setSystem(String system) {
		this.system = system;
	}

}
