package com.xdja.base.ucm.systemlog.manager;

import java.util.List;
import java.util.Map;

import com.xdja.base.ucm.systemlog.bean.QueryLog;
import com.xdja.base.ucm.systemlog.entity.SystemLog;

/**
 * @ProjectName：ucm
 * @ClassName：SystemLogManager
 * @Description：系统日志
 * @author: mayanpei
 * @date: 2014-8-13 下午3:39:37
 */
public interface SystemLogManager {

	/**
	 * @Description：保存系统日志
	 * @author: mayanpei
	 * @date: 2014-8-13 下午3:39:53
	 * @param log
	 *            日志
	 */
	void addSystemLog(SystemLog log);

	/**
	 * @Description：查询系统日志
	 * @author: mayanpei
	 * @date: 2014-8-14 上午10:28:30
	 * @param log
	 *            日志bean
	 * @return List<Map<String, Object>>
	 */
	List<Map<String, Object>> querySystemLogList(QueryLog log);

	/**
	 * @Description：查询系统日志
	 * @author: mayanpei
	 * @date: 2014-8-14 上午10:28:30
	 * @param log
	 *            日志bean
	 * @return int
	 */
	int querySystemLogCount(QueryLog log);
}
