package com.xdja.base.ucm.systemlog.manager.impl;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xdja.base.ucm.systemlog.bean.QueryLog;
import com.xdja.base.ucm.systemlog.dao.SystemLogDao;
import com.xdja.base.ucm.systemlog.entity.SystemLog;
import com.xdja.base.ucm.systemlog.manager.SystemLogManager;

/**
 * @ProjectName：ucm
 * @ClassName：SystemLogManagerImpl
 * @Description：系统日志接口实现类
 * @author: mayanpei
 * @date: 2014-9-3 下午4:35:21
 * 
 */
@Service
public class SystemLogManagerImpl implements SystemLogManager {

	@Autowired
	private SystemLogDao dao;

	@Override
	public void addSystemLog(SystemLog log) {
		dao.addSystemLog(log);
	}

	@Override
	public List<Map<String, Object>> querySystemLogList(QueryLog log) {
		return dao.querySystemLogList(log);
	}

	@Override
	public int querySystemLogCount(QueryLog log) {
		return dao.querySystemLogCount(log);
	}
}
