package com.xdja.base.ucm.user.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

import com.xdja.base.common.action.BaseAction;
import com.xdja.base.system.entity.User;
import com.xdja.base.ucm.role.manager.RoleManager;
import com.xdja.base.ucm.systemconfig.manager.ConfigManager;
import com.xdja.base.ucm.systemlog.entity.SystemLog;
import com.xdja.base.ucm.systemlog.manager.SystemLogManager;
import com.xdja.base.ucm.user.manager.UserManager;
import com.xdja.base.util.Constants;
import com.xdja.base.util.HttpSessionUtil;
import com.xdja.base.util.IPV4Util;
import com.xdja.base.util.PasswordUtils;

@Controller
public class UserAction extends BaseAction {

	@Autowired
	private UserManager manager;

	@Autowired
	private RoleManager roleManager;

	@Autowired
	private SystemLogManager logManager;

	@Autowired
	private ConfigManager configManager;

	@RequestMapping(value = { "/user/index.do" }, method = { org.springframework.web.bind.annotation.RequestMethod.POST })
	public String index(ModelMap map) {
		User user;
		try {
			user = HttpSessionUtil.getUser();
			if (null == user)
				return "login";

			map.put("role", this.manager.queryUserRole(user.getId()));
			map.put("roleList", this.roleManager.queryRoleList(null));
		} catch (Exception e) {
			this.logger.error("用户管理查询角色信息出错", e);
		}

		return "/ucm/user/index";
	}

	@RequestMapping(value = { "/user/queryDataList.do" }, method = { org.springframework.web.bind.annotation.RequestMethod.POST })
	public String queryDataList(ModelMap map, String loginName, String name, Integer pageSize, Integer pageNo) {
		User user = HttpSessionUtil.getUser();
		map.put("data", this.manager.queryUserList(user.getId(), loginName, name, pageSize, pageNo));
		return "/ucm/user/data";
	}

	@RequestMapping(value = { "/user/queryDataCount.do" }, method = { org.springframework.web.bind.annotation.RequestMethod.POST })
	public void queryDataCount(ModelMap map, String loginName, String name, HttpServletResponse response) {
		User user;
		try {
			user = HttpSessionUtil.getUser();
			toClient(getPageCount(Integer.valueOf(this.manager.queryUserCount(user.getId(), loginName, name))),
					response);
		} catch (Exception e) {
			this.logger.error("查询用户信息总数出错", e);
		}
	}

	@RequestMapping(value = { "/user/toAddUser.do" }, method = { org.springframework.web.bind.annotation.RequestMethod.POST })
	public String toAddUser(ModelMap map) {
		try {
			map.put("roleList", this.roleManager.queryRoleList(null));
		} catch (Exception e) {
			this.logger.error("查询有户角色信息出错", e);
		}
		return "/ucm/user/add";
	}

	@RequestMapping(value = { "/user/queryUserExsit.do" }, method = { org.springframework.web.bind.annotation.RequestMethod.POST })
	public void queryUserExsit(String loginName, HttpServletResponse response) {
		try {
			if (this.manager.queryUserExsit(loginName))
				toClient("{\"flag\":\"1\"}", response);
			else
				toClient("{\"flag\":\"0\"}", response);
		} catch (Exception e) {
			this.logger.error("判断用户名是否存在出错！", e);
		}
	}

	@RequestMapping(value = { "/user/saveUser.do" }, method = { org.springframework.web.bind.annotation.RequestMethod.POST })
	public void saveUser(User user, String roleIds, HttpServletResponse response, HttpServletRequest request) {
		try {
			this.manager.saveUser(user, roleIds);
			SystemLog log = new SystemLog();
			User us = HttpSessionUtil.getUser();
			log.setAdminId(us.getId());
			log.setAdministrator(us.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setLogContent("添加了用户(" + user.getLoginName() + ")");
			log.setLogTypeDetail(Integer.valueOf(Constants.UCM_LOG_TYPE_DETAIL.add.value));
			log.setLogType(Integer.valueOf(Constants.UCM_LOG_TYPE.operateLog.value));
			log.setLogLevel(Integer.valueOf(Constants.UCM_LOG_LEVEL.info.value));
			this.logManager.addSystemLog(log);
			log = null;
		} catch (Exception e) {
			this.logger.error("保存用户信息出错！", e);
			toClient("{\"flag\":\"0\"}", response);
		}
		toClient("{\"flag\":\"1\"}", response);
	}

	@RequestMapping(value = { "/user/delUser.do" }, method = { org.springframework.web.bind.annotation.RequestMethod.POST })
	public void delUser(Long userId, HttpServletResponse response, HttpServletRequest request) {
		User oldUser;
		try {
			oldUser = this.manager.queryUserById(userId);
			this.manager.deleteUser(userId);
			SystemLog log = new SystemLog();
			User us = HttpSessionUtil.getUser();
			log.setAdminId(us.getId());
			log.setAdministrator(us.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setLogContent("删除了用户(" + oldUser.getLoginName() + ")");
			log.setLogTypeDetail(Integer.valueOf(Constants.UCM_LOG_TYPE_DETAIL.delete.value));
			log.setLogType(Integer.valueOf(Constants.UCM_LOG_TYPE.operateLog.value));
			log.setLogLevel(Integer.valueOf(Constants.UCM_LOG_LEVEL.info.value));
			this.logManager.addSystemLog(log);
			log = null;
		} catch (Exception e) {
			this.logger.error("删除用户信息出错！", e);
			toClient("{\"flag\":\"0\"}", response);
		}
		toClient("{\"flag\":\"1\"}", response);
	}

	@RequestMapping(value = { "/user/queryUserById.do" }, method = { org.springframework.web.bind.annotation.RequestMethod.POST })
	public String queryUserById(Long userId, ModelMap map, HttpServletResponse response) {
		try {
			map.put("user", this.manager.queryUserById(userId));
			map.put("role", this.manager.queryUserRole(userId));
			map.put("roleList", this.roleManager.queryRoleList(null));
		} catch (Exception e) {
			this.logger.error("保存用户信息出错！", e);
		}
		return "/ucm/user/edit";
	}

	@RequestMapping(value = { "/user/updateUser.do" }, method = { org.springframework.web.bind.annotation.RequestMethod.POST })
	public void updateUser(User user, String roleIds, HttpServletResponse response, HttpServletRequest request) {
		try {
			this.manager.updateUser(user, roleIds);

			SystemLog log = new SystemLog();
			User us = HttpSessionUtil.getUser();
			log.setAdminId(us.getId());
			log.setAdministrator(us.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setLogContent("修改了用户(" + user.getLoginName() + ")");
			log.setLogTypeDetail(Integer.valueOf(Constants.UCM_LOG_TYPE_DETAIL.update.value));
			log.setLogType(Integer.valueOf(Constants.UCM_LOG_TYPE.operateLog.value));
			log.setLogLevel(Integer.valueOf(Constants.UCM_LOG_LEVEL.info.value));
			this.logManager.addSystemLog(log);
			log = null;
		} catch (Exception e) {
			this.logger.error("保存用户信息出错！", e);
			toClient("{\"flag\":\"0\"}", response);
		}
		toClient("{\"flag\":\"1\"}", response);
	}

	@RequestMapping(value = { "/user/updateUserPassword.do" }, method = { org.springframework.web.bind.annotation.RequestMethod.POST })
	public void setPassword(String oldPwd, String newPwd, HttpServletResponse response, HttpServletRequest request) {
		User user;
		try {
			user = HttpSessionUtil.getUser();
			if (user.getPassword().equals(PasswordUtils.encodePassword(oldPwd, user.getLoginName()))) {
				this.manager.updatePassword(user.getId(), PasswordUtils.encodePassword(newPwd, user.getLoginName()));

				SystemLog log = new SystemLog();
				User us = HttpSessionUtil.getUser();
				log.setAdminId(us.getId());
				log.setAdministrator(us.getLoginName());
				log.setIp(IPV4Util.getIpAddr(request));
				log.setLogContent("修改了个人密码");
				log.setLogTypeDetail(Integer.valueOf(Constants.UCM_LOG_TYPE_DETAIL.update.value));
				log.setLogType(Integer.valueOf(Constants.UCM_LOG_TYPE.operateLog.value));
				log.setLogLevel(Integer.valueOf(Constants.UCM_LOG_LEVEL.info.value));
				this.logManager.addSystemLog(log);
				log = null;

				toClient("{\"flag\":\"1\"}", response);
			} else {
				toClient("{\"flag\":\"2\"}", response);
			}
		} catch (Exception e) {
			this.logger.error("修改密码", e);
			toClient("{\"flag\":\"0\"}", response);
		}
	}

	@RequestMapping(value = { "/user/toChildSystem.do" }, method = { org.springframework.web.bind.annotation.RequestMethod.POST })
	public String toChildSystem(Long userId, ModelMap modelMap) {
		try {
			modelMap.put("data", this.configManager.queryConfigList(Long.valueOf(0L)));
			modelMap.put("userId", userId);
			modelMap.put("childSystem", this.manager.queryManageChildSystem(userId));
		} catch (Exception e) {
			this.logger.error("查询用户子系统管理信息出错！", e);
		}
		return "/ucm/user/fun";
	}

	@RequestMapping(value = { "/user/addManageChildSystem.do" }, method = { org.springframework.web.bind.annotation.RequestMethod.POST })
	public void addManageChildSystem(Long userId, String childSystemId, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			this.manager.addManageChildSystem(userId, childSystemId);

			User oldUser = this.manager.queryUserById(userId);

			User us = HttpSessionUtil.getUser();
			SystemLog log = new SystemLog();
			log.setAdminId(us.getId());
			log.setAdministrator(us.getLoginName());
			log.setIp(IPV4Util.getIpAddr(request));
			log.setLogContent("修改用户(" + oldUser.getLoginName() + ")可管理的子系统");
			log.setLogTypeDetail(Integer.valueOf(Constants.UCM_LOG_TYPE_DETAIL.update.value));
			log.setLogType(Integer.valueOf(Constants.UCM_LOG_TYPE.operateLog.value));
			log.setLogLevel(Integer.valueOf(Constants.UCM_LOG_LEVEL.info.value));

			this.logManager.addSystemLog(log);
			log = null;
			oldUser = null;
			toClient("{\"flag\":\"1\"}", response);
		} catch (Exception e) {
			this.logger.error("保存用可管理的子系统信息出错", e);
			toClient("{\"flag\":\"2\"}", response);
		}
	}

}
