package com.xdja.base.ucm.user.manager;

import java.util.List;
import java.util.Map;

import com.xdja.base.system.entity.User;

/**
 * @ProjectName：ucm
 * @ClassName：UserManager
 * @Description：用户管理
 * @author: mayanpei
 * @date: 2014-8-14 下午7:25:18
 */
public interface UserManager {

	/**
	 * @Description：查询用户
	 * @author: mayanpei
	 * @date: 2014-8-14 下午7:25:42
	 * @param adminId
	 *            管理员ID
	 * @param loginName
	 *            登录名
	 * @param name
	 *            管理员名称
	 * @return int
	 */
	int queryUserCount(Long adminId, String loginName, String name);

	/**
	 * @Description：查询用户
	 * @author: mayanpei
	 * @date: 2014-8-14 下午7:25:42
	 * @param adminId
	 *            管理员ID
	 * @param loginName
	 *            登录名
	 * @param name
	 *            管理员名称
	 * @param pageSize
	 *            一页显示条数
	 * @param currPage
	 *            当前页
	 * @return Pagination
	 */
	List<Map<String, Object>> queryUserList(Long adminId, String loginName, String name, Integer pageSize,
			Integer currPage);

	/**
	 * @Description：保存用户
	 * @author: mayanpei
	 * @date: 2014-8-14 下午7:26:35
	 * @param user
	 *            用户
	 * @param roleIds
	 *            角色ID
	 */
	void saveUser(User user, String roleIds);

	/**
	 * @Description：更新用户
	 * @author: mayanpei
	 * @date: 2014-8-15 下午3:31:35
	 * @param user
	 *            用户
	 * @param roleId
	 *            角色ID
	 */

	void updateUser(User user, String roleId);

	/**
	 * @Description：删除用户
	 * @author: mayanpei
	 * @date: 2014-8-14 下午7:26:58
	 * @param userId
	 *            用户ID
	 */
	void deleteUser(Long userId);

	/**
	 * @Description：初始化用户密码
	 * @author: mayanpei
	 * @date: 2014-8-14 下午7:27:10
	 * @param userId
	 *            用户ID
	 */
	void resetPassword(Long userId);

	/**
	 * @Description：
	 * @author: mayanpei
	 * @date: 2014-8-15 上午11:47:56
	 * @param userId
	 *            用户ID
	 * @return
	 */
	List<Map<String, Object>> queryUserRole(Long userId);

	/**
	 * @Description：保存管理员角色
	 * @author: mayanpei
	 * @date: 2014-7-18 上午9:51:03
	 * @param userId
	 *            管理员ID
	 * @param roleIds
	 *            角色ID
	 */
	void saveUserRole(Long userId, List<String> roleIds);

	/**
	 * @Description：根据用户ID查询用户信息
	 * @author: mayanpei
	 * @date: 2014-8-15 下午4:44:29
	 * @param userId
	 *            用户ID
	 * @return
	 */
	User queryUserById(Long userId);

	/**
	 * @Description：根据用户ID查询用户信息
	 * @author: mayanpei
	 * @date: 2014-8-13 下午4:41:09
	 * @param userId
	 *            用户ID
	 * @return
	 */
	List<Map<String, Object>> queryUserByUserId(Long userId);

	/**
	 * @Description：查询添加的用户名是否存在
	 * @author: mayanpei
	 * @date: 2014-8-18 下午3:18:32
	 * @param loginName
	 *            用户名
	 * @return
	 */
	boolean queryUserExsit(String loginName);

	/**
	 * @Description：修改密码
	 * @author: mayanpei
	 * @date: 2014-8-19 下午3:11:20
	 * @param userId
	 *            用户ID
	 * @param password
	 *            密码
	 */
	void updatePassword(Long userId, String password);

	/**
	 * @Description：根据用户ID，查询用户所管理的子系统
	 * @author: mayanpei
	 * @date: 2014-9-1 上午9:06:48
	 * @param userId
	 * @return List<Map<String, Object>>
	 */
	List<Map<String, Object>> queryManageChildSystem(Long userId);

	/**
	 * @Description：保存用户可管理的子系统
	 * @author: mayanpei
	 * @date: 2014-9-1 上午9:27:38
	 * @param userId
	 * @param childSystemId
	 */
	void addManageChildSystem(Long userId, String childSystemId);
}
