package com.xdja.base.ucm.user.manager.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xdja.base.system.entity.User;
import com.xdja.base.ucm.user.dao.UserDao;
import com.xdja.base.ucm.user.manager.UserManager;

/**
 * @ProjectName：ucm
 * @ClassName：UserManagerImpl
 * @Description：用户管理接口实现类
 * @author: mayanpei
 * @date: 2014-8-14 下午7:28:44
 */
@Service
public class UserManagerImpl implements UserManager {

	@Autowired
	private UserDao dao;

	@Override
	public List<Map<String, Object>> queryUserList(Long adminId, String loginName, String name, Integer pageSize,
			Integer pageNo) {
		return dao.queryUserList(adminId, loginName, name, pageSize, pageNo);
	}

	@Override
	public int queryUserCount(Long adminId, String loginName, String name) {
		return dao.queryUserCount(adminId, loginName, name);
	}

	@Override
	public void saveUser(User user, String roleIds) {
		user = dao.saveUser(user);
		saveUserRole(user.getId(), Arrays.asList(StringUtils.split(roleIds, ",")));
	}

	@Override
	public void deleteUser(Long userId) {
		dao.deleteUser(userId);
	}

	@Override
	public void resetPassword(Long userId) {
		dao.resetPassword(userId);
	}

	@Override
	public List<Map<String, Object>> queryUserRole(Long userId) {
		return dao.queryUserRole(userId);
	}

	@Override
	public void updateUser(User user, String roleIds) {
		dao.updateUser(user, roleIds);
	}

	@Override
	public void saveUserRole(Long userId, List<String> roleIds) {
		dao.saveUserRole(userId, roleIds);
	}

	@Override
	public User queryUserById(Long userId) {
		return dao.queryUserById(userId);
	}

	@Override
	public List<Map<String, Object>> queryUserByUserId(Long userId) {
		return dao.queryUserByUserId(userId);
	}

	@Override
	public boolean queryUserExsit(String loginName) {
		if (dao.queryUserExsit(loginName).size() > 0) {
			return false;
		}
		return true;
	}

	@Override
	public void updatePassword(Long userId, String password) {
		dao.updatePassword(userId, password);
	}

	@Override
	public List<Map<String, Object>> queryManageChildSystem(Long userId) {
		return dao.queryManageChildSystem(userId);
	}

	@Override
	public void addManageChildSystem(Long userId, String childSystemId) {
		dao.addManageChildSystem(userId, childSystemId);
	}
}
