package com.xdja.base.util;

/**
 * @ProjectName：ucm
 * @ClassName：Constants
 * @Description：系统全局配置常量
 * @author: mayanpei
 * @date: 2014-9-3 上午11:15:16
 */
public class Constants {
	
	public final static Long MENU_ROOT_ID = 0L;//菜单根路径

	public final static String LOGIN_USER = "USER"; // 全局登录用户

	public final static String ANONYMOUS_USER = "anonymousUser";// 匿名登录

	public final static String USER_STAUT_NORMAL = "1";// 正常

	public final static String USER_STAUT_UNUSE = "2";// 停用

	public final static String USER_PASSWORD = "xdjaUcm123";// 添加用户默认的密码

	public final static Integer SUPER_ADMINISTRATOR = 1; // 超级管理员

	public final static Integer USUAL_ADMINISTRATOR = 2;// 普通管理员

	public final static Integer STATIC_DATA_TYPE_TEXT = 1; // 用户保存系统配置静态数据类型 普通文本

	public final static Integer STATIC_DATA_TYPE_FILE = 2;// 用户保存系统配置静态数据类型 文件

	public final static Long UPLOAD_FILE_SIZE = 30000L; // 上传最大的文件30KB
	
	public final static Integer SEND_RESULT_UNSEND = 0 ; // 未发送子系统静态配置参数

	public final static Integer SEND_RESULT_SUCCESS = 1; // 发送子系统静态配置参数成功

	public final static Integer SEND_RESULT_FAIL = 2; // 发送子系统静态配置参数失败
	
	public final static Integer SEND_TIME_OUT = 1;
	
	//公共数据特定的系统名称
	public static String COMMON_SYSTEM_CLIENT = "common";
	
	//私有数据
	public static String DATA_TYPE_OF_PRIVATE = "1";
	
	//公共数据
	public static String DATA_TYPE_OF_PUBLIC = "2";
	
	public static final String SEND_RESULT ="sendResult";
	

	/**
	 * @ProjectName：ucm
	 * @ClassName：ENUM_LOG_LEVEL
	 * @Description：日志级别定义
	 * @author: mayanpei
	 * @date: 2014-8-14 上午10:55:59
	 * 
	 */
	public enum UCM_LOG_LEVEL {
		debug(1), info(2), warn(3), error(4), trace(5);

		public int value;

		private UCM_LOG_LEVEL(int value) {
			this.value = value;
		}
	}

	/**
	 * 
	 * @ProjectName：ucm
	 * @ClassName：ENUM_LOG_TYPE
	 * @Description：日志类型定义
	 * @author: mayanpei
	 * @date: 2013-11-27 下午3:38:28
	 */
	public enum UCM_LOG_TYPE {
		// 登录日志
		loginLog(1),
		// 操作日志
		operateLog(2),
		// 运行日志
		runtimeLog(3),
		// 安全日志
		securityLog(4);

		public int value;

		private UCM_LOG_TYPE(int value) {
			this.value = value;
		}
	}

	/**
	 * 
	 * @ProjectName：ucm
	 * @ClassName：ENUM_LOG_TYPE
	 * @Description：日志类型定义
	 * @author: mayanpei
	 * @date: 2013-11-27 下午3:38:28
	 */
	public enum UCM_LOG_TYPE_DETAIL {
		
		//登录
		login(101),
		//下线
		loginOut(102),
		// 添加
		add(201),
		// 删除
		delete(202),
		// 修改
		update(203),
		// 查询
		query(204),
		// 发送
		send(205),
		// 上传
		upload(206),
		// 下载
		download(207);

		public int value;

		private UCM_LOG_TYPE_DETAIL(int value) {
			this.value = value;
		}
	}
}
