package com.xdja.base.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import org.apache.commons.lang.StringUtils;

/**
 * @ProjectName：ucm
 * @ClassName：DateUtils
 * @Description：时间工具类
 * @author: mayanpei
 * @date: 2014-5-9 9:20:18
 * 
 */
public class DateUtils {

	// 时间戳
	public final static String START = " 00:00:00";

	public final static String END = " 23:59:59";

	public final static String YMD = "yyyy-MM-dd";

	public final static String FULL_DATE = "yyyy-MM-dd HH:mm:ss";

	/**
	 * 
	 * @Description：获得当前日期的时间戳
	 * @author: mayanpei
	 * @date: 2014-5-20 上午10:37:33
	 * @return 当前完整格式日期
	 */
	public static String getToday() {
		SimpleDateFormat sdf = new SimpleDateFormat(FULL_DATE);
		return sdf.format(new Date());
	}

	/**
	 * 
	 * @Description：获得当前日期的时间戳
	 * @author: mayanpei
	 * @date: 2014-5-20 上午10:37:33
	 * @param format
	 *            格式
	 * @return 当前完整格式日期
	 */
	public static String getToday(String format) {
		SimpleDateFormat sdf = null;
		if (StringUtils.isNotBlank(format)) {
			sdf = new SimpleDateFormat(format);
		}
		sdf = new SimpleDateFormat(FULL_DATE);
		return sdf.format(new Date());
	}

	/**
	 * 
	 * @Description：获取当月第一天
	 * @author: mayanpei
	 * @date: 2014-5-20 上午10:39:33
	 * @return 得到当月第一天
	 */
	public static String getFirstDayOfMonth() {
		SimpleDateFormat sdf = new SimpleDateFormat(YMD);
		Calendar lastDate = Calendar.getInstance();
		lastDate.set(Calendar.DATE, 1); // 将日期设为当前月的1号
		return sdf.format(lastDate.getTime());
	}

	/**
	 * 获取当前日期前一天（最后）
	 * 
	 * @Description：
	 * @author:mayanpei
	 * @date: 2014-6-3 上午10:39:59
	 * @return
	 */
	public static String getLastDay() {
		SimpleDateFormat sdf = new SimpleDateFormat(YMD + END);
		Calendar lastDate = Calendar.getInstance();
		lastDate.add(Calendar.DAY_OF_MONTH, -1);
		return sdf.format(lastDate.getTime());
	}

	/**
	 * @Description ： 得到当前时间的前一天
	 * @author: mayanpei
	 * @date: 2014-6-10 下午4:08:56
	 * @return 得到当前时间的前一天 格 式为“yyyyMMdd”
	 * @throws Exception
	 */
	public static String getYesterdate() {
		SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
		Calendar rightNow = Calendar.getInstance();
		rightNow.add(Calendar.DATE, -1);
		return formatter.format(rightNow.getTime());
	}

	/**
	 * @Description：格式化日期
	 * @author: mayanpei
	 * @date: 2014-5-19 下午8:12:40
	 * @param formate
	 *            要格式的样式
	 * @return：格式化后的日期
	 */
	public static String getFormateDate(String formate) {
		if (StringUtils.isBlank(formate)) {
			formate = FULL_DATE;
		}
		SimpleDateFormat formateMethod = new SimpleDateFormat(formate);
		return formateMethod.format(new Date());
	}

	/**
	 * @Description：格式化日期
	 * @author: mayanpei
	 * @date: 2014-5-19 下午8:12:40
	 * @param formate  要格式的样式
	 * @param dateStr  要格式化的时间
	 * @return：格式化后的日期
	 */
	public static String getFormateDate(String formate, String dateStr) {
		Date date = null;
		SimpleDateFormat formateMethod = null;
		String result = "";
		try {
			if (StringUtils.isBlank(formate)) {
				formate = FULL_DATE;
			}
			if (StringUtils.isBlank(dateStr)) {
				formate = getToday();
			}
			formateMethod = new SimpleDateFormat(formate);
			date = formateMethod.parse(dateStr);
			result = formateMethod.format(date);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return result;
	}

	/**
	 * @Description：格式化日期
	 * @author: mayanpei
	 * @date: 2014-5-19 下午8:12:40
	 * @param formate
	 *            要格式的样式
	 * @param dateStr
	 *            要格式化的时间
	 * @return：格式化后的日期
	 */
	public static Date formateDate(String formate, String dateStr) {
		Date date = null;
		SimpleDateFormat formateMethod = null;
		try {
			if (StringUtils.isBlank(formate)) {
				formate = FULL_DATE;
			}
			if (StringUtils.isBlank(dateStr)) {
				formate = getToday();
			}
			formateMethod = new SimpleDateFormat(formate);
			date = formateMethod.parse(dateStr);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return date;
	}

	/**
	 * 
	 * @Description：获取前一天 月份的第一天
	 * @author: mayanpei
	 * @date: 2014-5-20 上午10:39:33
	 * @return 得到前一天 月份的第一天
	 */
	public static String getLastDayFirstDayOfMonth() {
		SimpleDateFormat sdf = new SimpleDateFormat(YMD);
		Calendar calendar = Calendar.getInstance();
		calendar.add(Calendar.DAY_OF_MONTH, -1);
		calendar.set(Calendar.DATE, 1); // 将日期设为当前月的1号
		return sdf.format(calendar.getTime());
	}

	/**
	 * @Description：日期转long
	 * @author: mayanpei
	 * @date: 2014-8-14 上午10:08:33
	 * @param dataStr
	 *            日期字符串
	 * @return
	 */
	public static Long dateToLong(String dataStr) {
		Calendar calendar = Calendar.getInstance();
		if (dataStr.indexOf(":") == 2) {
			calendar.setTime(formateDate(null, dataStr));
		} else {
			calendar.setTime(formateDate(FULL_DATE, dataStr + START));
		}
		return calendar.getTimeInMillis();
	}

	/**
	 * @Description：long转日期
	 * @author: mayanpei
	 * @date: 2014-8-14 上午10:08:33
	 * @param dataStr
	 *            日期字符串
	 * @param formate
	 *            格式化方式
	 * @return
	 */
	public static String longToDate(Long dataStr, String formate) {
		if (StringUtils.isBlank(formate)) {
			formate = FULL_DATE;
		}
		SimpleDateFormat formateMethod = new SimpleDateFormat(formate);
		Calendar calendar = Calendar.getInstance();
		calendar.setTimeInMillis(dataStr);
		return formateMethod.format(calendar.getTime());
	}
}
