package com.xdja.base.util;

import java.io.File;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import com.xdja.base.system.entity.User;

/**
 * @ProjectName：ucm
 * @ClassName：HttpSessionUtil
 * @Description：
 * @author: mayanpei
 * @date: 2014-8-14 下午7:48:53
 * 
 */
public class HttpSessionUtil {

	/**
	 * @Description方法描述：获取request对象
	 * @author: mayanpei
	 * @date: 2014-8-14 上午11:28:26
	 * @return
	 */
	public static HttpServletRequest getRequest() {
		return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
	}

	/**
	 * @Description方法描述：获取系统部署的根路径
	 * @author: mayanpei
	 * @date: 2014-8-14 上午11:28:34
	 * @return
	 */
	public static String getRootPath() {
		return ContextLoader.getCurrentWebApplicationContext().getServletContext().getRealPath("/");
	}

	/**
	 * @Description：获得上传文件的目录
	 * @author: mayanpei
	 * @date: 2014-5-14 上午10:50:38
	 * @param request
	 * @return 上传文件的目录
	 */
	public static String getUploadPath() {
		
		String path = ContextLoader.getCurrentWebApplicationContext().getServletContext().getRealPath("/")+"upload/";
		
		File f = new File(path);
		
		if (!f.exists()) {
			f.mkdirs();
		}	
		
		f = null;
		
		return path;
	}

	/**
	 * 
	 * @Description方法描述：获得session唯一编号
	 * @author: mayanpei
	 * @date: 2014-8-14 上午11:28:34
	 * @return
	 */
	public static String getSessionId() {
		return getRequest().getSession().getId();
	}

	/**
	 * @Description:获得USER对象
	 * @author: mayanpei
	 * @date: 2014-8-14 下午7:47:49
	 * @return User
	 */
	public static User getUser() {
		if (getRequest().getSession().getAttribute(Constants.LOGIN_USER) != null) {
			return (User) getRequest().getSession().getAttribute(Constants.LOGIN_USER);
		}
		return null;
	}
}
