package com.xdja.base.util;

import java.net.InetAddress;

import javax.servlet.http.HttpServletRequest;

/**
 * @ProjectName：ucm
 * @ClassName：IPV4Util
 * @Description：IP地址与数值型IP转换
 * @author: mayanpei
 * @date: 2014-5-22 下午2:01:54
 * 
 */
public class IPV4Util {

	/**
	 * @Description：数值型IP转换成分点式IP
	 * @author: mayanpei
	 * @date: 2014-5-22 下午1:57:09
	 * @param longIP
	 * @return 点分式IP
	 */
	public static String longToIP(long longIP) {
		StringBuffer sb = new StringBuffer("");
		sb.append(String.valueOf(longIP >>> 24));// 直接右移24位
		sb.append(".");
		sb.append(String.valueOf((longIP & 0x00FFFFFF) >>> 16)); // 将高8位置0，然后右移16位
		sb.append(".");
		sb.append(String.valueOf((longIP & 0x0000FFFF) >>> 8));
		sb.append(".");
		sb.append(String.valueOf(longIP & 0x000000FF));
		return sb.toString();
	}

	/**
	 * @Description 分点式IP转换成数值型IP
	 * @author: mayanpei
	 * @date: 2014-5-22 下午1:57:31
	 * @param strIP
	 * @return 数值型IP
	 */
	public static long ipToLong(String strIP) {
		long[] ip = new long[4];

		int position1 = strIP.indexOf(".");
		int position2 = strIP.indexOf(".", position1 + 1);
		int position3 = strIP.indexOf(".", position2 + 1);

		ip[0] = Long.parseLong(strIP.substring(0, position1));
		ip[1] = Long.parseLong(strIP.substring(position1 + 1, position2));
		ip[2] = Long.parseLong(strIP.substring(position2 + 1, position3));
		ip[3] = Long.parseLong(strIP.substring(position3 + 1));
		long value = (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];

		return value; // ip1*256*256*256+ip2*256*256+ip3*256+ip4
	}

	/**
	 * @Description 获得IP地址
	 * @author: mayanpei
	 * @date: 2014-8-28 下午3:15:30
	 * @param request
	 *            请求
	 * @return ip
	 */
	public static String getIpAddr(HttpServletRequest request) {
		String ip = request.getHeader("X-Forwarded-For");
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("WL-Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("HTTP_CLIENT_IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("HTTP_X_FORWARDED_FOR");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getRemoteAddr();
		}
		try {
			if ("0:0:0:0:0:0:0:1".equals(ip)) {
				ip = InetAddress.getLocalHost().getHostAddress();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return ip;
	}
}
