package com.xdja.base.util;

import java.security.MessageDigest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @ProjectName：ucm
 * @ClassName：Md5Util
 * @Description：MD5加密工具类
 * @author: mayanpei
 * @date: 2014-9-3 上午11:16:00
 * 
 */
public class Md5Util {
	private static Logger logger = LoggerFactory.getLogger(Md5Util.class);

	/**
	 * 
	 * @author: mayanpei
	 * @date: 2014-8-19 下午2:07:31
	 * @param arrIn
	 * @return
	 */
	public static String getHexMD5Str(String arrIn) {
		try {
			MessageDigest md = MessageDigest.getInstance("MD5");
			byte[] arrB = md.digest(arrIn.getBytes());
			StringBuffer sb = new StringBuffer(32);
			for (int i = 0; i < arrB.length; i++) {
				int intTmp = arrB[i];
				while (intTmp < 0) {
					intTmp = intTmp + 256;
				}
				if (intTmp < 16) {
					sb.append('0');
				}
				sb.append(Integer.toString(intTmp, 16));
			}
			return sb.toString().toUpperCase();
		} catch (Exception e) {
			logger.error("Md5加密算法失败：");
			e.printStackTrace();
			return "";
		}
	}

	public static void main(String[] args) {
		try {
			System.out.println(getHexMD5Str("123456"));
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
