package com.xdja.base.util;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
/**
 * 通过spring对每个方法的执行时间进行打印
 * 用于性能监测
 * @ProjectName：oms-web
 * @ClassName：MethodTimeAdvice
 * @Description：
 * @author: michael
 * @date: 2013-12-23 上午10:04:51
 * */
public class MethodTimeAdvice implements MethodInterceptor {
	private  Logger logger=LoggerFactory.getLogger(this.getClass()); 
//	private static Map<String ,Long>  classInvokeTimes =new ConcurrentHashMap(String,Long);
	
	@Override
	public Object invoke(MethodInvocation invocation) throws Throwable {
		  	// TODO Auto-generated method stub
			//用 commons-lang 提供的 StopWatch 计时，Spring 也提供了一个 StopWatch  
	        StopWatch clock = new StopWatch();  
	        clock.start(); //计时开始  
	        Object result = invocation.proceed();  
	        clock.stop();  //计时结束           //方法参数类型，转换成简单类型  
	        Class<?> [] params = invocation.getMethod().getParameterTypes();  
	        String[] simpleParams = new String[params.length];  
	        for (int i = 0; i < params.length; i++) {  
	            simpleParams[i] = params[i].getSimpleName();  
	        }  
	        long timeCount=clock.getTime();
	        //if(timeCount >= 100)
	        	if(logger.isDebugEnabled())
	        		logger.debug("该方法执行耗费:" + timeCount + " ms ["  
	                + invocation.getThis().getClass().getName() + "."  
	                + invocation.getMethod().getName() + "("+StringUtils.join(simpleParams,",")+")] ");  
	        return result;   
	}

}
