package com.xdja.base.util;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSONObject;

/**
 * @ProjectName：ucm
 * @ClassName：SystemConstants
 * @Description：静态常池，用以系统配置参数修改
 * @author: mayanpei
 * @date: 2014-8-29 下午2:37:05
 * 
 */
public class SystemConstants {

	private static Logger logger = LoggerFactory.getLogger(SystemConstants.class);

	private static HashMap<String, String> constantsPool;

	private static SystemConstants systemConstants = new SystemConstants();

	private SystemConstants() {
		constantsPool = new HashMap<String, String>();
	}

	public static SystemConstants getInstances() {
		if (constantsPool == null) {
			systemConstants = new SystemConstants();
		}
		return systemConstants;
	}

	/**
	 * 向常量池中添加数据
	 * 
	 * @param key
	 *            参数值 value 参数value
	 * @throws Exception
	 *             参数不正确时，抛出异常
	 */
	public void addSystemParam(String key, String value) throws Exception {
		if (null == key || "".equals(key) || key.length() == 0) {
			throw new Exception("系统配置增加参数出错：key " + key + "：对应的 value 不正确");
		} else {
			constantsPool.put(key, value);
		}
	}

	/**
	 * 放入系统常量池中
	 * 
	 * @param json
	 *            系统配置的键、值用json封装
	 */
	public void init(JSONObject json) {
		try {
			logger.info(json.toJSONString());
			// systemConstants.addSystemParam(json.getString("dataKey"),
			// json.getString("dataValue").replace("'", "\""));
		} catch (Exception e) {
			logger.error("Plarbar System startup error. Conf init error.");
			e.printStackTrace();
		}
	}

	/**
	 * 获取系统配置参数
	 * 
	 * @param key
	 *            参数对应的key
	 * @return value
	 */
	public String getSystemParam(String key) {
		return constantsPool.get(key);
	}

	public Map<String, String> getAllSystemParam() {
		return constantsPool;
	}
}
